/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class HistoryWindow
extends FixedFrame
implements CbButtonCallback,
ActionListener {
    List hlist;
    CbButton ok_b;
    CbButton cancel_b;
    FileManager filemgr;

    HistoryWindow(FileManager fileManager) {
        this.filemgr = fileManager;
        this.setTitle(this.filemgr.text("history_title"));
        this.hlist = new List();
        for (int i = 0; i < this.filemgr.history_list.size(); ++i) {
            this.hlist.add((String)this.filemgr.history_list.elementAt(i));
        }
        this.hlist.addActionListener(this);
        this.setLayout(new BorderLayout());
        this.add("Center", this.hlist);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(2));
        this.ok_b = new CbButton(this.filemgr.get_image("save.gif"), this.filemgr.text("history_ok"), 0, this);
        panel.add(this.ok_b);
        this.cancel_b = new CbButton(this.filemgr.get_image("cancel.gif"), this.filemgr.text("cancel"), 0, this);
        panel.add(this.cancel_b);
        this.add("South", panel);
        Util.recursiveBody(this);
        this.pack();
        this.show();
    }

    public void click(CbButton cbButton) {
        String string;
        if (cbButton == this.cancel_b) {
            this.dispose();
        } else if (cbButton == this.ok_b && (string = this.hlist.getSelectedItem()) != null) {
            this.filemgr.find_directory(string, true);
            this.dispose();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.hlist.getSelectedItem();
        this.filemgr.find_directory(string, true);
        this.dispose();
    }

    public Dimension minimumSize() {
        return new Dimension(300, 300);
    }
}

