/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.DoubleByte;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.IBM949;

public class IBM949C
extends Charset
implements HistoricallyNamedCharset {
    static final char[] b2cSB;
    static final char[] c2b;
    static final char[] c2bIndex;

    public IBM949C() {
        super("x-IBM949C", ExtendedCharsets.aliasesFor("x-IBM949C"));
    }

    @Override
    public String historicalName() {
        return "Cp949C";
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.name().equals("US-ASCII") || cs instanceof IBM949C;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new DoubleByte.Decoder(this, IBM949.b2c, b2cSB, 161, 254);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new DoubleByte.Encoder((Charset)this, c2b, c2bIndex);
    }

    static {
        int i;
        IBM949.initb2c();
        b2cSB = new char[256];
        for (i = 0; i < 128; ++i) {
            IBM949C.b2cSB[i] = (char)i;
        }
        for (i = 128; i < 256; ++i) {
            IBM949C.b2cSB[i] = IBM949.b2cSB[i];
        }
        IBM949.initc2b();
        c2b = Arrays.copyOf(IBM949.c2b, IBM949.c2b.length);
        c2bIndex = Arrays.copyOf(IBM949.c2bIndex, IBM949.c2bIndex.length);
        for (int c = 0; c < 128; c = (int)((char)(c + 1))) {
            char index = c2bIndex[c >> 8];
            IBM949C.c2b[index + (c & 0xFF)] = c;
        }
    }
}

