/*
 * Decompiled with CFR 0.152.
 */
package IceGrid;

import Ice.Current;
import Ice.InputStream;
import Ice.ObjectImpl;
import Ice.OperationMode;
import Ice.OperationNotExistException;
import Ice.OutputStream;
import Ice.UserException;
import IceGrid.AdminSessionPrx;
import IceGrid.AdminSessionPrxHelper;
import IceGrid.PermissionDeniedException;
import IceGrid.Registry;
import IceGrid.SessionPrx;
import IceGrid.SessionPrxHelper;
import IceInternal.Incoming;
import java.util.Arrays;

public abstract class _RegistryDisp
extends ObjectImpl
implements Registry {
    private static final String[] _ids = new String[]{"::Ice::Object", "::IceGrid::Registry"};
    private static final String[] _all = new String[]{"createAdminSession", "createAdminSessionFromSecureConnection", "createSession", "createSessionFromSecureConnection", "getACMTimeout", "getSessionTimeout", "ice_id", "ice_ids", "ice_isA", "ice_ping"};
    public static final long serialVersionUID = 0L;

    @Override
    public boolean ice_isA(String s) {
        return Arrays.binarySearch(_ids, s) >= 0;
    }

    @Override
    public boolean ice_isA(String s, Current current) {
        return Arrays.binarySearch(_ids, s) >= 0;
    }

    @Override
    public String[] ice_ids() {
        return _ids;
    }

    @Override
    public String[] ice_ids(Current current) {
        return _ids;
    }

    @Override
    public String ice_id() {
        return _ids[1];
    }

    @Override
    public String ice_id(Current current) {
        return _ids[1];
    }

    public static String ice_staticId() {
        return _ids[1];
    }

    @Override
    public final AdminSessionPrx createAdminSession(String userId, String password) throws PermissionDeniedException {
        return this.createAdminSession(userId, password, null);
    }

    @Override
    public final AdminSessionPrx createAdminSessionFromSecureConnection() throws PermissionDeniedException {
        return this.createAdminSessionFromSecureConnection(null);
    }

    @Override
    public final SessionPrx createSession(String userId, String password) throws PermissionDeniedException {
        return this.createSession(userId, password, null);
    }

    @Override
    public final SessionPrx createSessionFromSecureConnection() throws PermissionDeniedException {
        return this.createSessionFromSecureConnection(null);
    }

    @Override
    public final int getACMTimeout() {
        return this.getACMTimeout(null);
    }

    @Override
    public final int getSessionTimeout() {
        return this.getSessionTimeout(null);
    }

    public static boolean _iceD_createSession(Registry obj, Incoming inS, Current current) throws UserException {
        _RegistryDisp._iceCheckMode(OperationMode.Normal, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_userId = istr.readString();
        String iceP_password = istr.readString();
        inS.endReadParams();
        SessionPrx ret = obj.createSession(iceP_userId, iceP_password, current);
        OutputStream ostr = inS.startWriteParams();
        SessionPrxHelper.write(ostr, ret);
        inS.endWriteParams();
        return true;
    }

    public static boolean _iceD_createAdminSession(Registry obj, Incoming inS, Current current) throws UserException {
        _RegistryDisp._iceCheckMode(OperationMode.Normal, current.mode);
        InputStream istr = inS.startReadParams();
        String iceP_userId = istr.readString();
        String iceP_password = istr.readString();
        inS.endReadParams();
        AdminSessionPrx ret = obj.createAdminSession(iceP_userId, iceP_password, current);
        OutputStream ostr = inS.startWriteParams();
        AdminSessionPrxHelper.write(ostr, ret);
        inS.endWriteParams();
        return true;
    }

    public static boolean _iceD_createSessionFromSecureConnection(Registry obj, Incoming inS, Current current) throws UserException {
        _RegistryDisp._iceCheckMode(OperationMode.Normal, current.mode);
        inS.readEmptyParams();
        SessionPrx ret = obj.createSessionFromSecureConnection(current);
        OutputStream ostr = inS.startWriteParams();
        SessionPrxHelper.write(ostr, ret);
        inS.endWriteParams();
        return true;
    }

    public static boolean _iceD_createAdminSessionFromSecureConnection(Registry obj, Incoming inS, Current current) throws UserException {
        _RegistryDisp._iceCheckMode(OperationMode.Normal, current.mode);
        inS.readEmptyParams();
        AdminSessionPrx ret = obj.createAdminSessionFromSecureConnection(current);
        OutputStream ostr = inS.startWriteParams();
        AdminSessionPrxHelper.write(ostr, ret);
        inS.endWriteParams();
        return true;
    }

    public static boolean _iceD_getSessionTimeout(Registry obj, Incoming inS, Current current) throws UserException {
        _RegistryDisp._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        int ret = obj.getSessionTimeout(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeInt(ret);
        inS.endWriteParams();
        return true;
    }

    public static boolean _iceD_getACMTimeout(Registry obj, Incoming inS, Current current) throws UserException {
        _RegistryDisp._iceCheckMode(OperationMode.Idempotent, current.mode);
        inS.readEmptyParams();
        int ret = obj.getACMTimeout(current);
        OutputStream ostr = inS.startWriteParams();
        ostr.writeInt(ret);
        inS.endWriteParams();
        return true;
    }

    @Override
    public boolean _iceDispatch(Incoming in, Current current) throws UserException {
        int pos = Arrays.binarySearch(_all, current.operation);
        if (pos < 0) {
            throw new OperationNotExistException(current.id, current.facet, current.operation);
        }
        switch (pos) {
            case 0: {
                return _RegistryDisp._iceD_createAdminSession(this, in, current);
            }
            case 1: {
                return _RegistryDisp._iceD_createAdminSessionFromSecureConnection(this, in, current);
            }
            case 2: {
                return _RegistryDisp._iceD_createSession(this, in, current);
            }
            case 3: {
                return _RegistryDisp._iceD_createSessionFromSecureConnection(this, in, current);
            }
            case 4: {
                return _RegistryDisp._iceD_getACMTimeout(this, in, current);
            }
            case 5: {
                return _RegistryDisp._iceD_getSessionTimeout(this, in, current);
            }
            case 6: {
                return _RegistryDisp._iceD_ice_id(this, in, current);
            }
            case 7: {
                return _RegistryDisp._iceD_ice_ids(this, in, current);
            }
            case 8: {
                return _RegistryDisp._iceD_ice_isA(this, in, current);
            }
            case 9: {
                return _RegistryDisp._iceD_ice_ping(this, in, current);
            }
        }
        assert (false);
        throw new OperationNotExistException(current.id, current.facet, current.operation);
    }

    @Override
    protected void _iceWriteImpl(OutputStream ostr_) {
        ostr_.startSlice(_RegistryDisp.ice_staticId(), -1, true);
        ostr_.endSlice();
    }

    @Override
    protected void _iceReadImpl(InputStream istr_) {
        istr_.startSlice();
        istr_.endSlice();
    }
}

