/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.textarea;

import java.util.Iterator;
import org.gjt.sp.jedit.Debug;
import org.gjt.sp.jedit.buffer.BufferListener;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.FirstLine;
import org.gjt.sp.jedit.textarea.ScrollLineCount;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.jedit.textarea.TextArea;

class BufferHandler
implements BufferListener {
    private final DisplayManager displayManager;
    private final TextArea textArea;
    private final JEditBuffer buffer;
    private boolean delayedUpdate;
    private boolean delayedMultilineUpdate;
    private int delayedUpdateStart;
    private int delayedUpdateEnd;

    BufferHandler(DisplayManager displayManager, TextArea textArea, JEditBuffer jEditBuffer) {
        this.displayManager = displayManager;
        this.textArea = textArea;
        this.buffer = jEditBuffer;
    }

    @Override
    public void bufferLoaded(JEditBuffer jEditBuffer) {
        this.displayManager.bufferLoaded();
        this.textArea._finishCaretUpdate();
    }

    @Override
    public void foldHandlerChanged(JEditBuffer jEditBuffer) {
        this.displayManager.foldHandlerChanged();
    }

    @Override
    public void foldLevelChanged(JEditBuffer jEditBuffer, int n, int n2) {
        if (this.textArea.getDisplayManager() == this.displayManager && n2 != 0 && !jEditBuffer.isLoading()) {
            this.textArea.invalidateLineRange(n - 1, this.textArea.getLastPhysicalLine());
        }
    }

    @Override
    public void contentInserted(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
        if (jEditBuffer.isLoading()) {
            return;
        }
        this.displayManager.screenLineMgr.contentInserted(n, n3);
        int n5 = n + n3;
        if (n3 != 0) {
            this.delayedMultilineUpdate = true;
        }
        this.displayManager.folds.contentInserted(n, n3);
        FirstLine firstLine = this.displayManager.firstLine;
        ScrollLineCount scrollLineCount = this.displayManager.scrollLineCount;
        if (this.textArea.getDisplayManager() == this.displayManager) {
            firstLine.contentInserted(n, n3);
            scrollLineCount.contentInserted(n, n3);
            if (this.delayedUpdateEnd >= n) {
                this.delayedUpdateEnd += n3;
            }
            this.delayUpdate(n, n5);
            Iterator<Selection> iterator = this.textArea.getSelectionIterator();
            while (iterator.hasNext()) {
                Selection selection = iterator.next();
                if (!selection.contentInserted(jEditBuffer, n, n2, n3, n4)) continue;
                this.delayUpdate(selection.startLine, selection.endLine);
            }
            int n6 = this.textArea.getCaretPosition();
            if (n6 >= n2) {
                int n7 = this.textArea.caretAutoScroll() ? 2 : 0;
                this.textArea.moveCaretPosition(n6 + n4, n7);
            } else {
                int n8 = this.textArea.caretAutoScroll() ? 1 : 0;
                this.textArea.moveCaretPosition(n6, n8);
            }
        } else {
            firstLine.setCallReset(true);
            scrollLineCount.setCallReset(true);
        }
    }

    @Override
    public void preContentInserted(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
        if (jEditBuffer.isLoading()) {
            return;
        }
        if (this.textArea.getDisplayManager() == this.displayManager) {
            this.getReadyToBreakFold(n);
            this.displayManager.firstLine.preContentInserted(n, n3);
            this.displayManager.scrollLineCount.preContentInserted(n, n3);
        }
    }

    @Override
    public void preContentRemoved(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
        if (jEditBuffer.isLoading()) {
            return;
        }
        FirstLine firstLine = this.displayManager.firstLine;
        ScrollLineCount scrollLineCount = this.displayManager.scrollLineCount;
        if (this.textArea.getDisplayManager() == this.displayManager) {
            if (n3 == 0) {
                this.getReadyToBreakFold(n);
            } else {
                int n5 = n + n3;
                if (!this.displayManager.isLineVisible(n) || !this.displayManager.isLineVisible(n5) || n2 != jEditBuffer.getLineStartOffset(n) || n2 + n4 != jEditBuffer.getLineStartOffset(n5)) {
                    this.getReadyToBreakFold(n);
                    this.getReadyToBreakFold(n5);
                }
            }
            firstLine.preContentRemoved(n, n2, n3);
            scrollLineCount.preContentRemoved(n, n2, n3);
            if (this.delayedUpdateEnd >= n) {
                this.delayedUpdateEnd -= n3;
            }
            this.delayUpdate(n, n);
        } else {
            firstLine.setCallReset(true);
            scrollLineCount.setCallReset(true);
        }
        this.displayManager.screenLineMgr.contentRemoved(n, n3);
        if (n3 == 0) {
            return;
        }
        this.delayedMultilineUpdate = true;
        if (this.displayManager.folds.preContentRemoved(n, n3)) {
            this.displayManager.folds.reset(jEditBuffer.getLineCount());
            firstLine.setCallReset(true);
            scrollLineCount.setCallReset(true);
        }
        if (firstLine.getPhysicalLine() > this.displayManager.getLastVisibleLine() || firstLine.getPhysicalLine() < this.displayManager.getFirstVisibleLine()) {
            // empty if block
        }
    }

    @Override
    public void contentRemoved(JEditBuffer jEditBuffer, int n, int n2, int n3, int n4) {
        if (jEditBuffer.isLoading()) {
            return;
        }
        FirstLine firstLine = this.displayManager.firstLine;
        ScrollLineCount scrollLineCount = this.displayManager.scrollLineCount;
        if (this.textArea.getDisplayManager() == this.displayManager) {
            firstLine.contentRemoved(n, n2, n3);
            scrollLineCount.contentRemoved(n, n2, n3);
            int n5 = this.textArea.getSelectionCount();
            Iterator<Selection> iterator = this.textArea.getSelectionIterator();
            while (iterator.hasNext()) {
                Selection selection = iterator.next();
                if (!selection.contentRemoved(jEditBuffer, n, n2, n3, n4)) continue;
                this.delayUpdate(selection.startLine, selection.endLine);
                if (n5 != 1 || selection.start != selection.end) continue;
                iterator.remove();
            }
            int n6 = this.textArea.getCaretPosition();
            if (n6 >= n2 + n4) {
                int n7 = this.textArea.caretAutoScroll() ? 2 : 0;
                this.textArea.moveCaretPosition(n6 - n4, n7);
            } else if (n6 >= n2) {
                int n8 = this.textArea.caretAutoScroll() ? 2 : 0;
                this.textArea.moveCaretPosition(n2, n8);
            } else {
                int n9 = this.textArea.caretAutoScroll() ? 1 : 0;
                this.textArea.moveCaretPosition(n6, n9);
            }
        }
    }

    @Override
    public void transactionComplete(JEditBuffer jEditBuffer) {
        if (this.textArea.getDisplayManager() != this.displayManager) {
            this.delayedUpdate = false;
            return;
        }
        if (this.delayedUpdate) {
            this.doDelayedUpdate();
        }
        this.textArea._finishCaretUpdate();
        this.delayedUpdate = false;
        if (Debug.SCROLL_VERIFY) {
            int n = this.delayedUpdateStart;
            if (!this.displayManager.isLineVisible(n)) {
                n = this.displayManager.getNextVisibleLine(n);
            }
            System.err.println(this.delayedUpdateStart + ":" + this.delayedUpdateEnd + ':' + this.textArea.getLineCount());
            int n2 = 0;
            while (n != -1 && n <= this.delayedUpdateEnd) {
                n2 += this.displayManager.getScreenLineCount(n);
                n = this.displayManager.getNextVisibleLine(n);
            }
            if (n2 != this.displayManager.getScrollLineCount()) {
                throw new InternalError(n2 + " != " + this.displayManager.getScrollLineCount());
            }
        }
    }

    private void doDelayedUpdate() {
        this.displayManager.notifyScreenLineChanges();
        if (this.delayedMultilineUpdate) {
            this.textArea.invalidateScreenLineRange(this.textArea.chunkCache.getScreenLineOfOffset(this.delayedUpdateStart, 0), this.textArea.getVisibleLines());
            this.delayedMultilineUpdate = false;
        } else {
            this.textArea.invalidateLineRange(this.delayedUpdateStart, this.delayedUpdateEnd);
        }
        int n = this.textArea.getVisibleLines();
        if (n != 0) {
            this.textArea.chunkCache.getLineInfo(n - 1);
        }
        this.buffer.getFoldLevel(this.delayedUpdateEnd);
    }

    private void delayUpdate(int n, int n2) {
        this.textArea.chunkCache.invalidateChunksFromPhys(n);
        if (!this.delayedUpdate) {
            this.delayedUpdateStart = n;
            this.delayedUpdateEnd = n2;
            this.delayedUpdate = true;
        } else {
            this.delayedUpdateStart = Math.min(this.delayedUpdateStart, n);
            this.delayedUpdateEnd = Math.max(this.delayedUpdateEnd, n2);
        }
    }

    private void getReadyToBreakFold(int n) {
        this.displayManager.expandFold(n, false);
    }
}

