/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.util;

import java.io.FileInputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jruby.org.objectweb.asm.AnnotationVisitor;
import org.jruby.org.objectweb.asm.Attribute;
import org.jruby.org.objectweb.asm.ClassReader;
import org.jruby.org.objectweb.asm.ClassVisitor;
import org.jruby.org.objectweb.asm.FieldVisitor;
import org.jruby.org.objectweb.asm.Label;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.ModuleVisitor;
import org.jruby.org.objectweb.asm.Type;
import org.jruby.org.objectweb.asm.TypePath;
import org.jruby.org.objectweb.asm.tree.ClassNode;
import org.jruby.org.objectweb.asm.tree.MethodNode;
import org.jruby.org.objectweb.asm.tree.analysis.Analyzer;
import org.jruby.org.objectweb.asm.tree.analysis.BasicValue;
import org.jruby.org.objectweb.asm.tree.analysis.Frame;
import org.jruby.org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.jruby.org.objectweb.asm.util.CheckAnnotationAdapter;
import org.jruby.org.objectweb.asm.util.CheckFieldAdapter;
import org.jruby.org.objectweb.asm.util.CheckMethodAdapter;
import org.jruby.org.objectweb.asm.util.CheckModuleAdapter;
import org.jruby.org.objectweb.asm.util.Textifier;
import org.jruby.org.objectweb.asm.util.TraceMethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckClassAdapter
extends ClassVisitor {
    private int version;
    private boolean start;
    private boolean source;
    private boolean outer;
    private boolean end;
    private boolean module;
    private Map<Label, Integer> labels = new HashMap<Label, Integer>();
    private boolean checkDataFlow;

    public static void main(String[] args2) throws Exception {
        if (args2.length != 1) {
            System.err.println("Verifies the given class.");
            System.err.println("Usage: CheckClassAdapter <fully qualified class name or class file name>");
            return;
        }
        ClassReader cr = args2[0].endsWith(".class") ? new ClassReader(new FileInputStream(args2[0])) : new ClassReader(args2[0]);
        CheckClassAdapter.verify(cr, false, new PrintWriter(System.err));
    }

    public static void verify(ClassReader cr, ClassLoader loader, boolean dump2, PrintWriter pw) {
        ClassNode cn = new ClassNode();
        cr.accept(new CheckClassAdapter(cn, false), 2);
        Type syperType = cn.superName == null ? null : Type.getObjectType(cn.superName);
        List<MethodNode> methods2 = cn.methods;
        ArrayList<Type> interfaces2 = new ArrayList<Type>();
        Iterator<String> i2 = cn.interfaces.iterator();
        while (i2.hasNext()) {
            interfaces2.add(Type.getObjectType(i2.next()));
        }
        for (int i3 = 0; i3 < methods2.size(); ++i3) {
            MethodNode method = methods2.get(i3);
            SimpleVerifier verifier = new SimpleVerifier(Type.getObjectType(cn.name), syperType, interfaces2, (cn.access & 0x200) != 0);
            Analyzer<BasicValue> a = new Analyzer<BasicValue>(verifier);
            if (loader != null) {
                verifier.setClassLoader(loader);
            }
            try {
                a.analyze(cn.name, method);
                if (!dump2) {
                    continue;
                }
            }
            catch (Exception e) {
                e.printStackTrace(pw);
            }
            CheckClassAdapter.printAnalyzerResult(method, a, pw);
        }
        pw.flush();
    }

    public static void verify(ClassReader cr, boolean dump2, PrintWriter pw) {
        CheckClassAdapter.verify(cr, null, dump2, pw);
    }

    static void printAnalyzerResult(MethodNode method, Analyzer<BasicValue> a, PrintWriter pw) {
        int j;
        Frame<BasicValue>[] frames = a.getFrames();
        Textifier t = new Textifier();
        TraceMethodVisitor mv = new TraceMethodVisitor(t);
        pw.println(method.name + method.desc);
        for (j = 0; j < method.instructions.size(); ++j) {
            method.instructions.get(j).accept(mv);
            StringBuilder sb = new StringBuilder();
            Frame<BasicValue> f = frames[j];
            if (f == null) {
                sb.append('?');
            } else {
                int k;
                for (k = 0; k < f.getLocals(); ++k) {
                    sb.append(CheckClassAdapter.getShortName(f.getLocal(k).toString())).append(' ');
                }
                sb.append(" : ");
                for (k = 0; k < f.getStackSize(); ++k) {
                    sb.append(CheckClassAdapter.getShortName(f.getStack(k).toString())).append(' ');
                }
            }
            while (sb.length() < method.maxStack + method.maxLocals + 1) {
                sb.append(' ');
            }
            pw.print(Integer.toString(j + 100000).substring(1));
            pw.print(" " + sb + " : " + t.text.get(t.text.size() - 1));
        }
        for (j = 0; j < method.tryCatchBlocks.size(); ++j) {
            method.tryCatchBlocks.get(j).accept(mv);
            pw.print(" " + t.text.get(t.text.size() - 1));
        }
        pw.println();
    }

    private static String getShortName(String name2) {
        int n = name2.lastIndexOf(47);
        int k = name2.length();
        if (name2.charAt(k - 1) == ';') {
            --k;
        }
        return n == -1 ? name2 : name2.substring(n + 1, k);
    }

    public CheckClassAdapter(ClassVisitor cv) {
        this(cv, true);
    }

    public CheckClassAdapter(ClassVisitor cv, boolean checkDataFlow) {
        this(393216, cv, checkDataFlow);
        if (this.getClass() != CheckClassAdapter.class) {
            throw new IllegalStateException();
        }
    }

    protected CheckClassAdapter(int api, ClassVisitor cv, boolean checkDataFlow) {
        super(api, cv);
        this.checkDataFlow = checkDataFlow;
    }

    @Override
    public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces2) {
        if (this.start) {
            throw new IllegalStateException("visit must be called only once");
        }
        this.start = true;
        this.checkState();
        CheckClassAdapter.checkAccess(access, 456241);
        if (name2 == null) {
            throw new IllegalArgumentException("Illegal class name (null)");
        }
        if (!name2.endsWith("package-info")) {
            CheckMethodAdapter.checkInternalName(name2, "class name");
        }
        if ("java/lang/Object".equals(name2)) {
            if (superName != null) {
                throw new IllegalArgumentException("The super class name of the Object class must be 'null'");
            }
        } else {
            CheckMethodAdapter.checkInternalName(superName, "super class name");
        }
        if (signature != null) {
            CheckClassAdapter.checkClassSignature(signature);
        }
        if ((access & 0x200) != 0 && !"java/lang/Object".equals(superName)) {
            throw new IllegalArgumentException("The super class name of interfaces must be 'java/lang/Object'");
        }
        if (interfaces2 != null) {
            for (int i2 = 0; i2 < interfaces2.length; ++i2) {
                CheckMethodAdapter.checkInternalName(interfaces2[i2], "interface name at index " + i2);
            }
        }
        this.version = version;
        super.visit(version, access, name2, signature, superName, interfaces2);
    }

    @Override
    public void visitSource(String file2, String debug) {
        this.checkState();
        if (this.source) {
            throw new IllegalStateException("visitSource can be called only once.");
        }
        this.source = true;
        super.visitSource(file2, debug);
    }

    @Override
    public ModuleVisitor visitModule(String name2, int access, String version) {
        this.checkState();
        if (this.module) {
            throw new IllegalStateException("visitModule can be called only once.");
        }
        this.module = true;
        if (name2 == null) {
            throw new IllegalArgumentException("Illegal module name (null)");
        }
        CheckClassAdapter.checkAccess(access, 4128);
        return new CheckModuleAdapter(super.visitModule(name2, access, version), (access & 0x20) != 0);
    }

    @Override
    public void visitOuterClass(String owner2, String name2, String desc) {
        this.checkState();
        if (this.outer) {
            throw new IllegalStateException("visitOuterClass can be called only once.");
        }
        this.outer = true;
        if (owner2 == null) {
            throw new IllegalArgumentException("Illegal outer class owner");
        }
        if (desc != null) {
            CheckMethodAdapter.checkMethodDesc(desc);
        }
        super.visitOuterClass(owner2, name2, desc);
    }

    @Override
    public void visitInnerClass(String name2, String outerName, String innerName, int access) {
        this.checkState();
        CheckMethodAdapter.checkInternalName(name2, "class name");
        if (outerName != null) {
            CheckMethodAdapter.checkInternalName(outerName, "outer class name");
        }
        if (innerName != null) {
            int start2;
            for (start2 = 0; start2 < innerName.length() && Character.isDigit(innerName.charAt(start2)); ++start2) {
            }
            if (start2 == 0 || start2 < innerName.length()) {
                CheckMethodAdapter.checkIdentifier(innerName, start2, -1, "inner class name");
            }
        }
        CheckClassAdapter.checkAccess(access, 30239);
        super.visitInnerClass(name2, outerName, innerName, access);
    }

    @Override
    public FieldVisitor visitField(int access, String name2, String desc, String signature, Object value2) {
        this.checkState();
        CheckClassAdapter.checkAccess(access, 413919);
        CheckMethodAdapter.checkUnqualifiedName(this.version, name2, "field name");
        CheckMethodAdapter.checkDesc(desc, false);
        if (signature != null) {
            CheckClassAdapter.checkFieldSignature(signature);
        }
        if (value2 != null) {
            CheckMethodAdapter.checkConstant(value2);
        }
        FieldVisitor av = super.visitField(access, name2, desc, signature, value2);
        return new CheckFieldAdapter(av);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name2, String desc, String signature, String[] exceptions) {
        this.checkState();
        CheckClassAdapter.checkAccess(access, 400895);
        if (!"<init>".equals(name2) && !"<clinit>".equals(name2)) {
            CheckMethodAdapter.checkMethodIdentifier(this.version, name2, "method name");
        }
        CheckMethodAdapter.checkMethodDesc(desc);
        if (signature != null) {
            CheckClassAdapter.checkMethodSignature(signature);
        }
        if (exceptions != null) {
            for (int i2 = 0; i2 < exceptions.length; ++i2) {
                CheckMethodAdapter.checkInternalName(exceptions[i2], "exception name at index " + i2);
            }
        }
        CheckMethodAdapter cma = this.checkDataFlow ? new CheckMethodAdapter(access, name2, desc, super.visitMethod(access, name2, desc, signature, exceptions), this.labels) : new CheckMethodAdapter(super.visitMethod(access, name2, desc, signature, exceptions), this.labels);
        cma.version = this.version;
        return cma;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.checkState();
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(super.visitAnnotation(desc, visible));
    }

    @Override
    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String desc, boolean visible) {
        this.checkState();
        int sort2 = typeRef >>> 24;
        if (sort2 != 0 && sort2 != 17 && sort2 != 16) {
            throw new IllegalArgumentException("Invalid type reference sort 0x" + Integer.toHexString(sort2));
        }
        CheckClassAdapter.checkTypeRefAndPath(typeRef, typePath);
        CheckMethodAdapter.checkDesc(desc, false);
        return new CheckAnnotationAdapter(super.visitTypeAnnotation(typeRef, typePath, desc, visible));
    }

    @Override
    public void visitAttribute(Attribute attr2) {
        this.checkState();
        if (attr2 == null) {
            throw new IllegalArgumentException("Invalid attribute (must not be null)");
        }
        super.visitAttribute(attr2);
    }

    @Override
    public void visitEnd() {
        this.checkState();
        this.end = true;
        super.visitEnd();
    }

    private void checkState() {
        if (!this.start) {
            throw new IllegalStateException("Cannot visit member before visit has been called.");
        }
        if (this.end) {
            throw new IllegalStateException("Cannot visit member after visitEnd has been called.");
        }
    }

    static void checkAccess(int access, int possibleAccess) {
        int abs3;
        int pro;
        if ((access & ~possibleAccess) != 0) {
            throw new IllegalArgumentException("Invalid access flags: " + access);
        }
        int pub = (access & 1) == 0 ? 0 : 1;
        int pri = (access & 2) == 0 ? 0 : 1;
        int n = pro = (access & 4) == 0 ? 0 : 1;
        if (pub + pri + pro > 1) {
            throw new IllegalArgumentException("public private and protected are mutually exclusive: " + access);
        }
        int fin = (access & 0x10) == 0 ? 0 : 1;
        int n2 = abs3 = (access & 0x400) == 0 ? 0 : 1;
        if (fin + abs3 > 1) {
            throw new IllegalArgumentException("final and abstract are mutually exclusive: " + access);
        }
    }

    public static void checkClassSignature(String signature) {
        int pos2 = 0;
        if (CheckClassAdapter.getChar(signature, 0) == '<') {
            pos2 = CheckClassAdapter.checkFormalTypeParameters(signature, pos2);
        }
        pos2 = CheckClassAdapter.checkClassTypeSignature(signature, pos2);
        while (CheckClassAdapter.getChar(signature, pos2) == 'L') {
            pos2 = CheckClassAdapter.checkClassTypeSignature(signature, pos2);
        }
        if (pos2 != signature.length()) {
            throw new IllegalArgumentException(signature + ": error at index " + pos2);
        }
    }

    public static void checkMethodSignature(String signature) {
        int pos2 = 0;
        if (CheckClassAdapter.getChar(signature, 0) == '<') {
            pos2 = CheckClassAdapter.checkFormalTypeParameters(signature, pos2);
        }
        pos2 = CheckClassAdapter.checkChar('(', signature, pos2);
        while ("ZCBSIFJDL[T".indexOf(CheckClassAdapter.getChar(signature, pos2)) != -1) {
            pos2 = CheckClassAdapter.checkTypeSignature(signature, pos2);
        }
        pos2 = CheckClassAdapter.getChar(signature, pos2 = CheckClassAdapter.checkChar(')', signature, pos2)) == 'V' ? ++pos2 : CheckClassAdapter.checkTypeSignature(signature, pos2);
        while (CheckClassAdapter.getChar(signature, pos2) == '^') {
            if (CheckClassAdapter.getChar(signature, ++pos2) == 'L') {
                pos2 = CheckClassAdapter.checkClassTypeSignature(signature, pos2);
                continue;
            }
            pos2 = CheckClassAdapter.checkTypeVariableSignature(signature, pos2);
        }
        if (pos2 != signature.length()) {
            throw new IllegalArgumentException(signature + ": error at index " + pos2);
        }
    }

    public static void checkFieldSignature(String signature) {
        int pos2 = CheckClassAdapter.checkFieldTypeSignature(signature, 0);
        if (pos2 != signature.length()) {
            throw new IllegalArgumentException(signature + ": error at index " + pos2);
        }
    }

    static void checkTypeRefAndPath(int typeRef, TypePath typePath) {
        int mask = 0;
        switch (typeRef >>> 24) {
            case 0: 
            case 1: 
            case 22: {
                mask = -65536;
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 64: 
            case 65: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                mask = -16777216;
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 23: 
            case 66: {
                mask = -256;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: {
                mask = -16776961;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid type reference sort 0x" + Integer.toHexString(typeRef >>> 24));
            }
        }
        if ((typeRef & ~mask) != 0) {
            throw new IllegalArgumentException("Invalid type reference 0x" + Integer.toHexString(typeRef));
        }
        if (typePath != null) {
            for (int i2 = 0; i2 < typePath.getLength(); ++i2) {
                int step2 = typePath.getStep(i2);
                if (step2 != 0 && step2 != 1 && step2 != 3 && step2 != 2) {
                    throw new IllegalArgumentException("Invalid type path step " + i2 + " in " + typePath);
                }
                if (step2 == 3 || typePath.getStepArgument(i2) == 0) continue;
                throw new IllegalArgumentException("Invalid type path step argument for step " + i2 + " in " + typePath);
            }
        }
    }

    private static int checkFormalTypeParameters(String signature, int pos2) {
        pos2 = CheckClassAdapter.checkChar('<', signature, pos2);
        pos2 = CheckClassAdapter.checkFormalTypeParameter(signature, pos2);
        while (CheckClassAdapter.getChar(signature, pos2) != '>') {
            pos2 = CheckClassAdapter.checkFormalTypeParameter(signature, pos2);
        }
        return pos2 + 1;
    }

    private static int checkFormalTypeParameter(String signature, int pos2) {
        pos2 = CheckClassAdapter.checkIdentifier(signature, pos2);
        if ("L[T".indexOf(CheckClassAdapter.getChar(signature, pos2 = CheckClassAdapter.checkChar(':', signature, pos2))) != -1) {
            pos2 = CheckClassAdapter.checkFieldTypeSignature(signature, pos2);
        }
        while (CheckClassAdapter.getChar(signature, pos2) == ':') {
            pos2 = CheckClassAdapter.checkFieldTypeSignature(signature, pos2 + 1);
        }
        return pos2;
    }

    private static int checkFieldTypeSignature(String signature, int pos2) {
        switch (CheckClassAdapter.getChar(signature, pos2)) {
            case 'L': {
                return CheckClassAdapter.checkClassTypeSignature(signature, pos2);
            }
            case '[': {
                return CheckClassAdapter.checkTypeSignature(signature, pos2 + 1);
            }
        }
        return CheckClassAdapter.checkTypeVariableSignature(signature, pos2);
    }

    private static int checkClassTypeSignature(String signature, int pos2) {
        pos2 = CheckClassAdapter.checkChar('L', signature, pos2);
        pos2 = CheckClassAdapter.checkIdentifier(signature, pos2);
        while (CheckClassAdapter.getChar(signature, pos2) == '/') {
            pos2 = CheckClassAdapter.checkIdentifier(signature, pos2 + 1);
        }
        if (CheckClassAdapter.getChar(signature, pos2) == '<') {
            pos2 = CheckClassAdapter.checkTypeArguments(signature, pos2);
        }
        while (CheckClassAdapter.getChar(signature, pos2) == '.') {
            if (CheckClassAdapter.getChar(signature, pos2 = CheckClassAdapter.checkIdentifier(signature, pos2 + 1)) != '<') continue;
            pos2 = CheckClassAdapter.checkTypeArguments(signature, pos2);
        }
        return CheckClassAdapter.checkChar(';', signature, pos2);
    }

    private static int checkTypeArguments(String signature, int pos2) {
        pos2 = CheckClassAdapter.checkChar('<', signature, pos2);
        pos2 = CheckClassAdapter.checkTypeArgument(signature, pos2);
        while (CheckClassAdapter.getChar(signature, pos2) != '>') {
            pos2 = CheckClassAdapter.checkTypeArgument(signature, pos2);
        }
        return pos2 + 1;
    }

    private static int checkTypeArgument(String signature, int pos2) {
        char c = CheckClassAdapter.getChar(signature, pos2);
        if (c == '*') {
            return pos2 + 1;
        }
        if (c == '+' || c == '-') {
            ++pos2;
        }
        return CheckClassAdapter.checkFieldTypeSignature(signature, pos2);
    }

    private static int checkTypeVariableSignature(String signature, int pos2) {
        pos2 = CheckClassAdapter.checkChar('T', signature, pos2);
        pos2 = CheckClassAdapter.checkIdentifier(signature, pos2);
        return CheckClassAdapter.checkChar(';', signature, pos2);
    }

    private static int checkTypeSignature(String signature, int pos2) {
        switch (CheckClassAdapter.getChar(signature, pos2)) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                return pos2 + 1;
            }
        }
        return CheckClassAdapter.checkFieldTypeSignature(signature, pos2);
    }

    private static int checkIdentifier(String signature, int pos2) {
        if (!Character.isJavaIdentifierStart(CheckClassAdapter.getChar(signature, pos2))) {
            throw new IllegalArgumentException(signature + ": identifier expected at index " + pos2);
        }
        ++pos2;
        while (Character.isJavaIdentifierPart(CheckClassAdapter.getChar(signature, pos2))) {
            ++pos2;
        }
        return pos2;
    }

    private static int checkChar(char c, String signature, int pos2) {
        if (CheckClassAdapter.getChar(signature, pos2) == c) {
            return pos2 + 1;
        }
        throw new IllegalArgumentException(signature + ": '" + c + "' expected at index " + pos2);
    }

    private static char getChar(String signature, int pos2) {
        return pos2 < signature.length() ? signature.charAt(pos2) : (char)'\u0000';
    }
}

