/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;

final class Model3D {
    float[] vert;
    int[] tvert;
    int nvert;
    int maxvert;
    int[] con;
    int ncon;
    int maxcon;
    boolean transformed;
    Matrix3D mat = new Matrix3D();
    float xmin;
    float xmax;
    float ymin;
    float ymax;
    float zmin;
    float zmax;
    static Color[] gr;

    Model3D() {
        this.mat.xrot(20.0);
        this.mat.yrot(30.0);
    }

    /*
     * Unable to fully structure code
     */
    Model3D(InputStream is) throws IOException, FileFormatException {
        this();
        st = new StreamTokenizer(new BufferedReader(new InputStreamReader(is, "UTF-8")));
        st.eolIsSignificant(true);
        st.commentChar(35);
        block4: while (true) {
            switch (st.nextToken()) {
                default: {
                    break block4;
                }
                case 10: {
                    continue block4;
                }
                case -3: {
                    if ("v".equals(st.sval)) {
                        x = 0.0;
                        y = 0.0;
                        z = 0.0;
                        if (st.nextToken() == -2) {
                            x = st.nval;
                            if (st.nextToken() == -2) {
                                y = st.nval;
                                if (st.nextToken() == -2) {
                                    z = st.nval;
                                }
                            }
                        }
                        this.addVert((float)x, (float)y, (float)z);
                        while (true) {
                            if (st.ttype == 10 || st.ttype == -1) continue block4;
                            st.nextToken();
                        }
                    }
                    if ("f".equals(st.sval) || "fo".equals(st.sval) || "l".equals(st.sval)) {
                        start = -1;
                        prev = -1;
                        n = -1;
                        while (true) {
                            if (st.nextToken() == -2) {
                                n = (int)st.nval;
                                if (prev >= 0) {
                                    this.add(prev - 1, n - 1);
                                }
                                if (start < 0) {
                                    start = n;
                                }
                                prev = n;
                                continue;
                            }
                            if (st.ttype != 47) break;
                            st.nextToken();
                        }
                        if (start >= 0) {
                            this.add(start - 1, prev - 1);
                        }
                        if (st.ttype == 10) continue block4;
                        break block4;
                    }
                    while (true) {
                        if (st.nextToken() != 10 && st.ttype != -1) ** break;
                        continue block4;
                    }
                }
            }
            break;
        }
        is.close();
        if (st.ttype != -1) {
            throw new FileFormatException(st.toString());
        }
    }

    int addVert(float x, float y, float z) {
        int i = this.nvert;
        if (i >= this.maxvert) {
            if (this.vert == null) {
                this.maxvert = 100;
                this.vert = new float[this.maxvert * 3];
            } else {
                this.maxvert *= 2;
                float[] nv = new float[this.maxvert * 3];
                System.arraycopy(this.vert, 0, nv, 0, this.vert.length);
                this.vert = nv;
            }
        }
        this.vert[i *= 3] = x;
        this.vert[i + 1] = y;
        this.vert[i + 2] = z;
        return this.nvert++;
    }

    void add(int p1, int p2) {
        int i = this.ncon;
        if (p1 >= this.nvert || p2 >= this.nvert) {
            return;
        }
        if (i >= this.maxcon) {
            if (this.con == null) {
                this.maxcon = 100;
                this.con = new int[this.maxcon];
            } else {
                this.maxcon *= 2;
                int[] nv = new int[this.maxcon];
                System.arraycopy(this.con, 0, nv, 0, this.con.length);
                this.con = nv;
            }
        }
        if (p1 > p2) {
            int t = p1;
            p1 = p2;
            p2 = t;
        }
        this.con[i] = p1 << 16 | p2;
        this.ncon = i + 1;
    }

    void transform() {
        if (this.transformed || this.nvert <= 0) {
            return;
        }
        if (this.tvert == null || this.tvert.length < this.nvert * 3) {
            this.tvert = new int[this.nvert * 3];
        }
        this.mat.transform(this.vert, this.tvert, this.nvert);
        this.transformed = true;
    }

    private void quickSort(int[] a, int left, int right) {
        int leftIndex = left;
        int rightIndex = right;
        if (right > left) {
            int partionElement = a[(left + right) / 2];
            while (leftIndex <= rightIndex) {
                while (leftIndex < right && a[leftIndex] < partionElement) {
                    ++leftIndex;
                }
                while (rightIndex > left && a[rightIndex] > partionElement) {
                    --rightIndex;
                }
                if (leftIndex > rightIndex) continue;
                this.swap(a, leftIndex, rightIndex);
                ++leftIndex;
                --rightIndex;
            }
            if (left < rightIndex) {
                this.quickSort(a, left, rightIndex);
            }
            if (leftIndex < right) {
                this.quickSort(a, leftIndex, right);
            }
        }
    }

    private void swap(int[] a, int i, int j) {
        int T = a[i];
        a[i] = a[j];
        a[j] = T;
    }

    void compress() {
        int limit = this.ncon;
        int[] c = this.con;
        this.quickSort(this.con, 0, this.ncon - 1);
        int d = 0;
        int pp1 = -1;
        for (int i = 0; i < limit; ++i) {
            int p1 = c[i];
            if (pp1 != p1) {
                c[d] = p1;
                ++d;
            }
            pp1 = p1;
        }
        this.ncon = d;
    }

    void paint(Graphics g) {
        if (this.vert == null || this.nvert <= 0) {
            return;
        }
        this.transform();
        if (gr == null) {
            gr = new Color[16];
            for (int i = 0; i < 16; ++i) {
                int grey = (int)(170.0 * (1.0 - Math.pow((double)i / 15.0, 2.3)));
                Model3D.gr[i] = new Color(grey, grey, grey);
            }
        }
        int lg = 0;
        int lim = this.ncon;
        int[] c = this.con;
        int[] v = this.tvert;
        if (lim <= 0 || this.nvert <= 0) {
            return;
        }
        for (int i = 0; i < lim; ++i) {
            int T = c[i];
            int p1 = (T >> 16 & 0xFFFF) * 3;
            int p2 = (T & 0xFFFF) * 3;
            int grey = v[p1 + 2] + v[p2 + 2];
            if (grey < 0) {
                grey = 0;
            }
            if (grey > 15) {
                grey = 15;
            }
            if (grey != lg) {
                lg = grey;
                g.setColor(gr[grey]);
            }
            g.drawLine(v[p1], v[p1 + 1], v[p2], v[p2 + 1]);
        }
    }

    void findBB() {
        float _zmin;
        float _ymin;
        float _xmin;
        if (this.nvert <= 0) {
            return;
        }
        float[] v = this.vert;
        float _xmax = _xmin = v[0];
        float _ymax = _ymin = v[1];
        float _zmax = _zmin = v[2];
        int i = this.nvert * 3;
        while ((i -= 3) > 0) {
            float z;
            float y;
            float x = v[i];
            if (x < _xmin) {
                _xmin = x;
            }
            if (x > _xmax) {
                _xmax = x;
            }
            if ((y = v[i + 1]) < _ymin) {
                _ymin = y;
            }
            if (y > _ymax) {
                _ymax = y;
            }
            if ((z = v[i + 2]) < _zmin) {
                _zmin = z;
            }
            if (!(z > _zmax)) continue;
            _zmax = z;
        }
        this.xmax = _xmax;
        this.xmin = _xmin;
        this.ymax = _ymax;
        this.ymin = _ymin;
        this.zmax = _zmax;
        this.zmin = _zmin;
    }
}

