/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.goal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.server.ai.AIMessage;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.goal.Goal;
import net.sf.freecol.server.ai.goal.GotoAdjacentGoal;

public class CreateMissionAtSettlementGoal
extends Goal {
    private static final Logger logger = Logger.getLogger(CreateMissionAtSettlementGoal.class.getName());
    private final IndianSettlement target;
    private GotoAdjacentGoal gotoSubGoal;

    public CreateMissionAtSettlementGoal(AIPlayer p, Goal g, float w, AIUnit u, IndianSettlement i) {
        super(p, g, w, u);
        this.target = i;
        this.gotoSubGoal = null;
    }

    @Override
    protected Iterator<AIUnit> getOwnedAIUnitsIterator() {
        return this.availableUnitsList.iterator();
    }

    @Override
    protected Iterator<Goal> getSubGoalIterator() {
        ArrayList<GotoAdjacentGoal> subGoalList = new ArrayList<GotoAdjacentGoal>();
        if (this.gotoSubGoal != null) {
            subGoalList.add(this.gotoSubGoal);
        }
        return subGoalList.iterator();
    }

    @Override
    protected void removeUnit(AIUnit u) {
        Iterator uit = this.availableUnitsList.iterator();
        while (uit.hasNext()) {
            AIUnit unit = (AIUnit)uit.next();
            if (!unit.equals(u)) continue;
            uit.remove();
        }
    }

    @Override
    protected void plan() {
        this.isFinished = false;
        if (this.gotoSubGoal != null) {
            this.validateOwnedUnits();
            Iterator uit = this.availableUnitsList.iterator();
            while (uit.hasNext()) {
                AIUnit u = (AIUnit)uit.next();
                uit.remove();
                this.addUnitToParent(u);
            }
            if (this.gotoSubGoal.isFinished()) {
                List<AIUnit> units = this.gotoSubGoal.cancelGoal();
                this.availableUnitsList.addAll(units);
                this.gotoSubGoal = null;
            }
        }
        if (this.gotoSubGoal == null) {
            this.validateOwnedUnits();
            boolean hasFoundMissionary = false;
            Iterator uit = this.availableUnitsList.iterator();
            while (uit.hasNext()) {
                AIUnit u = (AIUnit)uit.next();
                uit.remove();
                if (!"model.role.missionary".equals(u.getUnit().getRole().getId())) continue;
                if (!hasFoundMissionary) {
                    hasFoundMissionary = true;
                    if (u.getUnit().getTile().isAdjacent(this.target.getTile())) {
                        if (this.target.hasMissionary(this.player.getPlayer())) {
                            PathNode pathNode = u.getUnit().findPath(this.target.getTile());
                            u.getUnit().setMovesLeft(0);
                            AIMessage.askEstablishMission(u, pathNode.getDirection(), this.target.hasMissionary());
                        } else {
                            this.addUnitToParent(u);
                        }
                        this.isFinished = true;
                        continue;
                    }
                    logger.info("Creating subgoal GotoAdjacentGoal.");
                    this.gotoSubGoal = new GotoAdjacentGoal(this.player, this, 1.0f, u, this.target.getTile());
                    continue;
                }
                this.addUnitToParent(u);
            }
        }
    }

    @Override
    public String getGoalDescription() {
        String descr = super.getGoalDescription();
        descr = this.target != null ? descr + ":" + this.target.getName() : descr + ":null";
        return descr;
    }

    @Override
    public void toXML(FreeColXMLWriter xw) throws XMLStreamException {
    }

    @Override
    public void readFromXML(FreeColXMLReader xr) throws XMLStreamException {
    }

    @Override
    public String getXMLTagName() {
        return CreateMissionAtSettlementGoal.getXMLElementTagName();
    }
}

