/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.PsiLabelReference;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

public class PsiBreakStatementImpl
extends CompositePsiElement
implements PsiBreakStatement,
Constants {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.PsiBreakStatementImpl");

    public PsiBreakStatementImpl() {
        super(BREAK_STATEMENT);
    }

    @Override
    public PsiIdentifier getLabelIdentifier() {
        return (PsiIdentifier)this.findChildByRoleAsPsiElement(83);
    }

    @Override
    public PsiStatement findExitedStatement() {
        PsiIdentifier label = this.getLabelIdentifier();
        if (label == null) {
            for (ASTNode parent2 = this.getTreeParent(); parent2 != null; parent2 = parent2.getTreeParent()) {
                IElementType i = parent2.getElementType();
                if (i == FOR_STATEMENT || i == WHILE_STATEMENT || i == DO_WHILE_STATEMENT || i == SWITCH_STATEMENT || i == FOREACH_STATEMENT) {
                    return (PsiStatement)SourceTreeToPsiMap.treeElementToPsi(parent2);
                }
                if (i != METHOD && i != CLASS_INITIALIZER) continue;
                return null;
            }
        } else {
            String labelName = label.getText();
            for (CompositeElement parent3 = this.getTreeParent(); parent3 != null; parent3 = parent3.getTreeParent()) {
                ASTNode statementLabel;
                if (parent3.getElementType() == LABELED_STATEMENT && (statementLabel = parent3.findChildByRole(93)).getText().equals(labelName)) {
                    return ((PsiLabeledStatement)SourceTreeToPsiMap.treeElementToPsi(parent3)).getStatement();
                }
                if (parent3.getElementType() != METHOD && parent3.getElementType() != CLASS_INITIALIZER && parent3.getElementType() != LAMBDA_EXPRESSION) continue;
                return null;
            }
        }
        return null;
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 81: {
                return this.findChildByType(BREAK_KEYWORD);
            }
            case 83: {
                return this.findChildByType(IDENTIFIER);
            }
            case 22: 
        }
        return TreeUtil.findChildBackward(this, SEMICOLON);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == BREAK_KEYWORD) {
            return 81;
        }
        if (i == IDENTIFIER) {
            return 83;
        }
        if (i == SEMICOLON) {
            return 22;
        }
        return 0;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/tree/java/PsiBreakStatementImpl", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitBreakStatement(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        if (references != null && references.length > 0) {
            return references[0];
        }
        return null;
    }

    @Override
    @NotNull
    public PsiReference[] getReferences() {
        if (this.getLabelIdentifier() == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiBreakStatementImpl", "getReferences"));
            }
            return PsiReference.EMPTY_ARRAY;
        }
        PsiReference[] psiReferenceArray = new PsiReference[]{new PsiLabelReference(this, this.getLabelIdentifier())};
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiBreakStatementImpl", "getReferences"));
        }
        return psiReferenceArray;
    }

    @Override
    public String toString() {
        return "PsiBreakStatement";
    }
}

