/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.Dimension;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.NavigatableComponent;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.Helpful;

class MapSlider
extends JSlider
implements NavigatableComponent.ZoomChangeListener,
ChangeListener,
Helpful {
    private static final double ZOOM_STEP = 1.1;
    private final MapView mv;
    private boolean preventChange;
    private int lastValue;

    MapSlider(MapView mv) {
        super(0, 160);
        this.setOpaque(false);
        this.mv = mv;
        NavigatableComponent.addZoomChangeListener(this);
        this.addChangeListener(this);
        this.zoomChanged();
        int w = UIManager.getDefaults().getInt("Slider.thumbWidth") + 150;
        this.setPreferredSize(new Dimension(w, 27));
    }

    @Override
    public void zoomChanged() {
        double maxScale = this.mv.getMaxScale();
        int zoom = (int)Math.round(Math.log(maxScale / this.mv.getScale()) / Math.log(1.1));
        this.preventChange = true;
        this.setValue(zoom);
        this.lastValue = zoom;
        this.preventChange = false;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.preventChange) {
            return;
        }
        if (!this.getModel().getValueIsAdjusting() && this.mv.getNativeScaleLayer() != null) {
            if (this.getValue() < this.lastValue) {
                this.mv.zoomOut();
            } else if (this.getValue() > this.lastValue) {
                this.mv.zoomIn();
            }
        } else {
            double maxScale = this.mv.getMaxScale();
            double scale = maxScale / Math.pow(1.1, this.getValue());
            double snapped = this.mv.scaleFloor(scale);
            this.mv.zoomTo(this.mv.getCenter(), snapped);
        }
        this.zoomChanged();
    }

    @Override
    public String helpTopic() {
        return HelpUtil.ht("/MapView/Slider");
    }
}

