/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.properties;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Map;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetHandler;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetLabel;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetType;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.tools.GBC;

public class PresetListPanel
extends JPanel {
    public PresetListPanel() {
        super(new GridBagLayout());
    }

    public void updatePresets(Collection<TaggingPresetType> types, Map<String, String> tags, TaggingPresetHandler presetHandler) {
        this.removeAll();
        if (types.isEmpty()) {
            this.setVisible(false);
            return;
        }
        for (TaggingPreset t : TaggingPresets.getMatchingPresets(types, tags, true)) {
            TaggingPresetLabel lbl = new TaggingPresetLabel(t);
            lbl.addMouseListener(new LabelMouseAdapter(t, presetHandler));
            this.add((Component)lbl, GBC.eol().fill(2));
        }
        if (this.getComponentCount() > 0) {
            this.setVisible(true);
            int height = this.getComponentCount() * this.getComponent(0).getHeight();
            Dimension size = new Dimension(this.getWidth(), height);
            this.setMaximumSize(size);
            this.setMinimumSize(size);
        } else {
            this.setVisible(false);
        }
    }

    static final class LabelMouseAdapter
    extends MouseAdapter {
        private final TaggingPreset t;
        private final TaggingPresetHandler presetHandler;

        LabelMouseAdapter(TaggingPreset t, TaggingPresetHandler presetHandler) {
            this.t = t;
            this.presetHandler = presetHandler;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Collection<OsmPrimitive> selection = this.t.createSelection(this.presetHandler.getSelection());
            if (selection.isEmpty()) {
                return;
            }
            int answer = this.t.showDialog(selection, false);
            if (answer == 1 && !selection.iterator().next().getDataSet().isLocked()) {
                this.presetHandler.updateTags(this.t.getChangedTags());
            }
        }
    }
}

