/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io.remotecontrol.handler;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.DownloadPrimitivesWithReferrersTask;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.io.remotecontrol.AddTagsDialog;
import org.openstreetmap.josm.io.remotecontrol.PermissionPrefWithDefault;
import org.openstreetmap.josm.io.remotecontrol.handler.RequestHandler;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;

public class LoadObjectHandler
extends RequestHandler {
    public static final String command = "load_object";
    private final List<PrimitiveId> ps = new LinkedList<PrimitiveId>();

    @Override
    public String[] getMandatoryParams() {
        return new String[]{"objects"};
    }

    @Override
    public String[] getOptionalParams() {
        return new String[]{"new_layer", "layer_name", "addtags", "relation_members", "referrers"};
    }

    @Override
    public String getUsage() {
        return "downloads the specified objects from the server";
    }

    @Override
    public String[] getUsageExamples() {
        return new String[]{"/load_object?new_layer=true&objects=w106159509", "/load_object?new_layer=true&objects=r2263653&relation_members=true", "/load_object?objects=n100000&referrers=false"};
    }

    @Override
    protected void handleRequest() throws RequestHandler.RequestHandlerErrorException, RequestHandler.RequestHandlerBadRequestException {
        if (!PermissionPrefWithDefault.LOAD_DATA.isAllowed()) {
            Logging.info("RemoteControl: download forbidden by preferences");
        }
        if (!this.ps.isEmpty()) {
            boolean newLayer = this.isLoadInNewLayer();
            boolean relationMembers = Boolean.parseBoolean((String)this.args.get("relation_members"));
            boolean referrers = Boolean.parseBoolean((String)this.args.get("referrers"));
            DownloadPrimitivesWithReferrersTask task = new DownloadPrimitivesWithReferrersTask(newLayer, this.ps, referrers, relationMembers, (String)this.args.get("layer_name"), null);
            MainApplication.worker.submit(task);
            MainApplication.worker.submit(() -> {
                List<PrimitiveId> downloaded = task.getDownloadedId();
                DataSet ds = MainApplication.getLayerManager().getEditDataSet();
                if (downloaded != null) {
                    GuiHelper.runInEDT(() -> ds.setSelected(downloaded));
                    HashSet<OsmPrimitive> downlPrim = new HashSet<OsmPrimitive>();
                    for (PrimitiveId id : downloaded) {
                        downlPrim.add(ds.getPrimitiveById(id));
                    }
                    AddTagsDialog.addTags(this.args, this.sender, downlPrim);
                }
                this.ps.clear();
            });
        }
    }

    @Override
    public String getPermissionMessage() {
        return I18n.tr("Remote Control has been asked to load objects (specified by their id) from the API.", new Object[0]);
    }

    @Override
    public PermissionPrefWithDefault getPermissionPref() {
        return PermissionPrefWithDefault.LOAD_DATA;
    }

    @Override
    protected void validateRequest() throws RequestHandler.RequestHandlerBadRequestException {
        this.ps.clear();
        for (String i : (this.args != null ? (String)this.args.get("objects") : "").split(",\\s*")) {
            if (i.isEmpty()) continue;
            try {
                this.ps.add(SimplePrimitiveId.fromString(i));
            }
            catch (IllegalArgumentException e) {
                Logging.log(Logging.LEVEL_WARN, "RemoteControl: invalid selection '" + i + "' ignored.", e);
            }
        }
    }
}

