/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.util.FloatUtil;

public class FloatLiteral
extends NumberLiteral {
    float value;

    public FloatLiteral(char[] cArray, int n, int n2) {
        super(cArray, n, n2);
    }

    @Override
    public void computeConstant() {
        Float f;
        boolean bl;
        boolean bl2 = bl = CharOperation.indexOf('_', this.source) > 0;
        if (bl) {
            this.source = CharOperation.remove(this.source, '_');
        }
        try {
            f = Float.valueOf(String.valueOf(this.source));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                float f2 = FloatUtil.valueOfHexFloatLiteral(this.source);
                if (f2 == Float.POSITIVE_INFINITY) {
                    return;
                }
                if (Float.isNaN(f2)) {
                    return;
                }
                this.value = f2;
                this.constant = FloatConstant.fromValue(f2);
            }
            catch (NumberFormatException numberFormatException2) {
                // empty catch block
            }
            return;
        }
        float f3 = f.floatValue();
        if (f3 > Float.MAX_VALUE) {
            return;
        }
        if (f3 < Float.MIN_VALUE) {
            boolean bl3 = false;
            block10: for (int i = 0; i < this.source.length; ++i) {
                switch (this.source[i]) {
                    case '.': 
                    case '0': {
                        continue block10;
                    }
                    case 'X': 
                    case 'x': {
                        bl3 = true;
                        continue block10;
                    }
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        if (!bl3) break block10;
                        return;
                    }
                    case 'P': 
                    case 'p': {
                        break block10;
                    }
                    default: {
                        return;
                    }
                }
            }
        }
        this.value = f3;
        this.constant = FloatConstant.fromValue(this.value);
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl) {
        int n = codeStream.position;
        if (bl) {
            codeStream.generateConstant(this.constant, this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    @Override
    public TypeBinding literalType(BlockScope blockScope) {
        return TypeBinding.FLOAT;
    }

    @Override
    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }
}

