complete -c feh -l action -s A -x -d "Specify a shell command as action to perform on the image"

for i in (seq 1 9)
	complete -c feh -l action$i -x -d "Extra action triggered with number key "$i
end

complete -c feh -l auto-zoom -s Z -d "Zoom pictures to screen size"
complete -c feh -l borderless -s x -d "Create borderless window"
complete -c feh -l cache-thumbnails -s P -d "Enable thumbnail caching"
complete -c feh -l caption-path -s K -r -d "Path to directory containing image caption"
complete -c feh -l customlist -s L -x -d "Print image info according to given format"
complete -c feh -l cycle-once -d "Exit feh after one loop through the slideshow"
complete -c feh -l draw-actions -s G -d "Draw the defined actions"
complete -c feh -l draw-exif -d "Display some EXIF information"
complete -c feh -l draw-filename -s d -d "Draw filename"
complete -c feh -l draw-tinted -d "Show overlay texts on semi-transparent background"
complete -c feh -l filelist -s f -r
complete -c feh -l font -s e -x -r -d "Set global font"
complete -c feh -l fontpath -s C -r -d "Add given path as directory to search fonts"
complete -c feh -l force-aliasing -d "Disable antialiasing for zooming, bg settings, etc."
complete -c feh -l fullindex -s I
complete -c feh -l fullscreen -s F -d "Make window fullscreen"
complete -c feh -l geometry -s g -x -d "Limit window size. Format: [w x h] [+ x + y]"
complete -c feh -l hide-pointer -s Y -d "Hide pointer"
complete -c feh -l image-bg -s B -x -a "checks white black" -d "Use style as background for transparent image parts"
complete -c feh -l index -s i -d "Enable index mode"
complete -c feh -l index-info -x -d "Show image information based on given format"
complete -c feh -l info -x -d "Execute given command line and display its output"
complete -c feh -l keep-http -s k -d "Keep files fetched using HTTP"
complete -c feh -l insecure -d "Disable strict hostname and peer checking with HTTPS"
complete -c feh -l keep-zoom-vp -d "When switching images, keep zoom and viewport settings"
complete -c feh -l list -s l -d "Don't display images. Display an ls style listing"
complete -c feh -l loadable -s U -d "Just print out image names if imlib2 can read them"
complete -c feh -l magick-timeout -x -d "Stop trying to convert unloadable files after given timeout"
complete -c feh -l max-dimension -x -d "Only show images which are smaller then given size"
complete -c feh -l menu-font -s M -x -d "Use given font as menu font"
complete -c feh -l min-dimension -x -d "Only show image which are larger then given size"
complete -c feh -l montage -s m -d "Enable montage mode"
complete -c feh -l multiwindow -s w -d "Disable slideshow mode"
complete -c feh -l no-jump-on-resort -d "Don't jump to first image after resorting filelist"
complete -c feh -l no-menus -s N -d "Don't load or show any menus"
complete -c feh -l no-screen-clip -d "Don't limit window to screen size"
complete -c feh -l no-xinerama -d "Disable Xinerama support"
complete -c feh -l output-dir -s j -r -d "Save files to given directory"
complete -c feh -l preload -s p -d "Preload images"
complete -c feh -l quiet -s q -d "Don't report non-fatal errors"
complete -c feh -l randomize -s z -d "Randomize file list before displaying"
complete -c feh -l recursive -s r -d "Recursivly expand any directory"
complete -c feh -l no-recursive -d "Don't recursively expand any directory (default)"
complete -c feh -l reload -s R -x -d "Reload filelist after given time in second"
complete -c feh -l reverse -s n -d "Reverse sort order"
complete -c feh -l scale-down -s '.' -d "Scale image to fit window geometry"
complete -c feh -l scroll-step -x -d "Scroll given number of pixels when scrolling keys are pressed"
complete -c feh -l slideshow-delay -s D -x -d "Set delay in second between automatically changing slides"
complete -c feh -l sort -s S -x -a "name\tSort\ by\ name filename\tSort\ by\ filename dirname\tSort\ by\ directory\ name mtime\tSort\ by\ most\ recently\ modified width\tSort\ by\ width height\tSort\ by\ height pixels\tSort\ by\ number\ of\ pixels size\tSort\ by\ size format\tSort\ by\ format" -d "Sort file list with given parameter"
complete -c feh -l start-at -s l -x -d "Start the filelist at given filename"
complete -c feh -l theme -s T -x -d "Load options from given config file"
complete -c feh -l thumbnails -s t
complete -c feh -l thumb-title -s '~' -x -d "Set given title for window opended from thumbnail mode"
complete -c feh -l title -s '^' -x -d "Set window title"
complete -c feh -l unloadable -s u -d "Just print names of images that can't be loaded by imlib2"
complete -c feh -l verbose -s V -d "Verbose mode"
complete -c feh -l version -s v -d "Print version and exit"
complete -c feh -l xinerama-index -x
complete -c feh -l zoom -x -a "max fill" -d "Zoom images by given percent when in fullscreen"

# Montage Mode Options
complete -c feh -l alpha -s a -x -d "Set thumbnails' transparency to given level (0-255)"
complete -c feh -l bg -s b -r -a "trans" -d "Use given file as background for your montage"
complete -c feh -l ignore-aspect -s X -d "Don't retain thumbnails' aspect ratios"
complete -c feh -l limit-height -s W -x -d "Limit montage's height"
complete -c feh -l limit-width -s W -x -d "Limit montage's width"
complete -c feh -l output -s o -r -d "Save created montage to given file"
complete -c feh -l output-only -s O -r -d "Just save the created montage to given file"
complete -c feh -l stretch -s s -d "If image smaller then given thumbnail size, it will be enlarged"
complete -c feh -l thumb-height -s E -x -d "Set thumbnail height"
complete -c feh -l thumb-width -s y -x -d "Set thumbnail width"
complete -c feh -l thumb-redraw -s J -x -d "Redraw thumbnail window every n images"

# Index mode options
complete -c feh -l title-font -s '@' -x -d "Set font to print title on index"

# Background setting
complete -c feh -l bg-center -d "Center file on background"
complete -c feh -l bg-fill -d "Fit file into background by zooming until image fits"
complete -c feh -l bg-max -d "Fit file into backround by zooming with black borders on one side"
complete -c feh -l bg-scale -d "Fit file into background without repeating it, cutting off stuff or using borders"
complete -c feh -l bg-tile -d "Tile image if too small for screen"
complete -c feh -l no-fehbg -d "Do not write a ~/.fehbg file"
