/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.RemoveNodesCommand;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class UnJoinNodeWayAction
extends JosmAction {
    public UnJoinNodeWayAction() {
        super(I18n.tr("Disconnect Node from Way", new Object[0]), "unjoinnodeway", I18n.tr("Disconnect nodes from a way they currently belong to", new Object[0]), Shortcut.registerShortcut("tools:unjoinnodeway", I18n.tr("Tool: {0}", I18n.tr("Disconnect Node from Way", new Object[0])), 74, 5004), true);
        this.putValue("help", HelpUtil.ht("/Action/UnJoinNodeWay"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Collection<OsmPrimitive> selection = this.getLayerManager().getEditDataSet().getSelected();
        List<Node> selectedNodes = OsmPrimitive.getFilteredList(selection, Node.class);
        List<Way> selectedWays = OsmPrimitive.getFilteredList(selection, Way.class);
        List<Way> applicableWays = UnJoinNodeWayAction.getApplicableWays(selectedWays, selectedNodes = this.cleanSelectedNodes(selectedWays, selectedNodes));
        if (applicableWays == null) {
            this.notify(I18n.tr("Select at least one node to be disconnected.", new Object[0]), 2);
            return;
        }
        if (applicableWays.isEmpty()) {
            this.notify(I18n.trn("Selected node cannot be disconnected from anything.", "Selected nodes cannot be disconnected from anything.", selectedNodes.size(), new Object[0]), 2);
            return;
        }
        if (applicableWays.size() > 1) {
            this.notify(I18n.trn("There is more than one way using the node you selected. Please select the way also.", "There is more than one way using the nodes you selected. Please select the way also.", selectedNodes.size(), new Object[0]), 2);
            return;
        }
        if (applicableWays.get(0).getRealNodesCount() < selectedNodes.size() + 2) {
            this.notify(I18n.trn("The affected way would disappear after disconnecting the selected node.", "The affected way would disappear after disconnecting the selected nodes.", selectedNodes.size(), new Object[0]), 2);
            return;
        }
        Way selectedWay = applicableWays.get(0);
        MainApplication.undoRedo.add(new RemoveNodesCommand(selectedWay, selectedNodes));
    }

    public void notify(String msg, int messageType) {
        new Notification(msg).setIcon(messageType).show();
    }

    private List<Node> cleanSelectedNodes(List<Way> selectedWays, List<Node> selectedNodes) {
        LinkedList<Node> resultingNodes = new LinkedList<Node>();
        for (Node n : selectedNodes) {
            if (!n.isReferredByWays(1)) continue;
            resultingNodes.add(n);
        }
        if (selectedWays.size() == 1) {
            Way w = selectedWays.get(0);
            for (Node n : new ArrayList<Node>(resultingNodes)) {
                if (w.containsNode(n)) continue;
                resultingNodes.remove(n);
            }
        }
        if (resultingNodes.size() != selectedNodes.size()) {
            this.notify(I18n.tr("Some irrelevant nodes have been removed from the selection", new Object[0]), 1);
        }
        return resultingNodes;
    }

    static List<Way> getApplicableWays(List<Way> selectedWays, List<Node> selectedNodes) {
        if (selectedNodes.isEmpty()) {
            return null;
        }
        ArrayList<Way> result = new ArrayList<Way>(selectedNodes.get(0).getParentWays());
        for (int i = 1; i < selectedNodes.size(); ++i) {
            List<Way> ref = selectedNodes.get(i).getParentWays();
            result.removeIf(way -> !ref.contains(way));
        }
        result.removeIf(way -> way.getNodesCount() <= 2);
        if (selectedWays.isEmpty()) {
            return result;
        }
        result.removeIf(way -> !selectedWays.contains(way));
        return result;
    }

    @Override
    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.updateEnabledStateOnModifiableSelection(selection);
    }
}

