/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.internal;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.OriginalIndices;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.Rewriteable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchLocalRequest;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportRequest;

public class ShardSearchTransportRequest
extends TransportRequest
implements ShardSearchRequest,
IndicesRequest {
    private OriginalIndices originalIndices;
    private ShardSearchLocalRequest shardSearchLocalRequest;

    public ShardSearchTransportRequest() {
    }

    public ShardSearchTransportRequest(OriginalIndices originalIndices, SearchRequest searchRequest, ShardId shardId, int numberOfShards, AliasFilter aliasFilter, float indexBoost, long nowInMillis, String clusterAlias) {
        this.shardSearchLocalRequest = new ShardSearchLocalRequest(searchRequest, shardId, numberOfShards, aliasFilter, indexBoost, nowInMillis, clusterAlias);
        this.originalIndices = originalIndices;
    }

    public void searchType(SearchType searchType) {
        this.shardSearchLocalRequest.setSearchType(searchType);
    }

    @Override
    public String[] indices() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indices();
    }

    @Override
    public IndicesOptions indicesOptions() {
        if (this.originalIndices == null) {
            return null;
        }
        return this.originalIndices.indicesOptions();
    }

    @Override
    public ShardId shardId() {
        return this.shardSearchLocalRequest.shardId();
    }

    @Override
    public String[] types() {
        return this.shardSearchLocalRequest.types();
    }

    @Override
    public SearchSourceBuilder source() {
        return this.shardSearchLocalRequest.source();
    }

    @Override
    public AliasFilter getAliasFilter() {
        return this.shardSearchLocalRequest.getAliasFilter();
    }

    @Override
    public void setAliasFilter(AliasFilter filter) {
        this.shardSearchLocalRequest.setAliasFilter(filter);
    }

    @Override
    public void source(SearchSourceBuilder source) {
        this.shardSearchLocalRequest.source(source);
    }

    @Override
    public int numberOfShards() {
        return this.shardSearchLocalRequest.numberOfShards();
    }

    @Override
    public SearchType searchType() {
        return this.shardSearchLocalRequest.searchType();
    }

    @Override
    public float indexBoost() {
        return this.shardSearchLocalRequest.indexBoost();
    }

    @Override
    public long nowInMillis() {
        return this.shardSearchLocalRequest.nowInMillis();
    }

    @Override
    public Boolean requestCache() {
        return this.shardSearchLocalRequest.requestCache();
    }

    @Override
    public Scroll scroll() {
        return this.shardSearchLocalRequest.scroll();
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardSearchLocalRequest = new ShardSearchLocalRequest();
        this.shardSearchLocalRequest.innerReadFrom(in);
        this.originalIndices = OriginalIndices.readOriginalIndices(in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.shardSearchLocalRequest.innerWriteTo(out, false);
        OriginalIndices.writeOriginalIndices(this.originalIndices, out);
    }

    @Override
    public BytesReference cacheKey() throws IOException {
        return this.shardSearchLocalRequest.cacheKey();
    }

    @Override
    public void setProfile(boolean profile) {
        this.shardSearchLocalRequest.setProfile(profile);
    }

    @Override
    public boolean isProfile() {
        return this.shardSearchLocalRequest.isProfile();
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    @Override
    public String getDescription() {
        return "shardId[" + this.shardSearchLocalRequest.shardId() + "]";
    }

    @Override
    public String getClusterAlias() {
        return this.shardSearchLocalRequest.getClusterAlias();
    }

    @Override
    public Rewriteable<Rewriteable> getRewriteable() {
        return this.shardSearchLocalRequest.getRewriteable();
    }
}

