/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla.io;

import com.mysql.cj.api.mysqla.io.NativeProtocol;
import com.mysql.cj.api.mysqla.io.PacketPayload;
import com.mysql.cj.core.Constants;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.util.StringUtils;

public class Buffer
implements PacketPayload {
    private int payloadLength = 0;
    private byte[] byteBuffer;
    private int position = 0;
    static final int MAX_BYTES_TO_DUMP = 512;

    public String toString() {
        int numBytes = this.position <= this.payloadLength ? this.position : this.payloadLength;
        int numBytesToDump = numBytes < 512 ? numBytes : 512;
        this.position = 0;
        String dumped = StringUtils.dumpAsHex(this.readBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, numBytesToDump), numBytesToDump);
        if (numBytesToDump < numBytes) {
            return dumped + " ....(packet exceeds max. dump length)";
        }
        return dumped;
    }

    public String toSuperString() {
        return super.toString();
    }

    public Buffer(byte[] buf) {
        this.byteBuffer = buf;
        this.payloadLength = buf.length;
    }

    public Buffer(int size) {
        this.byteBuffer = new byte[size];
        this.payloadLength = size;
    }

    @Override
    public int getCapacity() {
        return this.byteBuffer.length;
    }

    @Override
    public final void ensureCapacity(int additionalData) {
        if (this.position + additionalData > this.byteBuffer.length) {
            int newLength = (int)((double)this.byteBuffer.length * 1.25);
            if (newLength < this.byteBuffer.length + additionalData) {
                newLength = this.byteBuffer.length + (int)((double)additionalData * 1.25);
            }
            if (newLength < this.byteBuffer.length) {
                newLength = this.byteBuffer.length + additionalData;
            }
            byte[] newBytes = new byte[newLength];
            System.arraycopy(this.byteBuffer, 0, newBytes, 0, this.byteBuffer.length);
            this.byteBuffer = newBytes;
        }
    }

    @Override
    public byte[] getByteBuffer() {
        return this.byteBuffer;
    }

    @Override
    public void setByteBuffer(byte[] byteBufferToSet) {
        this.byteBuffer = byteBufferToSet;
    }

    @Override
    public int getPayloadLength() {
        return this.payloadLength;
    }

    @Override
    public void setPayloadLength(int bufLengthToSet) {
        if (bufLengthToSet > this.byteBuffer.length) {
            throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("Buffer.0"));
        }
        this.payloadLength = bufLengthToSet;
    }

    private void adjustPayloadLength() {
        if (this.position > this.payloadLength) {
            this.payloadLength = this.position;
        }
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int positionToSet) {
        this.position = positionToSet;
    }

    @Override
    public final boolean isEOFPacket() {
        return (this.byteBuffer[0] & 0xFF) == 254 && this.getPayloadLength() <= 5;
    }

    @Override
    public final boolean isAuthMethodSwitchRequestPacket() {
        return (this.byteBuffer[0] & 0xFF) == 254;
    }

    @Override
    public final boolean isOKPacket() {
        return (this.byteBuffer[0] & 0xFF) == 0;
    }

    @Override
    public final boolean isResultSetOKPacket() {
        return (this.byteBuffer[0] & 0xFF) == 254 && this.getPayloadLength() < 0xFFFFFF;
    }

    @Override
    public final boolean isAuthMoreData() {
        return (this.byteBuffer[0] & 0xFF) == 1;
    }

    @Override
    public void writeInteger(NativeProtocol.IntegerDataType type, long l) {
        switch (type) {
            case INT1: {
                this.ensureCapacity(1);
                byte[] b = this.byteBuffer;
                b[this.position++] = (byte)(l & 0xFFL);
                break;
            }
            case INT2: {
                this.ensureCapacity(2);
                byte[] b = this.byteBuffer;
                b[this.position++] = (byte)(l & 0xFFL);
                b[this.position++] = (byte)(l >>> 8);
                break;
            }
            case INT3: {
                this.ensureCapacity(3);
                byte[] b = this.byteBuffer;
                b[this.position++] = (byte)(l & 0xFFL);
                b[this.position++] = (byte)(l >>> 8);
                b[this.position++] = (byte)(l >>> 16);
                break;
            }
            case INT4: {
                this.ensureCapacity(4);
                byte[] b = this.byteBuffer;
                b[this.position++] = (byte)(l & 0xFFL);
                b[this.position++] = (byte)(l >>> 8);
                b[this.position++] = (byte)(l >>> 16);
                b[this.position++] = (byte)(l >>> 24);
                break;
            }
            case INT6: {
                this.ensureCapacity(6);
                byte[] b = this.byteBuffer;
                b[this.position++] = (byte)(l & 0xFFL);
                b[this.position++] = (byte)(l >>> 8);
                b[this.position++] = (byte)(l >>> 16);
                b[this.position++] = (byte)(l >>> 24);
                b[this.position++] = (byte)(l >>> 32);
                b[this.position++] = (byte)(l >>> 40);
                break;
            }
            case INT8: {
                this.ensureCapacity(8);
                byte[] b = this.byteBuffer;
                b[this.position++] = (byte)(l & 0xFFL);
                b[this.position++] = (byte)(l >>> 8);
                b[this.position++] = (byte)(l >>> 16);
                b[this.position++] = (byte)(l >>> 24);
                b[this.position++] = (byte)(l >>> 32);
                b[this.position++] = (byte)(l >>> 40);
                b[this.position++] = (byte)(l >>> 48);
                b[this.position++] = (byte)(l >>> 56);
                break;
            }
            case INT_LENENC: {
                if (l < 251L) {
                    this.ensureCapacity(1);
                    this.writeInteger(NativeProtocol.IntegerDataType.INT1, l);
                    break;
                }
                if (l < 65536L) {
                    this.ensureCapacity(3);
                    this.writeInteger(NativeProtocol.IntegerDataType.INT1, 252L);
                    this.writeInteger(NativeProtocol.IntegerDataType.INT2, l);
                    break;
                }
                if (l < 0x1000000L) {
                    this.ensureCapacity(4);
                    this.writeInteger(NativeProtocol.IntegerDataType.INT1, 253L);
                    this.writeInteger(NativeProtocol.IntegerDataType.INT3, l);
                    break;
                }
                this.ensureCapacity(9);
                this.writeInteger(NativeProtocol.IntegerDataType.INT1, 254L);
                this.writeInteger(NativeProtocol.IntegerDataType.INT8, l);
            }
        }
        this.adjustPayloadLength();
    }

    @Override
    public final long readInteger(NativeProtocol.IntegerDataType type) {
        byte[] b = this.byteBuffer;
        switch (type) {
            case INT1: {
                return b[this.position++] & 0xFF;
            }
            case INT2: {
                return b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8;
            }
            case INT3: {
                return b[this.position++] & 0xFF | (b[this.position++] & 0xFF) << 8 | (b[this.position++] & 0xFF) << 16;
            }
            case INT4: {
                return (long)b[this.position++] & 0xFFL | ((long)b[this.position++] & 0xFFL) << 8 | (long)(b[this.position++] & 0xFF) << 16 | (long)(b[this.position++] & 0xFF) << 24;
            }
            case INT6: {
                return (long)(b[this.position++] & 0xFF) | (long)(b[this.position++] & 0xFF) << 8 | (long)(b[this.position++] & 0xFF) << 16 | (long)(b[this.position++] & 0xFF) << 24 | (long)(b[this.position++] & 0xFF) << 32 | (long)(b[this.position++] & 0xFF) << 40;
            }
            case INT8: {
                return (long)(b[this.position++] & 0xFF) | (long)(b[this.position++] & 0xFF) << 8 | (long)(b[this.position++] & 0xFF) << 16 | (long)(b[this.position++] & 0xFF) << 24 | (long)(b[this.position++] & 0xFF) << 32 | (long)(b[this.position++] & 0xFF) << 40 | (long)(b[this.position++] & 0xFF) << 48 | (long)(b[this.position++] & 0xFF) << 56;
            }
            case INT_LENENC: {
                int sw = b[this.position++] & 0xFF;
                switch (sw) {
                    case 251: {
                        return -1L;
                    }
                    case 252: {
                        return this.readInteger(NativeProtocol.IntegerDataType.INT2);
                    }
                    case 253: {
                        return this.readInteger(NativeProtocol.IntegerDataType.INT3);
                    }
                    case 254: {
                        return this.readInteger(NativeProtocol.IntegerDataType.INT8);
                    }
                }
                return sw;
            }
        }
        return b[this.position++] & 0xFF;
    }

    @Override
    public final void writeBytes(NativeProtocol.StringSelfDataType type, byte[] b) {
        this.writeBytes(type, b, 0, b.length);
    }

    @Override
    public final void writeBytes(NativeProtocol.StringLengthDataType type, byte[] b) {
        this.writeBytes(type, b, 0, b.length);
    }

    @Override
    public void writeBytes(NativeProtocol.StringSelfDataType type, byte[] b, int offset, int len) {
        switch (type) {
            case STRING_EOF: {
                this.writeBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, b, offset, len);
                break;
            }
            case STRING_TERM: {
                this.ensureCapacity(len + 1);
                this.writeBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, b, offset, len);
                this.byteBuffer[this.position++] = 0;
                break;
            }
            case STRING_LENENC: {
                this.ensureCapacity(len + 9);
                this.writeInteger(NativeProtocol.IntegerDataType.INT_LENENC, len);
                this.writeBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, b, offset, len);
            }
        }
        this.adjustPayloadLength();
    }

    @Override
    public void writeBytes(NativeProtocol.StringLengthDataType type, byte[] b, int offset, int len) {
        switch (type) {
            case STRING_FIXED: 
            case STRING_VAR: {
                this.ensureCapacity(len);
                System.arraycopy(b, offset, this.byteBuffer, this.position, len);
                this.position += len;
            }
        }
        this.adjustPayloadLength();
    }

    @Override
    public byte[] readBytes(NativeProtocol.StringSelfDataType type) {
        switch (type) {
            case STRING_TERM: {
                int i;
                for (i = this.position; i < this.payloadLength && this.byteBuffer[i] != 0; ++i) {
                }
                byte[] b = this.readBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, i - this.position);
                ++this.position;
                return b;
            }
            case STRING_LENENC: {
                long l = this.readInteger(NativeProtocol.IntegerDataType.INT_LENENC);
                return l == -1L ? null : (l == 0L ? Constants.EMPTY_BYTE_ARRAY : this.readBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, (int)l));
            }
            case STRING_EOF: {
                return this.readBytes(NativeProtocol.StringLengthDataType.STRING_FIXED, this.payloadLength - this.position);
            }
        }
        return null;
    }

    @Override
    public void skipBytes(NativeProtocol.StringSelfDataType type) {
        switch (type) {
            case STRING_TERM: {
                while (this.position < this.payloadLength && this.byteBuffer[this.position] != 0) {
                    ++this.position;
                }
                ++this.position;
                break;
            }
            case STRING_LENENC: {
                long len = this.readInteger(NativeProtocol.IntegerDataType.INT_LENENC);
                if (len == -1L || len == 0L) break;
                this.position += (int)len;
                break;
            }
            case STRING_EOF: {
                this.position = this.payloadLength;
            }
        }
    }

    @Override
    public byte[] readBytes(NativeProtocol.StringLengthDataType type, int len) {
        switch (type) {
            case STRING_FIXED: 
            case STRING_VAR: {
                byte[] b = new byte[len];
                System.arraycopy(this.byteBuffer, this.position, b, 0, len);
                this.position += len;
                return b;
            }
        }
        return null;
    }

    @Override
    public String readString(NativeProtocol.StringSelfDataType type, String encoding) {
        String res = null;
        switch (type) {
            case STRING_TERM: {
                int i;
                for (i = this.position; i < this.payloadLength && this.byteBuffer[i] != 0; ++i) {
                }
                res = this.readString(NativeProtocol.StringLengthDataType.STRING_FIXED, encoding, i - this.position);
                ++this.position;
                break;
            }
            case STRING_LENENC: {
                long l = this.readInteger(NativeProtocol.IntegerDataType.INT_LENENC);
                return l == -1L ? null : (l == 0L ? "" : this.readString(NativeProtocol.StringLengthDataType.STRING_FIXED, encoding, (int)l));
            }
            case STRING_EOF: {
                return this.readString(NativeProtocol.StringLengthDataType.STRING_FIXED, encoding, this.payloadLength - this.position);
            }
        }
        return res;
    }

    @Override
    public String readString(NativeProtocol.StringLengthDataType type, String encoding, int len) {
        String res = null;
        switch (type) {
            case STRING_FIXED: 
            case STRING_VAR: {
                if (this.position + len > this.payloadLength) {
                    throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("Buffer.1"));
                }
                res = StringUtils.toString(this.byteBuffer, this.position, len, encoding);
                this.position += len;
            }
        }
        return res;
    }
}

