#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: cassava
version: 0.5.1.0
id: cassava-0.5.1.0-C0ReWXkWNAF8ep9NUSedTO
key: cassava-0.5.1.0-C0ReWXkWNAF8ep9NUSedTO
license: BSD3
copyright: (c) 2012 Johan Tibell
           (c) 2012 Bryan O'\''Sullivan
           (c) 2011 MailRank, Inc.
maintainer: hvr@gnu.org
homepage: https://github.com/hvr/cassava
synopsis: A CSV parsing and encoding library
description:
    @cassava@ is a library for parsing and encoding [RFC 4180](https://tools.ietf.org/html/rfc4180)
    compliant [comma-separated values (CSV)](https://en.wikipedia.org/wiki/Comma-separated_values) data,
    which is a textual line-oriented format commonly used for exchanging tabular data.
    .
    @cassava@'\''s API includes support for
    .
    - Index-based record-conversion
    - Name-based record-conversion
    - Typeclass directed conversion of fields and records
    - Built-in field-conversion instances for standard types
    - Customizable record-conversion instance derivation via GHC generics
    - Low-level [bytestring](https://hackage.haskell.org/package/bytestring) builders (see "Data.Csv.Builder")
    - Incremental decoding and encoding API (see "Data.Csv.Incremental")
    - Streaming API for constant-space decoding (see "Data.Csv.Streaming")
    .
    Moreover, this library is designed to be easy to use; for instance, here'\''s a
    very simple example of encoding CSV data:
    .
    >>> Data.Csv.encode [("John",27),("Jane",28)]
    "John,27\r\nJane,28\r\n"
    .
    Please refer to the documentation in "Data.Csv" and the included [README](#readme) for more usage examples.
category: Text, Web, CSV
author: Johan Tibell
exposed: True
indefinite: False
exposed-modules:
    Data.Csv Data.Csv.Builder Data.Csv.Incremental Data.Csv.Parser
    Data.Csv.Streaming
hidden-modules: Data.Csv.Conversion Data.Csv.Conversion.Internal
                Data.Csv.Encoding Data.Csv.Types Data.Csv.Util
abi: cb3faeb228a5df9efa0a51b64eb19a97
trusted: False
import-dirs: /usr/lib/ghc-8.2.2/site-local/cassava-0.5.1.0
library-dirs: /usr/lib/ghc-8.2.2/site-local/cassava-0.5.1.0
dynamic-library-dirs: /usr/lib
data-dir: /usr/share/arm-linux-ghc-8.2.2/cassava-0.5.1.0
hs-libraries: HScassava-0.5.1.0-C0ReWXkWNAF8ep9NUSedTO
depends:
    array-0.5.2.0 attoparsec-0.13.2.2-edlJ1qiIMBKPe2fnELys4
    base-4.10.1.0 bytestring-0.10.8.2 containers-0.5.10.2
    deepseq-1.4.3.0 hashable-1.2.7.0-D1kf6WO5TlN7xk82E4ZIan
    scientific-0.3.5.2-6cyGrFW0qofJtQe5gZMBGX
    text-1.2.3.0-912fnkqHcZz4dFvcXKwtDz
    unordered-containers-0.2.9.0-GWvuj0HLmUnDmBShmJCvae
    vector-0.12.0.1-JlawpRjIcMJIYPJVsWriIA
    Only-0.1-K3HSyq2koL8JtFXn0ZkrT6
    text-short-0.1.2-9jLN0wJH9NQ3hdERUtCn3v
abi-depends: array-0.5.2.0=567646df31883e5d21d17233cc6e3caf
             attoparsec-0.13.2.2-edlJ1qiIMBKPe2fnELys4=923ea4b48e3ff86a32743bf7d135ea3e
             base-4.10.1.0=0ea45191c57c268b2351cb731ab6a0d6
             bytestring-0.10.8.2=4b2726b654ceeff6535e698a2a1e724e
             containers-0.5.10.2=0f9db0d1b935cacba444aac19f4cb54d
             deepseq-1.4.3.0=e843b5d736cc095915bf2399fddf152e
             hashable-1.2.7.0-D1kf6WO5TlN7xk82E4ZIan=7c14723fffdda860d330f4ccf53597f4
             scientific-0.3.5.2-6cyGrFW0qofJtQe5gZMBGX=7aedff29b89e83530bb1e2cdf3ff8b50
             text-1.2.3.0-912fnkqHcZz4dFvcXKwtDz=29872508833c96394f0471371217bab0
             unordered-containers-0.2.9.0-GWvuj0HLmUnDmBShmJCvae=b402656649e5f5df6537cabd8124c4af
             vector-0.12.0.1-JlawpRjIcMJIYPJVsWriIA=137c9db50bf637e10c6e6dd9e685ce59
             Only-0.1-K3HSyq2koL8JtFXn0ZkrT6=21cb887b2dde313bd9095bf1e74d7359
             text-short-0.1.2-9jLN0wJH9NQ3hdERUtCn3v=3d15439e71510832191e3e5182658a56
haddock-interfaces: /usr/share/doc/haskell-cassava/html/cassava.haddock
haddock-html: /usr/share/doc/haskell-cassava/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

