/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.ext;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import org.jruby.NativeException;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ext.JavaLangReflect;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.JavaInternalBlockBody;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaLang {
    public static void define(Ruby runtime) {
        Iterable.define(runtime);
        Comparable.define(runtime);
        Throwable.define(runtime);
        Runnable.define(runtime);
        Character.define(runtime);
        Class.define(runtime);
        ClassLoader.define(runtime);
        RubyModule byteArray = Java.getProxyClass(runtime, new byte[0].getClass());
        byteArray.addMethod("ubyte_get", new UByteGet(byteArray));
        byteArray.addMethod("ubyte_set", new UByteSet(byteArray));
        RubyModule String2 = Java.getProxyClass(runtime, String.class);
        String2.defineAlias("to_str", "to_s");
        RubyModule Number2 = Java.getProxyClass(runtime, Number.class);
        Number2.defineAlias("to_int", "longValue");
        Number2.defineAlias("to_f", "doubleValue");
    }

    private static final class UByteSet
    extends JavaMethod.JavaMethodTwo {
        UByteSet(RubyModule implClass) {
            super(implClass, Visibility.PUBLIC);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject idx, IRubyObject val) {
            int byte_val = ((RubyInteger)val).getIntValue();
            if (byte_val > 127) {
                val = RubyFixnum.newFixnum(context.runtime, byte_val - 256);
            }
            return self2.callMethod(context, "[]=", new IRubyObject[]{idx, val});
        }
    }

    private static final class UByteGet
    extends JavaMethod.JavaMethodOne {
        UByteGet(RubyModule implClass) {
            super(implClass, Visibility.PUBLIC);
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject idx) {
            RubyInteger val = (RubyInteger)self2.callMethod(context, "[]", idx);
            int byte_val = val.getIntValue();
            if (byte_val >= 0) {
                return val;
            }
            return RubyFixnum.newFixnum(context.runtime, byte_val + 256);
        }
    }

    @JRubyClass(name={"Java::JavaLang::ClassLoader"})
    public static class ClassLoader {
        static RubyModule define(Ruby runtime) {
            RubyModule ClassLoader2 = Java.getProxyClass(runtime, java.lang.ClassLoader.class);
            ClassLoader2.defineAnnotatedMethods(ClassLoader.class);
            return ClassLoader2;
        }

        @JRubyMethod
        public static IRubyObject resource_as_url(ThreadContext context, IRubyObject self2, IRubyObject name2) {
            java.lang.ClassLoader loader = (java.lang.ClassLoader)JavaUtil.unwrapIfJavaObject(self2);
            String resName = name2.convertToString().toString();
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, loader.getResource(resName));
        }

        @JRubyMethod
        public static IRubyObject resource_as_stream(ThreadContext context, IRubyObject self2, IRubyObject name2) {
            java.lang.ClassLoader loader = (java.lang.ClassLoader)JavaUtil.unwrapIfJavaObject(self2);
            String resName = name2.convertToString().toString();
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, loader.getResourceAsStream(resName));
        }

        @JRubyMethod
        public static IRubyObject resource_as_string(ThreadContext context, IRubyObject self2, IRubyObject name2) {
            java.lang.ClassLoader loader = (java.lang.ClassLoader)JavaUtil.unwrapIfJavaObject(self2);
            String resName = name2.convertToString().toString();
            return new RubyIO(context.runtime, loader.getResourceAsStream(resName)).read(context);
        }
    }

    @JRubyClass(name={"Java::JavaLang::Class"})
    public static class Class {
        static RubyClass define(Ruby runtime) {
            RubyModule Class2 = Java.getProxyClass(runtime, java.lang.Class.class);
            Class2.includeModule(runtime.getComparable());
            Class2.defineAnnotatedMethods(Class.class);
            return (RubyClass)Class2;
        }

        @JRubyMethod(name={"ruby_class"})
        public static IRubyObject proxy_class(ThreadContext context, IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return context.runtime.getJavaSupport().getProxyClassFromCache(klass);
        }

        @JRubyMethod
        public static IRubyObject resource_as_stream(ThreadContext context, IRubyObject self2, IRubyObject name2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            String resName = name2.convertToString().toString();
            return JavaUtil.convertJavaToUsableRubyObject(context.runtime, klass.getResourceAsStream(resName));
        }

        @JRubyMethod
        public static IRubyObject resource_as_string(ThreadContext context, IRubyObject self2, IRubyObject name2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            String resName = name2.convertToString().toString();
            return new RubyIO(context.runtime, klass.getResourceAsStream(resName)).read(context);
        }

        @JRubyMethod
        public static IRubyObject to_s(ThreadContext context, IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return RubyString.newString(context.runtime, klass.getName());
        }

        @JRubyMethod
        public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return RubyString.newString(context.runtime, klass.toString());
        }

        @JRubyMethod(name={"annotations?"})
        public static IRubyObject annotations_p(ThreadContext context, IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return context.runtime.newBoolean(klass.getAnnotations().length > 0);
        }

        @JRubyMethod(name={"declared_annotations?"})
        public static IRubyObject declared_annotations_p(ThreadContext context, IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return context.runtime.newBoolean(klass.getDeclaredAnnotations().length > 0);
        }

        @JRubyMethod
        public static IRubyObject java_instance_methods(ThreadContext context, IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            RubyArray methods2 = RubyArray.newArray(context.runtime);
            for (Method method : klass.getMethods()) {
                if (Modifier.isStatic(method.getModifiers())) continue;
                methods2.add(method);
            }
            return methods2;
        }

        @JRubyMethod
        public static IRubyObject declared_instance_methods(ThreadContext context, IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            RubyArray methods2 = RubyArray.newArray(context.runtime);
            for (Method method : klass.getDeclaredMethods()) {
                if (Modifier.isStatic(method.getModifiers())) continue;
                methods2.add(method);
            }
            return methods2;
        }

        @JRubyMethod
        public static IRubyObject java_class_methods(ThreadContext context, IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            RubyArray methods2 = RubyArray.newArray(context.runtime);
            for (Method method : klass.getMethods()) {
                if (!Modifier.isStatic(method.getModifiers())) continue;
                methods2.add(method);
            }
            return methods2;
        }

        @JRubyMethod
        public static IRubyObject declared_class_methods(ThreadContext context, IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            RubyArray methods2 = RubyArray.newArray(context.runtime);
            for (Method method : klass.getDeclaredMethods()) {
                if (!Modifier.isStatic(method.getModifiers())) continue;
                methods2.add(method);
            }
            return methods2;
        }

        @JRubyMethod(name={"<=>"})
        public static IRubyObject cmp(ThreadContext context, IRubyObject self2, IRubyObject other) {
            java.lang.Class that;
            if (other instanceof JavaClass) {
                that = ((JavaClass)other).getJavaClass();
            } else if (JavaUtil.isJavaObject(other)) {
                that = (java.lang.Class)JavaUtil.unwrapJavaObject(other);
            } else {
                return context.nil;
            }
            java.lang.Class thiz = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            if (thiz == that) {
                return context.runtime.newFixnum(0);
            }
            if (thiz.isAssignableFrom(that)) {
                return context.runtime.newFixnum(1);
            }
            if (that.isAssignableFrom(thiz)) {
                return context.runtime.newFixnum(-1);
            }
            return context.nil;
        }

        @JRubyMethod(name={"anonymous?"})
        public static IRubyObject anonymous_p(IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return self2.getRuntime().newBoolean(klass.isAnonymousClass());
        }

        @JRubyMethod(name={"abstract?"})
        public static IRubyObject abstract_p(IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isAbstract(self2, klass.getModifiers());
        }

        @JRubyMethod(name={"public?"})
        public static IRubyObject public_p(IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isPublic(self2, klass.getModifiers());
        }

        @JRubyMethod(name={"protected?"})
        public static IRubyObject protected_p(IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isProtected(self2, klass.getModifiers());
        }

        @JRubyMethod(name={"private?"})
        public static IRubyObject private_p(IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isPrivate(self2, klass.getModifiers());
        }

        @JRubyMethod(name={"final?"})
        public static IRubyObject final_p(IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isFinal(self2, klass.getModifiers());
        }

        @JRubyMethod(name={"static?"})
        public static IRubyObject static_p(IRubyObject self2) {
            java.lang.Class klass = (java.lang.Class)JavaUtil.unwrapJavaObject(self2);
            return JavaLangReflect.isStatic(self2, klass.getModifiers());
        }
    }

    @JRubyClass(name={"Java::JavaLang::Character"})
    public static class Character {
        static RubyClass define(Ruby runtime) {
            RubyModule Character2 = Java.getProxyClass(runtime, java.lang.Character.class);
            Character2.defineAnnotatedMethods(Character.class);
            return (RubyClass)Character2;
        }

        @JRubyMethod(name={"java_identifier_start?"}, meta=true)
        public static IRubyObject java_identifier_start_p(IRubyObject self2, IRubyObject num) {
            return self2.getRuntime().newBoolean(java.lang.Character.isJavaIdentifierStart(Character.to_char(num)));
        }

        @JRubyMethod(name={"java_identifier_part?"}, meta=true)
        public static IRubyObject java_identifier_part_p(IRubyObject self2, IRubyObject num) {
            return self2.getRuntime().newBoolean(java.lang.Character.isJavaIdentifierPart(Character.to_char(num)));
        }

        private static char to_char(IRubyObject num) {
            return ((java.lang.Character)num.toJava(java.lang.Character.TYPE)).charValue();
        }
    }

    @JRubyModule(name={"Java::JavaLang::Runnable"})
    public static class Runnable {
        static RubyModule define(Ruby runtime) {
            RubyModule Runnable2 = Java.getProxyClass(runtime, java.lang.Runnable.class);
            Runnable2.defineAnnotatedMethods(Runnable.class);
            return Runnable2;
        }

        @JRubyMethod
        public static IRubyObject to_proc(ThreadContext context, IRubyObject self2) {
            Ruby runtime = context.runtime;
            java.lang.Runnable runnable = (java.lang.Runnable)JavaUtil.unwrapIfJavaObject(self2);
            Block block = new Block(new RunBody(runtime, runnable));
            return new RubyProc(runtime, runtime.getProc(), block, null, -1);
        }

        private static final class RunBody
        extends JavaInternalBlockBody {
            private final java.lang.Runnable runnable;

            RunBody(Ruby runtime, java.lang.Runnable runnable) {
                super(runtime, Signature.NO_ARGUMENTS);
                this.runnable = runnable;
            }

            @Override
            public IRubyObject yield(ThreadContext context, IRubyObject[] args2) {
                return this.yieldImpl(context);
            }

            final IRubyObject yieldImpl(ThreadContext context) {
                this.runnable.run();
                return context.nil;
            }

            @Override
            protected final IRubyObject doYield(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
                return this.yieldImpl(context);
            }

            @Override
            protected final IRubyObject doYield(ThreadContext context, Block block, IRubyObject value2) {
                return this.yieldImpl(context);
            }
        }
    }

    @JRubyClass(name={"Java::JavaLang::Throwable"})
    public static class Throwable {
        static RubyModule define(Ruby runtime) {
            RubyModule Throwable2 = Java.getProxyClass(runtime, java.lang.Throwable.class);
            Throwable2.defineAnnotatedMethods(Throwable.class);
            return Throwable2;
        }

        @JRubyMethod
        public static IRubyObject backtrace(ThreadContext context, IRubyObject self2) {
            Ruby runtime = context.runtime;
            java.lang.Throwable throwable = (java.lang.Throwable)JavaUtil.unwrapIfJavaObject(self2);
            StackTraceElement[] stackTrace = throwable.getStackTrace();
            if (stackTrace == null) {
                return context.nil;
            }
            int len = stackTrace.length;
            if (len == 0) {
                return RubyArray.newEmptyArray(runtime);
            }
            IRubyObject[] backtrace2 = new IRubyObject[len];
            for (int i2 = 0; i2 < len; ++i2) {
                backtrace2[i2] = RubyString.newString(runtime, stackTrace[i2].toString());
            }
            return RubyArray.newArrayMayCopy(runtime, backtrace2);
        }

        @JRubyMethod
        public static IRubyObject set_backtrace(IRubyObject self2, IRubyObject backtrace2) {
            return self2.getRuntime().getNil();
        }

        @JRubyMethod
        public static IRubyObject message(ThreadContext context, IRubyObject self2) {
            java.lang.Throwable throwable = (java.lang.Throwable)JavaUtil.unwrapIfJavaObject(self2);
            String msg = throwable.getLocalizedMessage();
            return msg == null ? RubyString.newEmptyString(context.runtime) : RubyString.newString(context.runtime, msg);
        }

        @JRubyMethod
        public static IRubyObject to_s(ThreadContext context, IRubyObject self2) {
            return Throwable.message(context, self2);
        }

        @JRubyMethod
        public static IRubyObject inspect(ThreadContext context, IRubyObject self2) {
            java.lang.Throwable throwable = (java.lang.Throwable)JavaUtil.unwrapIfJavaObject(self2);
            return RubyString.newString(context.runtime, throwable.toString());
        }

        @JRubyMethod(name={"==="}, meta=true)
        public static IRubyObject eqq(ThreadContext context, IRubyObject self2, IRubyObject other) {
            java.lang.Class java_class2;
            if (other instanceof NativeException && (java_class2 = (java.lang.Class)self2.dataGetStruct()).isAssignableFrom(((NativeException)other).getCause().getClass())) {
                return context.runtime.getTrue();
            }
            return self2.op_eqq(context, other);
        }
    }

    @JRubyClass(name={"Java::JavaLang::Comparable"}, include={"Comparable"})
    public static class Comparable {
        static RubyModule define(Ruby runtime) {
            RubyModule Comparable2 = Java.getProxyClass(runtime, java.lang.Comparable.class);
            Comparable2.includeModule(runtime.getComparable());
            Comparable2.defineAnnotatedMethods(Comparable.class);
            return Comparable2;
        }

        @JRubyMethod(name={"<=>"})
        public static IRubyObject cmp(ThreadContext context, IRubyObject self2, IRubyObject other) {
            int cmp2;
            java.lang.Comparable comparable = (java.lang.Comparable)JavaUtil.unwrapIfJavaObject(self2);
            if (other.isNil()) {
                return context.nil;
            }
            Object otherComp = JavaUtil.unwrapIfJavaObject(other);
            try {
                cmp2 = comparable.compareTo(otherComp);
            }
            catch (ClassCastException ex) {
                throw context.runtime.newTypeError(ex.getMessage());
            }
            return RubyFixnum.newFixnum(context.runtime, cmp2);
        }
    }

    @JRubyModule(name={"Java::JavaLang::Iterable"}, include={"Enumerable"})
    public static class Iterable {
        static RubyModule define(Ruby runtime) {
            RubyModule Iterable2 = Java.getProxyClass(runtime, java.lang.Iterable.class);
            Iterable2.includeModule(runtime.getEnumerable());
            Iterable2.defineAnnotatedMethods(Iterable.class);
            return Iterable2;
        }

        @JRubyMethod
        public static IRubyObject each(ThreadContext context, IRubyObject self2, Block block) {
            Ruby runtime = context.runtime;
            if (!block.isGiven()) {
                return runtime.getEnumerator().callMethod("new", self2, runtime.newSymbol("each"));
            }
            java.lang.Iterable iterable = (java.lang.Iterable)JavaUtil.unwrapIfJavaObject(self2);
            for (Object value2 : iterable) {
                block.yield(context, JavaUtil.convertJavaToUsableRubyObject(runtime, value2));
            }
            return self2;
        }

        @JRubyMethod
        public static IRubyObject each_with_index(ThreadContext context, IRubyObject self2, Block block) {
            Ruby runtime = context.runtime;
            if (!block.isGiven()) {
                return runtime.getEnumerator().callMethod("new", self2, runtime.newSymbol("each_with_index"));
            }
            java.lang.Iterable iterable = (java.lang.Iterable)JavaUtil.unwrapIfJavaObject(self2);
            Iterator iterator = iterable.iterator();
            boolean arity2 = block.getSignature().arity() == Arity.TWO_ARGUMENTS;
            int i2 = 0;
            while (iterator.hasNext()) {
                RubyFixnum index2 = RubyFixnum.newFixnum(runtime, i2++);
                Object value2 = iterator.next();
                IRubyObject rValue = JavaUtil.convertJavaToUsableRubyObject(runtime, value2);
                if (arity2) {
                    block.yieldSpecific(context, rValue, index2);
                    continue;
                }
                block.yield(context, RubyArray.newArray(runtime, rValue, index2));
            }
            return self2;
        }

        @JRubyMethod(name={"to_a", "entries"})
        public static IRubyObject to_a(ThreadContext context, IRubyObject self2, Block block) {
            Ruby runtime = context.runtime;
            RubyArray ary = runtime.newArray();
            java.lang.Iterable iterable = (java.lang.Iterable)JavaUtil.unwrapIfJavaObject(self2);
            for (Object value2 : iterable) {
                ary.append(JavaUtil.convertJavaToUsableRubyObject(runtime, value2));
            }
            return ary;
        }

        @JRubyMethod(name={"count"})
        public static IRubyObject count(ThreadContext context, IRubyObject self2, Block block) {
            Ruby runtime = context.runtime;
            java.lang.Iterable iterable = (java.lang.Iterable)JavaUtil.unwrapIfJavaObject(self2);
            if (block.isGiven()) {
                return Iterable.countBlock(context, iterable.iterator(), block);
            }
            if (iterable instanceof Collection) {
                return RubyFixnum.newFixnum(runtime, ((Collection)iterable).size());
            }
            int count2 = 0;
            Iterator it = iterable.iterator();
            while (it.hasNext()) {
                it.next();
                ++count2;
            }
            return RubyFixnum.newFixnum(runtime, count2);
        }

        static RubyFixnum countBlock(ThreadContext context, Iterator it, Block block) {
            Ruby runtime = context.runtime;
            int count2 = 0;
            while (it.hasNext()) {
                IRubyObject next2 = JavaUtil.convertJavaToUsableRubyObject(runtime, it.next());
                if (!block.yield(context, next2).isTrue()) continue;
                ++count2;
            }
            return RubyFixnum.newFixnum(runtime, count2);
        }

        @JRubyMethod(name={"count"})
        public static IRubyObject count(ThreadContext context, IRubyObject self2, IRubyObject obj, Block unused2) {
            Ruby runtime = context.runtime;
            java.lang.Iterable iterable = (java.lang.Iterable)JavaUtil.unwrapIfJavaObject(self2);
            int count2 = 0;
            Iterator it = iterable.iterator();
            while (it.hasNext()) {
                IRubyObject next2 = JavaUtil.convertJavaToUsableRubyObject(runtime, it.next());
                if (!RubyObject.equalInternal(context, next2, obj)) continue;
                ++count2;
            }
            return RubyFixnum.newFixnum(runtime, count2);
        }
    }
}

