/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.java.parser.JavaParser;
import com.intellij.lang.java.parser.JavaParserUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiJavaFileStubImpl;
import com.intellij.psi.impl.source.JavaLightStubBuilder;
import com.intellij.psi.impl.source.tree.java.JavaFileElement;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.LightStubBuilder;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import com.intellij.util.io.StringRef;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaFileElementType
extends ILightStubFileElementType<PsiJavaFileStub> {
    public static final int STUB_VERSION = 40;

    public JavaFileElementType() {
        super("java.FILE", JavaLanguage.INSTANCE);
    }

    @Override
    public LightStubBuilder getBuilder() {
        return new JavaLightStubBuilder();
    }

    @Override
    public int getStubVersion() {
        return 40;
    }

    @Override
    public boolean shouldBuildStubFor(VirtualFile file2) {
        return JavaFileElementType.isInSourceContent(file2);
    }

    public static boolean isInSourceContent(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/JavaFileElementType", "isInSourceContent"));
        }
        VirtualFile dir = file2.getParent();
        return dir == null || dir.getUserData(LanguageLevel.KEY) != null;
    }

    @Override
    public ASTNode createNode(CharSequence text2) {
        return new JavaFileElement(text2);
    }

    @Override
    public FlyweightCapableTreeStructure<LighterASTNode> parseContentsLight(ASTNode chameleon) {
        PsiBuilder builder = JavaParserUtil.createBuilder(chameleon);
        this.doParse(builder);
        return builder.getLightTree();
    }

    @Override
    public ASTNode parseContents(ASTNode chameleon) {
        PsiBuilder builder = JavaParserUtil.createBuilder(chameleon);
        this.doParse(builder);
        return builder.getTreeBuilt().getFirstChildNode();
    }

    private void doParse(PsiBuilder builder) {
        PsiBuilder.Marker root2 = builder.mark();
        JavaParser.INSTANCE.getFileParser().parse(builder);
        root2.done(this);
    }

    @Override
    @NotNull
    public String getExternalId() {
        if ("java.FILE" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/JavaFileElementType", "getExternalId"));
        }
        return "java.FILE";
    }

    @Override
    public void serialize(@NotNull PsiJavaFileStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/JavaFileElementType", "serialize"));
        }
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/source/JavaFileElementType", "serialize"));
        }
        dataStream.writeBoolean(stub.isCompiled());
        LanguageLevel level = stub.getLanguageLevel();
        dataStream.writeByte(level != null ? level.ordinal() : -1);
        dataStream.writeName(stub.getPackageName());
    }

    @Override
    @NotNull
    public PsiJavaFileStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        if (dataStream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataStream", "com/intellij/psi/impl/source/JavaFileElementType", "deserialize"));
        }
        boolean compiled = dataStream.readBoolean();
        byte level = dataStream.readByte();
        StringRef packageName = dataStream.readName();
        PsiJavaFileStubImpl psiJavaFileStubImpl = new PsiJavaFileStubImpl(null, StringRef.toString(packageName), level >= 0 ? LanguageLevel.values()[level] : null, compiled);
        if (psiJavaFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/JavaFileElementType", "deserialize"));
        }
        return psiJavaFileStubImpl;
    }

    @Override
    public void indexStub(@NotNull PsiJavaFileStub stub, @NotNull IndexSink sink) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stub", "com/intellij/psi/impl/source/JavaFileElementType", "indexStub"));
        }
        if (sink == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/psi/impl/source/JavaFileElementType", "indexStub"));
        }
    }
}

