/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.Condition;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UniqueNameGenerator
implements Condition<String> {
    private final Set<String> myExistingNames = new THashSet<String>();

    @Override
    public final boolean value(String candidate2) {
        return this.isUnique(candidate2);
    }

    public final boolean isUnique(@NotNull String candidate2) {
        if (candidate2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "candidate", "com/intellij/util/text/UniqueNameGenerator", "isUnique"));
        }
        return !this.myExistingNames.contains(candidate2);
    }

    @NotNull
    public static String generateUniqueName(String defaultName, String prefix, String suffix, String beforeNumber, String afterNumber, Condition<String> validator) {
        String defaultFullName = prefix + defaultName + suffix;
        if (validator.value(defaultFullName)) {
            String string = defaultFullName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/UniqueNameGenerator", "generateUniqueName"));
            }
            return string;
        }
        int i = 2;
        while (true) {
            String fullName;
            if (validator.value(fullName = prefix + defaultName + beforeNumber + i + afterNumber + suffix)) {
                String string = fullName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/UniqueNameGenerator", "generateUniqueName"));
                }
                return string;
            }
            ++i;
        }
    }

    @NotNull
    public String generateUniqueName(String defaultName, String prefix, String suffix) {
        String string = this.generateUniqueName(defaultName, prefix, suffix, "", "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/UniqueNameGenerator", "generateUniqueName"));
        }
        return string;
    }

    @NotNull
    public String generateUniqueName(String defaultName, String prefix, String suffix, String beforeNumber, String afterNumber) {
        String result2 = UniqueNameGenerator.generateUniqueName(defaultName, prefix, suffix, beforeNumber, afterNumber, this);
        this.addExistingName(result2);
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/text/UniqueNameGenerator", "generateUniqueName"));
        }
        return string;
    }

    public void addExistingName(@NotNull String result2) {
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/util/text/UniqueNameGenerator", "addExistingName"));
        }
        this.myExistingNames.add(result2);
    }

    public String generateUniqueName(String defaultName) {
        return this.generateUniqueName(defaultName, "", "");
    }
}

