/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeprecationResolver;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B#\b\u0016\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB)\u0012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0015\u0010\t\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "deprecationResolver", "Lorg/jetbrains/kotlin/resolve/DeprecationResolver;", "(Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/DeprecationResolver;)V", "resolutionContext", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "(Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/DeprecationResolver;)V", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getDataFlowInfo", "()Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "getDeprecationResolver", "()Lorg/jetbrains/kotlin/resolve/DeprecationResolver;", "isAnnotationContext", "", "()Z", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getResolutionContext", "()Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "getScope", "()Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "getTrace", "()Lorg/jetbrains/kotlin/resolve/BindingTrace;", "frontend"})
public final class CallCheckerContext {
    @NotNull
    private final ResolutionContext<?> resolutionContext;
    @NotNull
    private final BindingTrace trace;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final DeprecationResolver deprecationResolver;

    @NotNull
    public final LexicalScope getScope() {
        LexicalScope lexicalScope = this.resolutionContext.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "resolutionContext.scope");
        return lexicalScope;
    }

    @NotNull
    public final DataFlowInfo getDataFlowInfo() {
        DataFlowInfo dataFlowInfo = this.resolutionContext.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "resolutionContext.dataFlowInfo");
        return dataFlowInfo;
    }

    public final boolean isAnnotationContext() {
        return this.resolutionContext.isAnnotationContext;
    }

    @NotNull
    public final ResolutionContext<?> getResolutionContext() {
        return this.resolutionContext;
    }

    @NotNull
    public final BindingTrace getTrace() {
        return this.trace;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    @NotNull
    public final DeprecationResolver getDeprecationResolver() {
        return this.deprecationResolver;
    }

    public CallCheckerContext(@NotNull ResolutionContext<?> resolutionContext, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DeprecationResolver deprecationResolver) {
        Intrinsics.checkParameterIsNotNull(resolutionContext, "resolutionContext");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(deprecationResolver, "deprecationResolver");
        this.resolutionContext = resolutionContext;
        this.trace = trace;
        this.languageVersionSettings = languageVersionSettings;
        this.deprecationResolver = deprecationResolver;
    }

    public CallCheckerContext(@NotNull ResolutionContext<?> c, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DeprecationResolver deprecationResolver) {
        Intrinsics.checkParameterIsNotNull(c, "c");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(deprecationResolver, "deprecationResolver");
        BindingTrace bindingTrace = c.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.trace");
        this(c, bindingTrace, languageVersionSettings, deprecationResolver);
    }
}

