/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGrid.ServiceInstanceDescriptor;
import com.zeroc.IceGrid.TemplateDescriptor;
import com.zeroc.IceGridGUI.Application.Communicator;
import com.zeroc.IceGridGUI.Application.Editable;
import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Application.PlainService;
import com.zeroc.IceGridGUI.Application.PropertySet;
import com.zeroc.IceGridGUI.Application.Server;
import com.zeroc.IceGridGUI.Application.Service;
import com.zeroc.IceGridGUI.Application.ServiceInstanceEditor;
import com.zeroc.IceGridGUI.Application.TreeNode;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import com.zeroc.IceGridGUI.ApplicationActions;
import com.zeroc.IceGridGUI.Utils;
import com.zeroc.IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class ServiceInstance
extends TreeNode
implements Service,
Cloneable {
    private ServiceInstanceDescriptor _descriptor;
    private String _displayString;
    private final boolean _ephemeral;
    private Utils.Resolver _resolver;
    private ServiceInstanceEditor _editor;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static JPopupMenu _popup;

    public static ServiceInstanceDescriptor copyDescriptor(ServiceInstanceDescriptor instanceDescriptor) {
        ServiceInstanceDescriptor copy = instanceDescriptor.clone();
        copy.propertySet = PropertySet.copyDescriptor(copy.propertySet);
        if (copy.descriptor != null) {
            copy.descriptor = PlainService.copyDescriptor(copy.descriptor);
        }
        return copy;
    }

    public static List<ServiceInstanceDescriptor> copyDescriptors(List<ServiceInstanceDescriptor> descriptors) {
        LinkedList<ServiceInstanceDescriptor> copy = new LinkedList<ServiceInstanceDescriptor>();
        for (ServiceInstanceDescriptor p : descriptors) {
            copy.add(ServiceInstance.copyDescriptor(p));
        }
        return copy;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _cellRenderer.setLeafIcon(Utils.getIcon("/icons/16x16/service.png"));
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        boolean bl = actions[13] = !this._ephemeral;
        if (((TreeNode)this._parent).getAvailableActions()[14]) {
            actions[14] = true;
        }
        actions[15] = true;
        if (this._parent instanceof Server && !this._ephemeral) {
            actions[16] = true;
            actions[17] = true;
        }
        actions[18] = this.canMove(true);
        actions[19] = this.canMove(false);
        return actions;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(18));
            _popup.add(actions.get(19));
        }
        actions.setTarget(this);
        return _popup;
    }

    @Override
    public void copy() {
        this.getCoordinator().setClipboard(ServiceInstance.copyDescriptor(this._descriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    @Override
    public void paste() {
        ((TreeNode)this._parent).paste();
    }

    @Override
    public void moveUp() {
        this.move(true);
    }

    @Override
    public void moveDown() {
        this.move(false);
    }

    @Override
    public Object getDescriptor() {
        return this._descriptor;
    }

    @Override
    public Object saveDescriptor() {
        ServiceInstanceDescriptor saved = this._descriptor.clone();
        assert (saved.descriptor == null);
        return saved;
    }

    @Override
    public void restoreDescriptor(Object savedDescriptor) {
        ServiceInstanceDescriptor sd = (ServiceInstanceDescriptor)savedDescriptor;
        this._descriptor.template = sd.template;
        this._descriptor.parameterValues = sd.parameterValues;
        this._descriptor.propertySet = sd.propertySet;
    }

    @Override
    public void destroy() {
        ((Communicator)this._parent).getServices().destroyChild(this);
    }

    @Override
    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (ServiceInstanceEditor)this.getRoot().getEditor(ServiceInstanceEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    @Override
    protected Editor createEditor() {
        return new ServiceInstanceEditor();
    }

    @Override
    public String toString() {
        if (this._displayString != null) {
            return this._displayString;
        }
        return super.toString();
    }

    private boolean canMove(boolean up) {
        if (this._ephemeral) {
            return false;
        }
        return ((Communicator)this._parent).getServices().canMove(this, up);
    }

    private void move(boolean up) {
        assert (this.canMove(up));
        ((Communicator)this._parent).getServices().move(this, up);
    }

    Editable getEnclosingEditable() {
        return ((Communicator)this._parent).getEnclosingEditable();
    }

    @Override
    public Object rebuild(List<Editable> editables) throws UpdateFailedException {
        ServiceInstance newService;
        Backup backup;
        block8: {
            backup = new Backup();
            if (this._descriptor.template.length() > 0) {
                TemplateDescriptor templateDescriptor = this.getRoot().findServiceTemplateDescriptor(this._descriptor.template);
                HashSet<String> parameters = new HashSet<String>(templateDescriptor.parameters);
                if (!parameters.equals(this._descriptor.parameterValues.keySet())) {
                    backup.parameterValues = this._descriptor.parameterValues;
                    this._descriptor.parameterValues = Editor.makeParameterValues(this._descriptor.parameterValues, templateDescriptor.parameters);
                    editables.add(this.getEnclosingEditable());
                }
            }
            Communicator communicator = (Communicator)this._parent;
            Communicator.Services services = communicator.getServices();
            newService = null;
            try {
                newService = (ServiceInstance)services.createChild(this._descriptor);
            }
            catch (UpdateFailedException e) {
                if (backup.parameterValues != null) {
                    this._descriptor.parameterValues = backup.parameterValues;
                }
                throw e;
            }
            try {
                backup.clone = (ServiceInstance)this.clone();
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block8;
                throw new AssertionError();
            }
        }
        this.reset(newService);
        if (backup.parameterValues != null) {
            editables.add(this.getEnclosingEditable());
        }
        this.getRoot().getTreeModel().nodeChanged(this);
        return backup;
    }

    @Override
    public void restore(Object backupObj) {
        Backup backup = (Backup)backupObj;
        if (backup.parameterValues != null) {
            this._descriptor.parameterValues = backup.parameterValues;
        }
        this.reset(backup.clone);
        this.getRoot().getTreeModel().nodeChanged(this);
    }

    private void reset(ServiceInstance from) {
        this._id = from._id;
        this._displayString = from._displayString;
        this._resolver = from._resolver;
    }

    ServiceInstance(Communicator parent, String name, String displayString, ServiceInstanceDescriptor instanceDescriptor, Utils.Resolver resolver) throws UpdateFailedException {
        super(parent, name);
        this._displayString = displayString;
        this._descriptor = instanceDescriptor;
        this._ephemeral = false;
        this._resolver = resolver;
    }

    ServiceInstance(Communicator parent, String name, ServiceInstanceDescriptor instanceDescriptor) {
        super(parent, name);
        this._descriptor = instanceDescriptor;
        this._ephemeral = true;
    }

    @Override
    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            TemplateDescriptor templateDescriptor = this.getRoot().findServiceTemplateDescriptor(this._descriptor.template);
            LinkedList<String[]> attributes = ServiceInstance.parameterValuesToAttributes(this._descriptor.parameterValues, templateDescriptor.parameters);
            attributes.addFirst(ServiceInstance.createAttribute("template", this._descriptor.template));
            if (this._descriptor.propertySet.references.length == 0 && this._descriptor.propertySet.properties.size() == 0) {
                writer.writeElement("service-instance", attributes);
            } else {
                writer.writeStartTag("service-instance", attributes);
                ServiceInstance.writePropertySet(writer, this._descriptor.propertySet, null, null);
                writer.writeEndTag("service-instance");
            }
        }
    }

    @Override
    Utils.Resolver getResolver() {
        return this._resolver;
    }

    @Override
    public boolean isEphemeral() {
        return this._ephemeral;
    }

    private static class Backup {
        Map<String, String> parameterValues;
        ServiceInstance clone;

        private Backup() {
        }
    }
}

