/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.internal.XmlWriter;
import com.amazonaws.services.s3.model.GlacierJobParameters;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.RestoreObjectRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RequestXmlFactory {
    public static byte[] convertToXmlByteArray(List<PartETag> partETags) {
        XmlWriter xml2 = new XmlWriter();
        xml2.start("CompleteMultipartUpload");
        if (partETags != null) {
            ArrayList<PartETag> sortedPartETags = new ArrayList<PartETag>(partETags);
            Collections.sort(sortedPartETags, new Comparator<PartETag>(){

                @Override
                public int compare(PartETag tag1, PartETag tag2) {
                    if (tag1.getPartNumber() < tag2.getPartNumber()) {
                        return -1;
                    }
                    if (tag1.getPartNumber() > tag2.getPartNumber()) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (PartETag partEtag : sortedPartETags) {
                xml2.start("Part");
                xml2.start("PartNumber").value(Integer.toString(partEtag.getPartNumber())).end();
                xml2.start("ETag").value(partEtag.getETag()).end();
                xml2.end();
            }
        }
        xml2.end();
        return xml2.getBytes();
    }

    public static byte[] convertToXmlByteArray(RestoreObjectRequest restoreObjectRequest) throws SdkClientException {
        XmlWriter xml2 = new XmlWriter();
        xml2.start("RestoreRequest");
        xml2.start("Days").value(Integer.toString(restoreObjectRequest.getExpirationInDays())).end();
        GlacierJobParameters glacierJobParameters = restoreObjectRequest.getGlacierJobParameters();
        if (glacierJobParameters != null) {
            xml2.start("GlacierJobParameters");
            RequestXmlFactory.addIfNotNull(xml2, "Tier", glacierJobParameters.getTier());
            xml2.end();
        }
        xml2.end();
        return xml2.getBytes();
    }

    private static void addIfNotNull(XmlWriter xml2, String xmlTag, String value) {
        if (value != null) {
            xml2.start(xmlTag).value(value).end();
        }
    }
}

