/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.build.aws.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.springframework.build.aws.maven.TransferProgress;

final class TransferProgressFileOutputStream
extends FileOutputStream {
    private final TransferProgress transferProgress;

    TransferProgressFileOutputStream(File file2, TransferProgress transferProgress) throws FileNotFoundException {
        super(file2);
        this.transferProgress = transferProgress;
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        this.transferProgress.notify(new byte[]{(byte)b}, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b);
        this.transferProgress.notify(b, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        if (off == 0) {
            this.transferProgress.notify(b, len);
        } else {
            byte[] bytes2 = new byte[len];
            System.arraycopy(b, off, bytes2, 0, len);
            this.transferProgress.notify(bytes2, len);
        }
    }
}

