/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.restore;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.support.XContentMapValues;

public class RestoreSnapshotRequest
extends MasterNodeRequest<RestoreSnapshotRequest> {
    private String snapshot;
    private String repository;
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpen();
    private String renamePattern;
    private String renameReplacement;
    private boolean waitForCompletion;
    private boolean includeGlobalState = false;
    private boolean partial = false;
    private boolean includeAliases = true;
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private Settings indexSettings = Settings.Builder.EMPTY_SETTINGS;
    private String[] ignoreIndexSettings = Strings.EMPTY_ARRAY;

    public RestoreSnapshotRequest() {
    }

    public RestoreSnapshotRequest(String repository, String snapshot) {
        this.snapshot = snapshot;
        this.repository = repository;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.snapshot == null) {
            validationException = ValidateActions.addValidationError("name is missing", validationException);
        }
        if (this.repository == null) {
            validationException = ValidateActions.addValidationError("repository is missing", validationException);
        }
        if (this.indices == null) {
            validationException = ValidateActions.addValidationError("indices are missing", validationException);
        }
        if (this.indicesOptions == null) {
            validationException = ValidateActions.addValidationError("indicesOptions is missing", validationException);
        }
        if (this.settings == null) {
            validationException = ValidateActions.addValidationError("settings are missing", validationException);
        }
        if (this.indexSettings == null) {
            validationException = ValidateActions.addValidationError("indexSettings are missing", validationException);
        }
        if (this.ignoreIndexSettings == null) {
            validationException = ValidateActions.addValidationError("ignoreIndexSettings are missing", validationException);
        }
        return validationException;
    }

    public RestoreSnapshotRequest snapshot(String snapshot) {
        this.snapshot = snapshot;
        return this;
    }

    public String snapshot() {
        return this.snapshot;
    }

    public RestoreSnapshotRequest repository(String repository) {
        this.repository = repository;
        return this;
    }

    public String repository() {
        return this.repository;
    }

    public RestoreSnapshotRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    public RestoreSnapshotRequest indices(List<String> indices) {
        this.indices = indices.toArray(new String[indices.size()]);
        return this;
    }

    public String[] indices() {
        return this.indices;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public RestoreSnapshotRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public RestoreSnapshotRequest renamePattern(String renamePattern) {
        this.renamePattern = renamePattern;
        return this;
    }

    public String renamePattern() {
        return this.renamePattern;
    }

    public RestoreSnapshotRequest renameReplacement(String renameReplacement) {
        this.renameReplacement = renameReplacement;
        return this;
    }

    public String renameReplacement() {
        return this.renameReplacement;
    }

    public RestoreSnapshotRequest waitForCompletion(boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
        return this;
    }

    public boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public boolean partial() {
        return this.partial;
    }

    public RestoreSnapshotRequest partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public RestoreSnapshotRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public RestoreSnapshotRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public RestoreSnapshotRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public RestoreSnapshotRequest settings(Map<String, Object> source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            this.settings(builder.string(), builder.contentType());
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
        return this;
    }

    public Settings settings() {
        return this.settings;
    }

    public RestoreSnapshotRequest ignoreIndexSettings(String ... ignoreIndexSettings) {
        this.ignoreIndexSettings = ignoreIndexSettings;
        return this;
    }

    public RestoreSnapshotRequest ignoreIndexSettings(List<String> ignoreIndexSettings) {
        this.ignoreIndexSettings = ignoreIndexSettings.toArray(new String[ignoreIndexSettings.size()]);
        return this;
    }

    public String[] ignoreIndexSettings() {
        return this.ignoreIndexSettings;
    }

    public RestoreSnapshotRequest includeGlobalState(boolean includeGlobalState) {
        this.includeGlobalState = includeGlobalState;
        return this;
    }

    public boolean includeGlobalState() {
        return this.includeGlobalState;
    }

    public RestoreSnapshotRequest includeAliases(boolean includeAliases) {
        this.includeAliases = includeAliases;
        return this;
    }

    public boolean includeAliases() {
        return this.includeAliases;
    }

    public RestoreSnapshotRequest indexSettings(Settings settings) {
        this.indexSettings = settings;
        return this;
    }

    public RestoreSnapshotRequest indexSettings(Settings.Builder settings) {
        this.indexSettings = settings.build();
        return this;
    }

    public RestoreSnapshotRequest indexSettings(String source, XContentType xContentType) {
        this.indexSettings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public RestoreSnapshotRequest indexSettings(Map<String, Object> source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON);
            builder.map(source);
            this.indexSettings(builder.string(), builder.contentType());
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
        return this;
    }

    public Settings indexSettings() {
        return this.indexSettings;
    }

    public RestoreSnapshotRequest source(Map<String, Object> source) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String name = entry.getKey();
            if (name.equals("indices")) {
                if (entry.getValue() instanceof String) {
                    this.indices(Strings.splitStringByCommaToArray((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof ArrayList) {
                    this.indices((ArrayList)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed indices section, should be an array of strings");
            }
            if (name.equals("partial")) {
                this.partial(XContentMapValues.nodeBooleanValue(entry.getValue(), "partial"));
                continue;
            }
            if (name.equals("settings")) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new IllegalArgumentException("malformed settings section");
                }
                this.settings((Map)entry.getValue());
                continue;
            }
            if (name.equals("include_global_state")) {
                this.includeGlobalState = XContentMapValues.nodeBooleanValue(entry.getValue(), "include_global_state");
                continue;
            }
            if (name.equals("include_aliases")) {
                this.includeAliases = XContentMapValues.nodeBooleanValue(entry.getValue(), "include_aliases");
                continue;
            }
            if (name.equals("rename_pattern")) {
                if (entry.getValue() instanceof String) {
                    this.renamePattern((String)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed rename_pattern");
            }
            if (name.equals("rename_replacement")) {
                if (entry.getValue() instanceof String) {
                    this.renameReplacement((String)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed rename_replacement");
            }
            if (name.equals("index_settings")) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new IllegalArgumentException("malformed index_settings section");
                }
                this.indexSettings((Map)entry.getValue());
                continue;
            }
            if (name.equals("ignore_index_settings")) {
                if (entry.getValue() instanceof String) {
                    this.ignoreIndexSettings(Strings.splitStringByCommaToArray((String)entry.getValue()));
                    continue;
                }
                if (entry.getValue() instanceof List) {
                    this.ignoreIndexSettings((List)entry.getValue());
                    continue;
                }
                throw new IllegalArgumentException("malformed ignore_index_settings section, should be an array of strings");
            }
            if (IndicesOptions.isIndicesOptions(name)) continue;
            throw new IllegalArgumentException("Unknown parameter " + name);
        }
        this.indicesOptions(IndicesOptions.fromMap(source, this.indicesOptions));
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.snapshot = in.readString();
        this.repository = in.readString();
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.renamePattern = in.readOptionalString();
        this.renameReplacement = in.readOptionalString();
        this.waitForCompletion = in.readBoolean();
        this.includeGlobalState = in.readBoolean();
        this.partial = in.readBoolean();
        this.includeAliases = in.readBoolean();
        this.settings = Settings.readSettingsFromStream(in);
        this.indexSettings = Settings.readSettingsFromStream(in);
        this.ignoreIndexSettings = in.readStringArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.snapshot);
        out.writeString(this.repository);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeOptionalString(this.renamePattern);
        out.writeOptionalString(this.renameReplacement);
        out.writeBoolean(this.waitForCompletion);
        out.writeBoolean(this.includeGlobalState);
        out.writeBoolean(this.partial);
        out.writeBoolean(this.includeAliases);
        Settings.writeSettingsToStream(this.settings, out);
        Settings.writeSettingsToStream(this.indexSettings, out);
        out.writeStringArray(this.ignoreIndexSettings);
    }

    @Override
    public String getDescription() {
        return "snapshot [" + this.repository + ":" + this.snapshot + "]";
    }
}

