/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.TotalHitCountCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.join.ParentChildrenBlockJoinQuery;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.InnerHitBuilder;
import org.elasticsearch.index.query.InnerHitContextBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.search.ESToParentBlockJoinQuery;
import org.elasticsearch.index.search.NestedHelper;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.subphase.InnerHitsContext;
import org.elasticsearch.search.internal.SearchContext;

public class NestedQueryBuilder
extends AbstractQueryBuilder<NestedQueryBuilder> {
    public static final String NAME = "nested";
    public static final boolean DEFAULT_IGNORE_UNMAPPED = false;
    private static final ParseField SCORE_MODE_FIELD = new ParseField("score_mode", new String[0]);
    private static final ParseField PATH_FIELD = new ParseField("path", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private static final ParseField INNER_HITS_FIELD = new ParseField("inner_hits", new String[0]);
    private static final ParseField IGNORE_UNMAPPED_FIELD = new ParseField("ignore_unmapped", new String[0]);
    private final String path;
    private final ScoreMode scoreMode;
    private final QueryBuilder query;
    private InnerHitBuilder innerHitBuilder;
    private boolean ignoreUnmapped = false;

    public NestedQueryBuilder(String path, QueryBuilder query, ScoreMode scoreMode) {
        this(path, query, scoreMode, null);
    }

    private NestedQueryBuilder(String path, QueryBuilder query, ScoreMode scoreMode, InnerHitBuilder innerHitBuilder) {
        this.path = NestedQueryBuilder.requireValue(path, "[nested] requires 'path' field");
        this.query = NestedQueryBuilder.requireValue(query, "[nested] requires 'query' field");
        this.scoreMode = NestedQueryBuilder.requireValue(scoreMode, "[nested] requires 'score_mode' field");
        this.innerHitBuilder = innerHitBuilder;
    }

    public NestedQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.path = in.readString();
        this.scoreMode = ScoreMode.values()[in.readVInt()];
        this.query = in.readNamedWriteable(QueryBuilder.class);
        this.innerHitBuilder = in.readOptionalWriteable(InnerHitBuilder::new);
        this.ignoreUnmapped = in.readBoolean();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.path);
        out.writeVInt(this.scoreMode.ordinal());
        out.writeNamedWriteable(this.query);
        if (out.getVersion().before(Version.V_5_5_0)) {
            boolean hasInnerHit = this.innerHitBuilder != null;
            out.writeBoolean(hasInnerHit);
            if (hasInnerHit) {
                this.innerHitBuilder.writeToNestedBWC(out, this.query, this.path);
            }
        } else {
            out.writeOptionalWriteable(this.innerHitBuilder);
        }
        out.writeBoolean(this.ignoreUnmapped);
    }

    public QueryBuilder query() {
        return this.query;
    }

    public InnerHitBuilder innerHit() {
        return this.innerHitBuilder;
    }

    public NestedQueryBuilder innerHit(InnerHitBuilder innerHitBuilder) {
        this.innerHitBuilder = innerHitBuilder;
        return this;
    }

    public ScoreMode scoreMode() {
        return this.scoreMode;
    }

    public NestedQueryBuilder ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(QUERY_FIELD.getPreferredName());
        this.query.toXContent(builder, params);
        builder.field(PATH_FIELD.getPreferredName(), this.path);
        builder.field(IGNORE_UNMAPPED_FIELD.getPreferredName(), this.ignoreUnmapped);
        if (this.scoreMode != null) {
            builder.field(SCORE_MODE_FIELD.getPreferredName(), NestedQueryBuilder.scoreModeAsString(this.scoreMode));
        }
        this.printBoostAndQueryName(builder);
        if (this.innerHitBuilder != null) {
            builder.field(INNER_HITS_FIELD.getPreferredName(), this.innerHitBuilder, params);
        }
        builder.endObject();
    }

    public static NestedQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        float boost = 1.0f;
        ScoreMode scoreMode = ScoreMode.Avg;
        String queryName = null;
        QueryBuilder query = null;
        String path = null;
        String currentFieldName = null;
        InnerHitBuilder innerHitBuilder = null;
        boolean ignoreUnmapped = false;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                if (QUERY_FIELD.match(currentFieldName)) {
                    query = NestedQueryBuilder.parseInnerQueryBuilder(parser);
                    continue;
                }
                if (INNER_HITS_FIELD.match(currentFieldName)) {
                    innerHitBuilder = InnerHitBuilder.fromXContent(parser);
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[nested] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            if (!token.isValue()) continue;
            if (PATH_FIELD.match(currentFieldName)) {
                path = parser.text();
                continue;
            }
            if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName)) {
                boost = parser.floatValue();
                continue;
            }
            if (IGNORE_UNMAPPED_FIELD.match(currentFieldName)) {
                ignoreUnmapped = parser.booleanValue();
                continue;
            }
            if (SCORE_MODE_FIELD.match(currentFieldName)) {
                scoreMode = NestedQueryBuilder.parseScoreMode(parser.text());
                continue;
            }
            if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName)) {
                queryName = parser.text();
                continue;
            }
            throw new ParsingException(parser.getTokenLocation(), "[nested] query does not support [" + currentFieldName + "]", new Object[0]);
        }
        NestedQueryBuilder queryBuilder = (NestedQueryBuilder)((NestedQueryBuilder)new NestedQueryBuilder(path, query, scoreMode, innerHitBuilder).ignoreUnmapped(ignoreUnmapped).queryName(queryName)).boost(boost);
        return queryBuilder;
    }

    public static ScoreMode parseScoreMode(String scoreModeString) {
        if ("none".equals(scoreModeString)) {
            return ScoreMode.None;
        }
        if ("min".equals(scoreModeString)) {
            return ScoreMode.Min;
        }
        if ("max".equals(scoreModeString)) {
            return ScoreMode.Max;
        }
        if ("avg".equals(scoreModeString)) {
            return ScoreMode.Avg;
        }
        if ("sum".equals(scoreModeString)) {
            return ScoreMode.Total;
        }
        throw new IllegalArgumentException("No score mode for child query [" + scoreModeString + "] found");
    }

    public static String scoreModeAsString(ScoreMode scoreMode) {
        if (scoreMode == ScoreMode.Total) {
            return "sum";
        }
        return scoreMode.name().toLowerCase(Locale.ROOT);
    }

    @Override
    public final String getWriteableName() {
        return NAME;
    }

    @Override
    protected boolean doEquals(NestedQueryBuilder that) {
        return Objects.equals(this.query, that.query) && Objects.equals(this.path, that.path) && Objects.equals(this.scoreMode, that.scoreMode) && Objects.equals(this.innerHitBuilder, that.innerHitBuilder) && Objects.equals(this.ignoreUnmapped, that.ignoreUnmapped);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.query, this.path, this.scoreMode, this.innerHitBuilder, this.ignoreUnmapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        Query innerQuery;
        ObjectMapper nestedObjectMapper = context.getObjectMapper(this.path);
        if (nestedObjectMapper == null) {
            if (this.ignoreUnmapped) {
                return new MatchNoDocsQuery();
            }
            throw new IllegalStateException("[nested] failed to find nested object under path [" + this.path + "]");
        }
        if (!nestedObjectMapper.nested().isNested()) {
            throw new IllegalStateException("[nested] nested object under path [" + this.path + "] is not of nested type");
        }
        ObjectMapper objectMapper = context.nestedScope().getObjectMapper();
        BitSetProducer parentFilter = objectMapper == null ? context.bitsetFilter(Queries.newNonNestedFilter(context.indexVersionCreated())) : context.bitsetFilter(objectMapper.nestedTypeFilter());
        try {
            context.nestedScope().nextLevel(nestedObjectMapper);
            innerQuery = this.query.toQuery(context);
        }
        finally {
            context.nestedScope().previousLevel();
        }
        if (new NestedHelper(context.getMapperService()).mightMatchNonNestedDocs(innerQuery, this.path)) {
            innerQuery = Queries.filtered(innerQuery, nestedObjectMapper.nestedTypeFilter());
        }
        return new ESToParentBlockJoinQuery(innerQuery, parentFilter, this.scoreMode, objectMapper == null ? null : objectMapper.fullPath());
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryBuilder rewrittenQuery = this.query.rewrite(queryRewriteContext);
        if (rewrittenQuery != this.query) {
            NestedQueryBuilder nestedQuery = new NestedQueryBuilder(this.path, rewrittenQuery, this.scoreMode, this.innerHitBuilder);
            nestedQuery.ignoreUnmapped(this.ignoreUnmapped);
            return nestedQuery;
        }
        return this;
    }

    @Override
    public void extractInnerHitBuilders(Map<String, InnerHitContextBuilder> innerHits) {
        if (this.innerHitBuilder != null) {
            HashMap<String, InnerHitContextBuilder> children = new HashMap<String, InnerHitContextBuilder>();
            InnerHitContextBuilder.extractInnerHits(this.query, children);
            NestedInnerHitContextBuilder innerHitContextBuilder = new NestedInnerHitContextBuilder(this.path, this.query, this.innerHitBuilder, children);
            String name = this.innerHitBuilder.getName() != null ? this.innerHitBuilder.getName() : this.path;
            innerHits.put(name, innerHitContextBuilder);
        }
    }

    static final class NestedInnerHitSubContext
    extends InnerHitsContext.InnerHitSubContext {
        private final ObjectMapper parentObjectMapper;
        private final ObjectMapper childObjectMapper;

        NestedInnerHitSubContext(String name, SearchContext context, ObjectMapper parentObjectMapper, ObjectMapper childObjectMapper) {
            super(name, context);
            this.parentObjectMapper = parentObjectMapper;
            this.childObjectMapper = childObjectMapper;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TopDocs[] topDocs(SearchHit[] hits) throws IOException {
            Weight innerHitQueryWeight = this.createInnerHitQueryWeight();
            TopDocs[] result = new TopDocs[hits.length];
            for (int i = 0; i < hits.length; ++i) {
                SearchHit hit = hits[i];
                Query rawParentFilter = this.parentObjectMapper == null ? Queries.newNonNestedFilter(this.context.indexShard().indexSettings().getIndexVersionCreated()) : this.parentObjectMapper.nestedTypeFilter();
                int parentDocId = hit.docId();
                int readerIndex = ReaderUtil.subIndex((int)parentDocId, (List)this.searcher().getIndexReader().leaves());
                LeafReaderContext ctx = (LeafReaderContext)this.searcher().getIndexReader().leaves().get(readerIndex);
                Query childFilter = this.childObjectMapper.nestedTypeFilter();
                BitSetProducer parentFilter = this.context.bitsetFilterCache().getBitSetProducer(rawParentFilter);
                ParentChildrenBlockJoinQuery q = new ParentChildrenBlockJoinQuery(parentFilter, childFilter, parentDocId);
                Weight weight = this.context.searcher().createNormalizedWeight((Query)q, false);
                if (this.size() == 0) {
                    TotalHitCountCollector totalHitCountCollector = new TotalHitCountCollector();
                    InnerHitsContext.intersect(weight, innerHitQueryWeight, (Collector)totalHitCountCollector, ctx);
                    result[i] = new TopDocs((long)totalHitCountCollector.getTotalHits(), Lucene.EMPTY_SCORE_DOCS, 0.0f);
                    continue;
                }
                int topN = Math.min(this.from() + this.size(), this.context.searcher().getIndexReader().maxDoc());
                Object topDocsCollector = this.sort() != null ? TopFieldCollector.create((Sort)this.sort().sort, (int)topN, (boolean)true, (boolean)this.trackScores(), (boolean)this.trackScores(), (boolean)true) : TopScoreDocCollector.create((int)topN);
                try {
                    InnerHitsContext.intersect(weight, innerHitQueryWeight, (Collector)topDocsCollector, ctx);
                }
                finally {
                    this.clearReleasables(SearchContext.Lifetime.COLLECTION);
                }
                result[i] = topDocsCollector.topDocs(this.from(), this.size());
            }
            return result;
        }
    }

    static class NestedInnerHitContextBuilder
    extends InnerHitContextBuilder {
        private final String path;

        NestedInnerHitContextBuilder(String path, QueryBuilder query, InnerHitBuilder innerHitBuilder, Map<String, InnerHitContextBuilder> children) {
            super(query, innerHitBuilder, children);
            this.path = path;
        }

        @Override
        protected void doBuild(SearchContext parentSearchContext, InnerHitsContext innerHitsContext) throws IOException {
            QueryShardContext queryShardContext = parentSearchContext.getQueryShardContext();
            ObjectMapper nestedObjectMapper = queryShardContext.getObjectMapper(this.path);
            if (nestedObjectMapper == null) {
                if (!this.innerHitBuilder.isIgnoreUnmapped()) {
                    throw new IllegalStateException("[" + this.query.getName() + "] no mapping found for type [" + this.path + "]");
                }
                return;
            }
            String name = this.innerHitBuilder.getName() != null ? this.innerHitBuilder.getName() : nestedObjectMapper.fullPath();
            ObjectMapper parentObjectMapper = queryShardContext.nestedScope().nextLevel(nestedObjectMapper);
            NestedInnerHitSubContext nestedInnerHits = new NestedInnerHitSubContext(name, parentSearchContext, parentObjectMapper, nestedObjectMapper);
            this.setupInnerHitsContext(queryShardContext, nestedInnerHits);
            queryShardContext.nestedScope().previousLevel();
            innerHitsContext.addInnerHitDefinition(nestedInnerHits);
        }
    }
}

