/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.ParsedMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;

public class ParsedComposite
extends ParsedMultiBucketAggregation<ParsedBucket>
implements CompositeAggregation {
    private static ObjectParser<ParsedComposite, Void> PARSER = new ObjectParser(ParsedComposite.class.getSimpleName(), true, ParsedComposite::new);

    public static ParsedComposite fromXContent(XContentParser parser, String name) throws IOException {
        ParsedComposite aggregation = PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    @Override
    public String getType() {
        return "composite";
    }

    public List<ParsedBucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public Map<String, Object> afterKey() {
        return this.buckets.size() > 0 ? ((ParsedBucket)this.buckets.get(this.buckets.size() - 1)).getKey() : null;
    }

    @Override
    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return CompositeAggregation.toXContentFragment(this, builder, params);
    }

    static {
        ParsedComposite.declareMultiBucketAggregationFields(PARSER, parser -> ParsedBucket.fromXContent(parser), parser -> null);
    }

    public static class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements CompositeAggregation.Bucket {
        private Map<String, Object> key;

        @Override
        public String getKeyAsString() {
            return this.key.toString();
        }

        @Override
        public Map<String, Object> getKey() {
            return this.key;
        }

        void setKey(Map<String, Object> key) {
            this.key = key;
        }

        @Override
        public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            throw new UnsupportedOperationException("not implemented");
        }

        static ParsedBucket fromXContent(XContentParser parser) throws IOException {
            return ParsedBucket.parseXContent(parser, false, ParsedBucket::new, (p, bucket) -> bucket.setKey(p.mapOrdered()));
        }
    }
}

