/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;

public class EarlyTerminatingCollector
extends FilterCollector {
    private final int maxCountHits;
    private int numCollected;
    private boolean terminatedEarly = false;

    EarlyTerminatingCollector(Collector delegate, int maxCountHits) {
        super(delegate);
        this.maxCountHits = maxCountHits;
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        if (this.numCollected >= this.maxCountHits) {
            throw new CollectionTerminatedException();
        }
        return new FilterLeafCollector(super.getLeafCollector(context)){

            public void collect(int doc) throws IOException {
                super.collect(doc);
                if (++EarlyTerminatingCollector.this.numCollected >= EarlyTerminatingCollector.this.maxCountHits) {
                    EarlyTerminatingCollector.this.terminatedEarly = true;
                    throw new CollectionTerminatedException();
                }
            }
        };
    }

    public boolean terminatedEarly() {
        return this.terminatedEarly;
    }
}

