/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.preview;

import javax.swing.JPanel;
import org.gephi.io.exporter.preview.SVGExporter;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.preview.UIExporterPDF;
import org.gephi.ui.exporter.preview.UIExporterSVGPanel;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class UIExporterSVG
implements ExporterUI {
    private UIExporterSVGPanel panel;
    private SVGExporter exporterSVG;

    public void setup(Exporter exporter) {
        this.exporterSVG = (SVGExporter)exporter;
        this.loadPreferences();
        this.panel.setup(this.exporterSVG);
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporterSVG);
            this.savePreferences();
        }
        this.panel = null;
        this.exporterSVG = null;
    }

    public JPanel getPanel() {
        this.panel = new UIExporterSVGPanel();
        return this.panel;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof SVGExporter;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterPDF.class, (String)"UIExporterSVG.name");
    }

    private void loadPreferences() {
        boolean strokeScale = NbPreferences.forModule(UIExporterSVG.class).getBoolean("ScaleStrokeWidth", false);
        this.exporterSVG.setScaleStrokes(strokeScale);
    }

    private void savePreferences() {
        NbPreferences.forModule(UIExporterSVG.class).putBoolean("ScaleStrokeWidth", this.exporterSVG.isScaleStrokes());
    }
}

