/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load;

import tim.prune.I18nManager;
import tim.prune.data.Field;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.Timestamp;

public abstract class FieldGuesser {
    private static boolean isHeaderRow(String[] stringArray) {
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                if (FieldGuesser.fieldLooksNumeric(string)) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    private static boolean fieldLooksNumeric(String string) {
        if (string == null) {
            return false;
        }
        int n = string.length();
        if (n < 3) {
            return false;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (c >= '0' && c <= '9') {
                ++n2;
            }
            ++n3;
        }
        return n2 > n / 2;
    }

    public static Field[] guessFields(String[] stringArray) {
        boolean bl = FieldGuesser.isHeaderRow(stringArray);
        int n = stringArray.length;
        Field[] fieldArray = new Field[n];
        int n2 = 0;
        while (n2 < n) {
            if (stringArray[n2] != null) {
                String string = stringArray[n2].trim();
                if (!FieldGuesser.checkArrayHasField(fieldArray, Field.LATITUDE) && FieldGuesser.fieldLooksLikeLatitude(string, bl)) {
                    fieldArray[n2] = Field.LATITUDE;
                } else if (!FieldGuesser.checkArrayHasField(fieldArray, Field.LONGITUDE) && FieldGuesser.fieldLooksLikeLongitude(string, bl)) {
                    fieldArray[n2] = Field.LONGITUDE;
                } else if (!FieldGuesser.checkArrayHasField(fieldArray, Field.ALTITUDE) && FieldGuesser.fieldLooksLikeAltitude(string, bl)) {
                    fieldArray[n2] = Field.ALTITUDE;
                } else if (!FieldGuesser.checkArrayHasField(fieldArray, Field.WAYPT_NAME) && FieldGuesser.fieldLooksLikeName(string, bl)) {
                    fieldArray[n2] = Field.WAYPT_NAME;
                } else if (!FieldGuesser.checkArrayHasField(fieldArray, Field.TIMESTAMP) && FieldGuesser.fieldLooksLikeTimestamp(string, bl)) {
                    fieldArray[n2] = Field.TIMESTAMP;
                } else if (!FieldGuesser.checkArrayHasField(fieldArray, Field.NEW_SEGMENT) && FieldGuesser.fieldLooksLikeSegment(string, bl)) {
                    fieldArray[n2] = Field.NEW_SEGMENT;
                } else if (!FieldGuesser.checkArrayHasField(fieldArray, Field.WAYPT_TYPE) && FieldGuesser.fieldLooksLikeWaypointType(string, bl)) {
                    fieldArray[n2] = Field.WAYPT_TYPE;
                }
            }
            ++n2;
        }
        String string = String.valueOf(I18nManager.getText("fieldname.prefix")) + " ";
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            if (fieldArray[n4] == null) {
                if (!FieldGuesser.checkArrayHasField(fieldArray, Field.LATITUDE)) {
                    fieldArray[n4] = Field.LATITUDE;
                } else if (!FieldGuesser.checkArrayHasField(fieldArray, Field.LONGITUDE)) {
                    fieldArray[n4] = Field.LONGITUDE;
                } else {
                    Field field = null;
                    if (bl && stringArray[n4] != null && stringArray[n4].length() > 0) {
                        field = new Field(stringArray[n4]);
                    }
                    while (field == null || FieldGuesser.checkArrayHasField(fieldArray, field)) {
                        field = new Field(String.valueOf(string) + ++n3);
                    }
                    fieldArray[n4] = field;
                }
            }
            ++n4;
        }
        if (!FieldGuesser.checkArrayHasField(fieldArray, Field.LATITUDE)) {
            fieldArray[0] = Field.LATITUDE;
        } else if (!FieldGuesser.checkArrayHasField(fieldArray, Field.LONGITUDE)) {
            fieldArray[1] = Field.LONGITUDE;
        }
        if (!FieldGuesser.checkArrayHasField(fieldArray, Field.LATITUDE)) {
            fieldArray[0] = Field.LATITUDE;
        }
        return fieldArray;
    }

    private static boolean checkArrayHasField(Field[] fieldArray, Field field) {
        int n = 0;
        while (n < fieldArray.length) {
            if (fieldArray[n] != null && fieldArray[n].equals(field)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private static boolean fieldLooksLikeLatitude(String string, boolean bl) {
        if (string == null || string.equals("")) {
            return false;
        }
        if (bl) {
            String string2 = string.toUpperCase();
            return string2.equals("LATITUDE") || string2.equals(I18nManager.getText("fieldname.latitude").toUpperCase());
        }
        Latitude latitude = new Latitude(string);
        return latitude.isValid();
    }

    private static boolean fieldLooksLikeLongitude(String string, boolean bl) {
        if (string == null || string.equals("")) {
            return false;
        }
        if (bl) {
            String string2 = string.toUpperCase();
            return string2.equals("LONGITUDE") || string2.equals(I18nManager.getText("fieldname.longitude").toUpperCase());
        }
        Longitude longitude = new Longitude(string);
        return longitude.isValid();
    }

    private static boolean fieldLooksLikeAltitude(String string, boolean bl) {
        if (string == null || string.equals("")) {
            return false;
        }
        if (bl) {
            String string2 = string.toUpperCase();
            return string2.equals("ALTITUDE") || string2.equals("ALT") || string2.equals("HMSL") || string2.equals(I18nManager.getText("fieldname.altitude").toUpperCase());
        }
        try {
            int n = Integer.parseInt(string);
            return n > 0 && n < 100000;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean fieldLooksLikeName(String string, boolean bl) {
        if (string == null || string.equals("")) {
            return false;
        }
        if (bl) {
            String string2 = string.toUpperCase();
            return string2.equals("NAME") || string2.equals("LABEL") || string2.equals(I18nManager.getText("fieldname.waypointname").toUpperCase());
        }
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            if (Character.isLetter(c)) {
                ++n;
            }
            if (c == ':' || c == '.') {
                return false;
            }
            ++n2;
        }
        return n >= 2;
    }

    private static boolean fieldLooksLikeTimestamp(String string, boolean bl) {
        if (string == null || string.equals("")) {
            return false;
        }
        if (bl) {
            String string2 = string.toUpperCase();
            return string2.equals("TIMESTAMP") || string2.equals("TIME") || string2.equals(I18nManager.getText("fieldname.timestamp").toUpperCase());
        }
        if (string.length() < 7) {
            return false;
        }
        Timestamp timestamp = new Timestamp(string);
        return timestamp.isValid();
    }

    private static boolean fieldLooksLikeSegment(String string, boolean bl) {
        if (string == null || string.equals("")) {
            return false;
        }
        if (bl) {
            String string2 = string.toUpperCase();
            return string2.equals("SEGMENT") || string2.equals(I18nManager.getText("fieldname.newsegment").toUpperCase());
        }
        return false;
    }

    private static boolean fieldLooksLikeWaypointType(String string, boolean bl) {
        if (string == null || string.equals("")) {
            return false;
        }
        if (bl) {
            String string2 = string.toUpperCase();
            return string2.equals("TYPE") || string2.equals(I18nManager.getText("fieldname.waypointtype").toUpperCase());
        }
        return false;
    }
}

