/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.V3d;
import org.jmol.java.BS;
import org.jmol.minimize.MinAngle;
import org.jmol.minimize.MinAtom;
import org.jmol.minimize.MinBond;
import org.jmol.minimize.MinObject;
import org.jmol.minimize.MinPosition;
import org.jmol.minimize.MinTorsion;
import org.jmol.minimize.Util;
import org.jmol.minimize.forcefield.Calculation;
import org.jmol.minimize.forcefield.FFParam;
import org.jmol.minimize.forcefield.ForceField;

abstract class Calculations {
    public static final double RAD_TO_DEG = 57.29577951308232;
    public static final double DEG_TO_RAD = Math.PI / 180;
    static final double KCAL_TO_KJ = 4.1868;
    static final int CALC_DISTANCE = 0;
    static final int CALC_ANGLE = 1;
    static final int CALC_STRETCH_BEND = 2;
    static final int CALC_TORSION = 3;
    static final int CALC_OOP = 4;
    static final int CALC_VDW = 5;
    static final int CALC_ES = 6;
    static final int CALC_MAX = 7;
    FFParam parA;
    FFParam parB;
    FFParam parC;
    ForceField ff;
    Lst<Object[]>[] calculations = AU.createArrayOfArrayList((int)7);
    Map<Object, Object> ffParams;
    int ac;
    int bondCount;
    int angleCount;
    int torsionCount;
    MinAtom[] minAtoms;
    MinBond[] minBonds;
    MinAngle[] minAngles;
    MinTorsion[] minTorsions;
    MinPosition[] minPositions;
    Lst<Object[]> constraints;
    boolean isPreliminary;
    boolean gradients;
    boolean silent;
    SB logData = new SB();
    boolean logging;
    boolean loggingEnabled;
    final V3d da = new V3d();
    final V3d db = new V3d();
    final V3d dc = new V3d();
    final V3d dd = new V3d();
    int ia;
    int ib;
    int ic;
    int id;
    final V3d v1 = new V3d();
    final V3d v2 = new V3d();
    final V3d v3 = new V3d();
    private static final double PI_OVER_2 = 1.5707963267948966;
    private static final double TWO_PI = Math.PI * 2;

    abstract Object getParameterObj(MinObject var1);

    Object getParameter(Object o) {
        return this.ffParams.get(o);
    }

    public void setConstraints(Lst<Object[]> constraints) {
        this.constraints = constraints;
    }

    Calculations(ForceField ff, MinAtom[] minAtoms, MinBond[] minBonds, MinAngle[] minAngles, MinTorsion[] minTorsions, MinPosition[] minPositions, Lst<Object[]> constraints) {
        this.ff = ff;
        this.minAtoms = minAtoms;
        this.minBonds = minBonds;
        this.minAngles = minAngles;
        this.minTorsions = minTorsions;
        this.minPositions = minPositions;
        this.ac = minAtoms.length;
        this.bondCount = minBonds.length;
        this.angleCount = minAngles.length;
        this.torsionCount = minTorsions.length;
        this.constraints = constraints;
    }

    abstract boolean setupCalculations();

    abstract String getUnits();

    abstract double compute(int var1, Object[] var2);

    void addForce(V3d v, int i, double dE) {
        this.minAtoms[i].force[0] = this.minAtoms[i].force[0] + v.x * dE;
        this.minAtoms[i].force[1] = this.minAtoms[i].force[1] + v.y * dE;
        this.minAtoms[i].force[2] = this.minAtoms[i].force[2] + v.z * dE;
    }

    public void setSilent(boolean TF) {
        this.silent = TF;
    }

    public String getLogData() {
        return this.logData.toString();
    }

    void appendLogData(String s) {
        this.logData.append(s).append("\n");
    }

    void setLoggingEnabled(boolean TF) {
        this.loggingEnabled = TF;
        if (this.loggingEnabled) {
            this.logData = new SB();
        }
    }

    void setPreliminary(boolean TF) {
        this.isPreliminary = TF;
    }

    protected void pairSearch(Lst<Object[]> calc1, Calculation pc1, Lst<Object[]> calc2, Calculation pc2) {
        for (int i = 0; i < this.ac - 1; ++i) {
            BS bsVdw = this.minAtoms[i].bsVdw;
            int j = bsVdw.nextSetBit(0);
            while (j >= 0) {
                pc1.setData(calc1, i, j, 0.0);
                if (pc2 != null) {
                    pc2.setData(calc2, i, j, 0.0);
                }
                j = bsVdw.nextSetBit(j + 1);
            }
        }
    }

    private double calc(int iType, boolean gradients) {
        int nCalc;
        this.logging = this.loggingEnabled && !this.silent;
        this.gradients = gradients;
        Lst<Object[]> calcs = this.calculations[iType];
        double energy = 0.0;
        if (calcs == null || (nCalc = calcs.size()) == 0) {
            return 0.0;
        }
        if (this.logging) {
            this.appendLogData(this.getDebugHeader(iType));
        }
        for (int ii = 0; ii < nCalc; ++ii) {
            energy += this.compute(iType, (Object[])this.calculations[iType].get(ii));
        }
        if (this.logging) {
            this.appendLogData(this.getDebugFooter(iType, energy));
        }
        if (this.constraints != null && iType <= 3) {
            energy += this.constraintEnergy(iType);
        }
        return energy;
    }

    double energyStrBnd(boolean gradients) {
        return 0.0;
    }

    double energyBond(boolean gradients) {
        return this.calc(0, gradients);
    }

    double energyAngle(boolean gradients) {
        return this.calc(1, gradients);
    }

    double energyTorsion(boolean gradients) {
        return this.calc(3, gradients);
    }

    double energyStretchBend(boolean gradients) {
        return this.calc(2, gradients);
    }

    double energyOOP(boolean gradients) {
        return this.calc(4, gradients);
    }

    double energyVDW(boolean gradients) {
        return this.calc(5, gradients);
    }

    double energyES(boolean gradients) {
        return this.calc(6, gradients);
    }

    private double constraintEnergy(int iType) {
        double value = 0.0;
        double k = 0.0;
        double energy = 0.0;
        int i = this.constraints.size();
        while (--i >= 0) {
            Object[] c = (Object[])this.constraints.get(i);
            int nAtoms = ((int[])c[0])[0];
            if (nAtoms != iType + 2) continue;
            int[] minList = (int[])c[1];
            double targetValue = ((Float)c[2]).doubleValue();
            switch (iType) {
                case 3: {
                    this.id = minList[3];
                    if (this.gradients) {
                        this.dd.setA(this.minAtoms[this.id].coord);
                    }
                }
                case 1: {
                    this.ic = minList[2];
                    if (this.gradients) {
                        this.dc.setA(this.minAtoms[this.ic].coord);
                    }
                }
                case 0: {
                    this.ib = minList[1];
                    this.ia = minList[0];
                    if (!this.gradients) break;
                    this.db.setA(this.minAtoms[this.ib].coord);
                    this.da.setA(this.minAtoms[this.ia].coord);
                }
            }
            k = 10000.0;
            switch (iType) {
                case 3: {
                    targetValue *= Math.PI / 180;
                    double d = value = this.gradients ? Util.restorativeForceAndTorsionAngleRadians(this.da, this.db, this.dc, this.dd) : Util.getTorsionAngleRadians(this.minAtoms[this.ia].coord, this.minAtoms[this.ib].coord, this.minAtoms[this.ic].coord, this.minAtoms[this.id].coord, this.v1, this.v2, this.v3);
                    if (value < 0.0 && targetValue >= 1.5707963267948966) {
                        value += Math.PI * 2;
                        break;
                    }
                    if (!(value > 0.0) || !(targetValue <= -1.5707963267948966)) break;
                    targetValue += Math.PI * 2;
                    break;
                }
                case 1: {
                    targetValue *= Math.PI / 180;
                    value = this.gradients ? Util.restorativeForceAndAngleRadians(this.da, this.db, this.dc) : Util.getAngleRadiansABC(this.minAtoms[this.ia].coord, this.minAtoms[this.ib].coord, this.minAtoms[this.ic].coord);
                    break;
                }
                case 0: {
                    value = this.gradients ? Util.restorativeForceAndDistance(this.da, this.db, this.dc) : Math.sqrt(Util.distance2(this.minAtoms[this.ia].coord, this.minAtoms[this.ib].coord));
                }
            }
            energy += this.constrainQuadratic(value, targetValue, k, iType);
        }
        return energy;
    }

    private double constrainQuadratic(double value, double targetValue, double k, int iType) {
        if (!Util.isFinite(value)) {
            return 0.0;
        }
        double delta = value - targetValue;
        if (this.gradients) {
            double dE = 2.0 * k * delta;
            switch (iType) {
                case 3: {
                    this.addForce(this.dd, this.id, dE);
                }
                case 1: {
                    this.addForce(this.dc, this.ic, dE);
                }
                case 0: {
                    this.addForce(this.db, this.ib, dE);
                    this.addForce(this.da, this.ia, dE);
                }
            }
        }
        return k * delta * delta;
    }

    void getConstraintList() {
        if (this.constraints == null || this.constraints.size() == 0) {
            return;
        }
        this.appendLogData("C O N S T R A I N T S\n---------------------");
        int i = this.constraints.size();
        while (--i >= 0) {
            Object[] c = (Object[])this.constraints.get(i);
            int[] indexes = (int[])c[0];
            int[] minList = (int[])c[1];
            double targetValue = ((Float)c[2]).doubleValue();
            int iType = indexes[0] - 2;
            switch (iType) {
                case 3: {
                    this.id = minList[3];
                }
                case 1: {
                    this.ic = minList[2];
                }
                case 0: {
                    this.ib = minList[1];
                    this.ia = minList[0];
                }
            }
            switch (iType) {
                case 0: {
                    this.appendLogData(PT.sprintf((String)"%3d %3d  %-5s %-5s  %12.6f", (String)"ssFI", (Object[])new Object[]{this.minAtoms[this.ia].atom.getAtomName(), this.minAtoms[this.ib].atom.getAtomName(), new float[]{(float)targetValue}, new int[]{this.minAtoms[this.ia].atom.getAtomNumber(), this.minAtoms[this.ib].atom.getAtomNumber()}}));
                    break;
                }
                case 1: {
                    this.appendLogData(PT.sprintf((String)"%3d %3d %3d  %-5s %-5s %-5s  %12.6f", (String)"sssFI", (Object[])new Object[]{this.minAtoms[this.ia].atom.getAtomName(), this.minAtoms[this.ib].atom.getAtomName(), this.minAtoms[this.ic].atom.getAtomName(), new float[]{(float)targetValue}, new int[]{this.minAtoms[this.ia].atom.getAtomNumber(), this.minAtoms[this.ib].atom.getAtomNumber(), this.minAtoms[this.ic].atom.getAtomNumber()}}));
                    break;
                }
                case 3: {
                    this.appendLogData(PT.sprintf((String)"%3d %3d %3d %3d  %-5s %-5s %-5s %-5s  %3d %8.3f     %8.3f     %8.3f     %8.3f", (String)"ssssFI", (Object[])new Object[]{this.minAtoms[this.ia].atom.getAtomName(), this.minAtoms[this.ib].atom.getAtomName(), this.minAtoms[this.ic].atom.getAtomName(), this.minAtoms[this.id].atom.getAtomName(), new float[]{(float)targetValue}, new int[]{this.minAtoms[this.ia].atom.getAtomNumber(), this.minAtoms[this.ib].atom.getAtomNumber(), this.minAtoms[this.ic].atom.getAtomNumber(), this.minAtoms[this.id].atom.getAtomNumber()}}));
                }
            }
        }
        this.appendLogData("---------------------\n");
    }

    String getAtomList(String title) {
        String trailer = "--------------------------------------------------------------------------------------------------\n";
        SB sb = new SB();
        sb.append("\n" + title + "\n\n" + " ATOM    X        Y        Z    TYPE       GRADX    GRADY    GRADZ  " + "---------BONDED ATOMS--------\n" + trailer);
        for (int i = 0; i < this.ac; ++i) {
            MinAtom atom = this.minAtoms[i];
            int[] others = atom.getBondedAtomIndexes();
            int[] iVal = new int[others.length + 2];
            iVal[0] = atom.atom.getAtomNumber();
            iVal[1] = atom.ffAtomType == null ? 0 : atom.ffAtomType.mmType;
            String s = "   ";
            for (int j = 0; j < others.length; ++j) {
                s = s + " %3d";
                iVal[j + 2] = this.minAtoms[others[j]].atom.getAtomNumber();
            }
            sb.append(PT.sprintf((String)("%3d %8.3f %8.3f %8.3f %-5s %2d %8.3f %8.3f %8.3f" + s + "\n"), (String)"sFI", (Object[])new Object[]{atom.sType, new float[]{(float)atom.coord[0], (float)atom.coord[1], (float)atom.coord[2], (float)atom.force[0], (float)atom.force[1], (float)atom.force[2]}, iVal}));
        }
        sb.append(trailer + "\n\n");
        return sb.toString();
    }

    abstract String getDebugHeader(int var1);

    protected String getDebugHeader2(int iType) {
        switch (iType) {
            case -1: {
                break;
            }
            case 0: {
                return "\nB O N D   S T R E T C H I N G (" + this.bondCount + " bonds)\n\n" + "  ATOMS  ATOM TYPES   BOND    BOND       IDEAL      FORCE\n" + "  I   J   I     J     TYPE   LENGTH     LENGTH    CONSTANT      DELTA     ENERGY\n" + "--------------------------------------------------------------------------------";
            }
            case 1: {
                return "\nA N G L E   B E N D I N G (" + this.minAngles.length + " angles)\n\n" + "    ATOMS      ATOM TYPES        VALENCE    IDEAL        FORCE\n" + "  I   J   K   I     J     K       ANGLE     ANGLE      CONSTANT     ENERGY\n" + "--------------------------------------------------------------------------";
            }
            case 2: {
                return "\nS T R E T C H   B E N D I N G (" + this.minAngles.length * 2 + " angles)\n\n" + "    ATOMS      ATOM TYPES        VALENCE    IDEAL        FORCE\n" + "  I   J   K   I     J     K       ANGLE     ANGLE      CONSTANT     ENERGY\n" + "--------------------------------------------------------------------------";
            }
            case 3: {
                return "\nT O R S I O N A L (" + this.minTorsions.length + " torsions)\n\n" + "      ATOMS           ATOM TYPES            n    COS          FORCE      TORSION\n" + "  I   J   K   L   I     J     K     L          (n phi0)      CONSTANT     ANGLE        ENERGY\n" + "---------------------------------------------------------------------------------------------";
            }
            case 4: {
                return "\nO U T - O F - P L A N E   B E N D I N G\n\n      ATOMS           ATOM TYPES             OOP        FORCE \n  I   J   K   L   I     J     K     L       ANGLE     CONSTANT      ENERGY\n--------------------------------------------------------------------------";
            }
            case 5: {
                return "\nV A N   D E R   W A A L S  (partial list)\n\n  ATOMS  ATOM TYPES\n  I   J   I     J      Rij       kij     ENERGY\n-----------------------------------------------";
            }
            case 6: {
                return "\nE L E C T R O S T A T I C   I N T E R A C T I O N S  (partial list)\n\n  ATOMS  ATOM TYPES \n  I   J   I     J      Rij      f          Qi          Qj    ENERGY\n-------------------------------------------------------------------";
            }
        }
        return "";
    }

    String getDebugLine(int iType, Calculation c) {
        return this.getDebugLineC(iType, c);
    }

    protected String getDebugLineC(int iType, Calculation c) {
        float energy = this.ff.toUserUnits(c.energy);
        switch (iType) {
            case 0: {
                return PT.sprintf((String)"%3d %3d  %-5s %-5s  %4.2f%8.3f   %8.3f     %8.3f   %8.3f   %8.3f", (String)"ssFI", (Object[])new Object[]{this.minAtoms[c.ia].sType, this.minAtoms[c.ib].sType, new float[]{0.0f, (float)c.rab, (float)c.dData[1], (float)c.dData[0], (float)c.delta, energy}, new int[]{this.minAtoms[c.ia].atom.getAtomNumber(), this.minAtoms[c.ib].atom.getAtomNumber()}});
            }
            case 1: 
            case 2: {
                return PT.sprintf((String)"%3d %3d %3d  %-5s %-5s %-5s  %8.3f  %8.3f     %8.3f   %8.3f", (String)"sssFI", (Object[])new Object[]{this.minAtoms[c.ia].sType, this.minAtoms[c.ib].sType, this.minAtoms[c.ic].sType, new float[]{(float)(c.theta * 57.29577951308232), (float)c.dData[1], (float)c.dData[0], energy}, new int[]{this.minAtoms[c.ia].atom.getAtomNumber(), this.minAtoms[c.ib].atom.getAtomNumber(), this.minAtoms[c.ic].atom.getAtomNumber()}});
            }
            case 3: {
                return PT.sprintf((String)"%3d %3d %3d %3d  %-5s %-5s %-5s %-5s  %3d %8.3f     %8.3f     %8.3f     %8.3f", (String)"ssssFI", (Object[])new Object[]{this.minAtoms[c.ia].sType, this.minAtoms[c.ib].sType, this.minAtoms[c.ic].sType, this.minAtoms[c.id].sType, new float[]{(float)c.dData[1], (float)c.dData[0], (float)(c.theta * 57.29577951308232), energy}, new int[]{this.minAtoms[c.ia].atom.getAtomNumber(), this.minAtoms[c.ib].atom.getAtomNumber(), this.minAtoms[c.ic].atom.getAtomNumber(), this.minAtoms[c.id].atom.getAtomNumber(), c.iData[4]}});
            }
            case 4: {
                return PT.sprintf((String)"%3d %3d %3d %3d  %-5s %-5s %-5s %-5s  %8.3f   %8.3f     %8.3f", (String)"ssssFI", (Object[])new Object[]{this.minAtoms[c.ia].sType, this.minAtoms[c.ib].sType, this.minAtoms[c.ic].sType, this.minAtoms[c.id].sType, new float[]{(float)(c.theta * 57.29577951308232), (float)c.dData[0], energy}, new int[]{this.minAtoms[c.ia].atom.getAtomNumber(), this.minAtoms[c.ib].atom.getAtomNumber(), this.minAtoms[c.ic].atom.getAtomNumber(), this.minAtoms[c.id].atom.getAtomNumber()}});
            }
            case 5: {
                return PT.sprintf((String)"%3d %3d  %-5s %-5s %6.3f  %8.3f  %8.3f", (String)"ssFI", (Object[])new Object[]{this.minAtoms[c.iData[0]].sType, this.minAtoms[c.iData[1]].sType, new float[]{(float)c.rab, (float)c.dData[0], energy}, new int[]{this.minAtoms[c.ia].atom.getAtomNumber(), this.minAtoms[c.ib].atom.getAtomNumber()}});
            }
            case 6: {
                return PT.sprintf((String)"%3d %3d  %-5s %-5s %6.3f  %8.3f  %8.3f  %8.3f  %8.3f", (String)"ssFI", (Object[])new Object[]{this.minAtoms[c.iData[0]].sType, this.minAtoms[c.iData[1]].sType, new float[]{(float)c.rab, (float)c.dData[0], (float)c.dData[1], (float)c.dData[2], energy}, new int[]{this.minAtoms[c.ia].atom.getAtomNumber(), this.minAtoms[c.ib].atom.getAtomNumber()}});
            }
        }
        return "";
    }

    String getDebugFooter(int iType, double energy) {
        String s = "";
        switch (iType) {
            case 0: {
                s = "BOND STRETCHING";
                break;
            }
            case 1: {
                s = "ANGLE BENDING";
                break;
            }
            case 3: {
                s = "TORSIONAL";
                break;
            }
            case 4: {
                s = "OUT-OF-PLANE BENDING";
                break;
            }
            case 2: {
                s = "STRETCH BENDING";
                break;
            }
            case 5: {
                s = "VAN DER WAALS";
                break;
            }
            case 6: {
                s = "ELECTROSTATIC ENERGY";
            }
        }
        return PT.sprintf((String)"\n     TOTAL %s ENERGY = %8.3f %s/mol\n", (String)"sfs", (Object[])new Object[]{s, Float.valueOf(this.ff.toUserUnits(energy)), this.ff.minimizer.units});
    }

    void setPairVariables(Calculation c) {
        if (this.gradients) {
            this.setCoords(c, 2);
            c.rab = Util.restorativeForceAndDistance(this.da, this.db, this.dc);
        } else {
            c.rab = Math.sqrt(Util.distance2(this.minAtoms[c.ia].coord, this.minAtoms[c.ib].coord));
        }
        if (Util.isNearZero2(c.rab, 0.001)) {
            c.rab = 0.001;
        }
    }

    void setAngleVariables(Calculation c) {
        if (this.gradients) {
            this.setCoords(c, 3);
            c.theta = Util.restorativeForceAndAngleRadians(this.da, this.db, this.dc);
        } else {
            c.theta = Util.getAngleRadiansABC(this.minAtoms[c.ia].coord, this.minAtoms[c.ib].coord, this.minAtoms[c.ic].coord);
        }
        if (!Util.isFinite(c.theta)) {
            c.theta = 0.0;
        }
    }

    void setOopVariables(Calculation c, boolean fixTheta) {
        this.setCoords(c, 4);
        c.theta = this.gradients ? Util.restorativeForceAndOutOfPlaneAngleRadians(this.da, this.db, this.dc, this.dd, this.v1, this.v2, this.v3) : Util.pointPlaneAngleRadians(this.da, this.db, this.dc, this.dd, this.v1, this.v2, this.v3, fixTheta);
        if (!Util.isFinite(c.theta)) {
            c.theta = 0.0;
        }
    }

    void setTorsionVariables(Calculation c) {
        if (this.gradients) {
            this.setCoords(c, 4);
            c.theta = Util.restorativeForceAndTorsionAngleRadians(this.da, this.db, this.dc, this.dd);
            if (!Util.isFinite(c.theta)) {
                c.theta = 1.7453292519943296E-5;
            }
        } else {
            c.theta = Util.getTorsionAngleRadians(this.minAtoms[c.ia].coord, this.minAtoms[c.ib].coord, this.minAtoms[c.ic].coord, this.minAtoms[c.id].coord, this.v1, this.v2, this.v3);
        }
    }

    void setCoords(Calculation c, int n) {
        switch (n) {
            case 4: {
                this.da.setA(this.minAtoms[c.ia].coord);
            }
            case 3: {
                this.db.setA(this.minAtoms[c.ib].coord);
            }
            case 2: {
                this.dc.setA(this.minAtoms[c.ic].coord);
            }
            case 1: {
                this.dd.setA(this.minAtoms[c.id].coord);
            }
        }
    }

    void addForces(Calculation c, int n) {
        switch (n) {
            case 4: {
                this.addForce(this.dd, c.id, c.dE);
            }
            case 3: {
                this.addForce(this.dc, c.ic, c.dE);
            }
            case 2: {
                this.addForce(this.db, c.ib, c.dE);
            }
            case 1: {
                this.addForce(this.da, c.ia, c.dE);
            }
        }
    }

    boolean isLinear(int i) {
        return false;
    }
}

