/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.NotNullDeserializeBinding;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import com.intellij.util.xmlb.XmlSerializerImpl;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class XmlSerializer {
    private static final SerializationFilter TRUE_FILTER = new SerializationFilter(){};

    private XmlSerializer() {
    }

    @NotNull
    public static <T> T deserialize(@NotNull Element element, @NotNull Class<T> aClass2) throws XmlSerializationException {
        Object object;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/XmlSerializer", "deserialize"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/xmlb/XmlSerializer", "deserialize"));
        }
        try {
            NotNullDeserializeBinding binding = (NotNullDeserializeBinding)XmlSerializerImpl.serializer.getClassBinding(aClass2);
            object = binding.deserialize(null, element);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException("Cannot deserialize class " + aClass2.getName(), e);
        }
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xmlb/XmlSerializer", "deserialize"));
        }
        return (T)object;
    }

    public static void deserializeInto(@NotNull Object bean, @NotNull Element element) {
        if (bean == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bean", "com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/XmlSerializer", "deserializeInto"));
        }
        try {
            Class<?> clazz = bean.getClass();
            ((BeanBinding)XmlSerializerImpl.serializer.getClassBinding(clazz)).deserializeInto(bean, element);
        }
        catch (XmlSerializationException e) {
            throw e;
        }
        catch (Exception e) {
            throw new XmlSerializationException(e);
        }
    }
}

