/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.symbols.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrClassSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrConstructorSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrSimpleFunctionSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrValueParameterSymbolImpl;
import org.jetbrains.kotlin.ir.symbols.impl.IrVariableSymbolImpl;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0006\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\t\u00a8\u0006\n"}, d2={"createClassSymbolOrNull", "Lorg/jetbrains/kotlin/ir/symbols/impl/IrClassSymbolImpl;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "createFunctionSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "createValueSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lorg/jetbrains/kotlin/descriptors/ValueDescriptor;", "ir.tree"})
public final class IrSymbolBaseKt {
    @Nullable
    public static final IrClassSymbolImpl createClassSymbolOrNull(@Nullable ClassDescriptor descriptor2) {
        IrClassSymbolImpl irClassSymbolImpl;
        ClassDescriptor classDescriptor = descriptor2;
        if (classDescriptor != null) {
            ClassDescriptor classDescriptor2;
            ClassDescriptor it = classDescriptor2 = classDescriptor;
            irClassSymbolImpl = new IrClassSymbolImpl(it);
        } else {
            irClassSymbolImpl = null;
        }
        return irClassSymbolImpl;
    }

    @NotNull
    public static final IrValueSymbol createValueSymbol(@NotNull ValueDescriptor descriptor2) {
        IrValueSymbol irValueSymbol;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        ValueDescriptor valueDescriptor = descriptor2;
        if (valueDescriptor instanceof ParameterDescriptor) {
            irValueSymbol = new IrValueParameterSymbolImpl((ParameterDescriptor)descriptor2);
        } else if (valueDescriptor instanceof VariableDescriptor) {
            irValueSymbol = new IrVariableSymbolImpl((VariableDescriptor)descriptor2);
        } else {
            throw (Throwable)new IllegalArgumentException("Unexpected descriptor kind: " + descriptor2);
        }
        return irValueSymbol;
    }

    @NotNull
    public static final IrFunctionSymbol createFunctionSymbol(@NotNull CallableMemberDescriptor descriptor2) {
        IrFunctionSymbol irFunctionSymbol;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        CallableMemberDescriptor callableMemberDescriptor = descriptor2;
        if (callableMemberDescriptor instanceof ClassConstructorDescriptor) {
            irFunctionSymbol = new IrConstructorSymbolImpl(((ClassConstructorDescriptor)descriptor2).getOriginal());
        } else if (callableMemberDescriptor instanceof FunctionDescriptor) {
            FunctionDescriptor functionDescriptor = ((FunctionDescriptor)descriptor2).getOriginal();
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "descriptor.original");
            irFunctionSymbol = new IrSimpleFunctionSymbolImpl(functionDescriptor);
        } else {
            throw (Throwable)new IllegalArgumentException("Unexpected descriptor kind: " + descriptor2);
        }
        return irFunctionSymbol;
    }
}

