/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibility;
import org.jetbrains.kotlin.descriptors.EffectiveVisibilityKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0017\u001a\u00020\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J,\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002J(\u0010&\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020%H\u0002J \u0010*\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020!2\u0006\u0010,\u001a\u00020%H\u0002J \u0010-\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020%H\u0002J \u0010.\u001a\u00020\u00182\u0006\u0010/\u001a\u0002002\u0006\u0010$\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J \u00101\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020\u0007H\u0002J(\u00102\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\tH\u0002J \u00106\u001a\u00020\u00182\u0006\u00107\u001a\u00020!2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\"\u00108\u001a\u0004\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020%2\u0006\u00109\u001a\u00020\u000eH\u0002J\u0010\u0010:\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020<H\u0002J\u0010\u0010=\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010>\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006?"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/InlineChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)V", "inlinableKtParameters", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "inlinableParameters", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "kotlin.jvm.PlatformType", "inlineFunEffectiveVisibility", "Lorg/jetbrains/kotlin/descriptors/EffectiveVisibility;", "isEffectivelyPrivateApiFunction", "", "<set-?>", "supportDefaultValueInline", "getSupportDefaultValueInline", "()Z", "setSupportDefaultValueInline", "(Z)V", "supportDefaultValueInline$delegate", "Lkotlin/properties/ReadWriteProperty;", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCallWithReceiver", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "receiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "checkLambdaInvokeOrExtensionCall", "lambdaDescriptor", "callDescriptor", "receiverExpression", "checkNonLocalReturn", "inlinableParameterDescriptor", "parameterUsage", "checkNotInDefaultParameter", "checkPrivateClassMemberAccess", "declarationDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkRecursion", "checkValueParameter", "targetArgument", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "targetParameterDescriptor", "checkVisibilityAndAccess", "calledDescriptor", "getCalleeDescriptor", "unwrapVariableAsFunction", "isDefinedInInlineFunction", "startDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "isInsideCall", "isInvokeOrInlineExtension", "frontend"})
public final class InlineChecker
implements CallChecker {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final EffectiveVisibility inlineFunEffectiveVisibility;
    private final boolean isEffectivelyPrivateApiFunction;
    private final List<ValueParameterDescriptor> inlinableParameters;
    private final List<KtElement> inlinableKtParameters;
    private final ReadWriteProperty supportDefaultValueInline$delegate;
    private final FunctionDescriptor descriptor;

    static {
        $$delegatedProperties = new KProperty[]{Reflection.mutableProperty1(new MutablePropertyReference1Impl(Reflection.getOrCreateKotlinClass(InlineChecker.class), "supportDefaultValueInline", "getSupportDefaultValueInline()Z"))};
    }

    private final boolean getSupportDefaultValueInline() {
        return (Boolean)this.supportDefaultValueInline$delegate.getValue(this, $$delegatedProperties[0]);
    }

    private final void setSupportDefaultValueInline(boolean bl) {
        this.supportDefaultValueInline$delegate.setValue(this, $$delegatedProperties[0], bl);
    }

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Object targetDescriptor;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, "resolvedCall");
        Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
        Intrinsics.checkParameterIsNotNull(context, "context");
        Call call2 = resolvedCall2.getCall();
        Intrinsics.checkExpressionValueIsNotNull(call2, "resolvedCall.call");
        KtExpression ktExpression = call2.getCalleeExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression expression2 = ktExpression;
        this.setSupportDefaultValueInline(context.getLanguageVersionSettings().supportsFeature(LanguageFeature.InlineDefaultFunctionalParameters));
        Object obj = targetDescriptor = resolvedCall2.getResultingDescriptor();
        Intrinsics.checkExpressionValueIsNotNull(obj, "targetDescriptor");
        if (PsiContractsUtilsKt.isFromContractDsl((DeclarationDescriptor)obj)) {
            return;
        }
        this.checkCallWithReceiver(context, (CallableDescriptor)targetDescriptor, resolvedCall2.getDispatchReceiver(), expression2);
        this.checkCallWithReceiver(context, (CallableDescriptor)targetDescriptor, resolvedCall2.getExtensionReceiver(), expression2);
        if (CollectionsKt.contains((Iterable)this.inlinableParameters, targetDescriptor)) {
            KtExpression ktExpression2 = expression2;
            Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "expression");
            if (this.checkNotInDefaultParameter(context, (CallableDescriptor)targetDescriptor, ktExpression2) && !this.isInsideCall(expression2)) {
                context.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on((KtElement)((PsiElement)expression2), expression2, this.descriptor));
            }
        }
        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = resolvedCall2.getValueArguments();
        Intrinsics.checkExpressionValueIsNotNull(map2, "resolvedCall.valueArguments");
        Map<ValueParameterDescriptor, ResolvedValueArgument> map3 = map2;
        Iterator<Map.Entry<ValueParameterDescriptor, ResolvedValueArgument>> iterator2 = map3.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry;
            Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry2 = entry = iterator2.next();
            ValueParameterDescriptor valueDescriptor = entry2.getKey();
            entry2 = entry;
            ResolvedValueArgument value = entry2.getValue();
            if (value instanceof DefaultValueArgument) continue;
            ResolvedValueArgument resolvedValueArgument = value;
            Intrinsics.checkExpressionValueIsNotNull(resolvedValueArgument, "value");
            Iterator<ValueArgument> iterator3 = resolvedValueArgument.getArguments().iterator();
            while (iterator3.hasNext()) {
                ValueArgument argument;
                ValueArgument valueArgument = argument = iterator3.next();
                Intrinsics.checkExpressionValueIsNotNull(valueArgument, "argument");
                ValueParameterDescriptor valueParameterDescriptor = valueDescriptor;
                Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "valueDescriptor");
                this.checkValueParameter(context, (CallableDescriptor)targetDescriptor, valueArgument, valueParameterDescriptor);
            }
        }
        KtExpression ktExpression3 = expression2;
        Intrinsics.checkExpressionValueIsNotNull(ktExpression3, "expression");
        this.checkVisibilityAndAccess((CallableDescriptor)targetDescriptor, ktExpression3, context);
        this.checkRecursion(context, (CallableDescriptor)targetDescriptor, expression2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkNotInDefaultParameter(CallCheckerContext context, CallableDescriptor targetDescriptor, KtExpression expression2) {
        boolean allow;
        void $receiver$iv;
        if (!this.getSupportDefaultValueInline()) return true;
        PsiElement psiElement = expression2;
        boolean strict$iv = true;
        KtParameter ktParameter = PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtParameter.class, strict$iv);
        if (ktParameter == null) return true;
        psiElement = ktParameter;
        PsiElement it = psiElement;
        if (!this.inlinableKtParameters.contains(it)) {
            return true;
        }
        boolean bl = allow = false;
        if (!allow) {
            context.getTrace().report(Errors.NOT_SUPPORTED_INLINE_PARAMETER_IN_INLINE_PARAMETER_DEFAULT_VALUE.on((KtElement)((PsiElement)expression2), expression2, this.descriptor));
        }
        boolean bl2 = allow;
        if (!bl2) return false;
        return true;
    }

    private final boolean isInsideCall(KtExpression expression2) {
        KtToken token;
        KtExpression parent2 = KtPsiUtil.getParentCallIfPresent(expression2);
        if (parent2 instanceof KtBinaryExpression && ((token = KtPsiUtil.getOperationToken((KtOperationExpression)parent2)) == KtTokens.EQ || token == KtTokens.ANDAND || token == KtTokens.OROR)) {
            return false;
        }
        if (parent2 != null) {
            PsiElement current = expression2;
            while (current != parent2) {
                if (current instanceof KtBinaryExpressionWithTypeRHS) {
                    return false;
                }
                Intrinsics.checkExpressionValueIsNotNull(current.getParent(), "current.parent");
            }
        }
        return parent2 != null;
    }

    private final void checkValueParameter(CallCheckerContext context, CallableDescriptor targetDescriptor, ValueArgument targetArgument, ValueParameterDescriptor targetParameterDescriptor) {
        KtExpression ktExpression = targetArgument.getArgumentExpression();
        if (ktExpression == null) {
            return;
        }
        KtExpression argumentExpression = ktExpression;
        CallableDescriptor argumentCallee = this.getCalleeDescriptor(context, argumentExpression, false);
        if (argumentCallee != null && CollectionsKt.contains((Iterable)this.inlinableParameters, argumentCallee) && this.checkNotInDefaultParameter(context, argumentCallee, argumentExpression)) {
            if (InlineUtil.isInline(targetDescriptor) && InlineUtil.isInlineParameter(targetParameterDescriptor)) {
                if (InlineUtil.allowsNonLocalReturns(argumentCallee) && !InlineUtil.allowsNonLocalReturns(targetParameterDescriptor)) {
                    context.getTrace().report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on((KtElement)((PsiElement)argumentExpression), argumentExpression));
                } else {
                    this.checkNonLocalReturn(context, argumentCallee, argumentExpression);
                }
            } else {
                context.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on((KtElement)((PsiElement)argumentExpression), argumentExpression, this.descriptor));
            }
        }
    }

    private final void checkCallWithReceiver(CallCheckerContext context, CallableDescriptor targetDescriptor, ReceiverValue receiver, KtExpression expression2) {
        CallableDescriptor varDescriptor;
        KtExpression receiverExpression;
        if (receiver == null) {
            return;
        }
        ReceiverValue receiverValue = receiver;
        if (receiverValue instanceof ExpressionReceiver) {
            receiverExpression = ((ExpressionReceiver)receiver).getExpression();
            varDescriptor = this.getCalleeDescriptor(context, receiverExpression, true);
        } else if (receiverValue instanceof ExtensionReceiver) {
            boolean bl;
            CallableDescriptor extension;
            CallableDescriptor callableDescriptor = extension = ((ExtensionReceiver)receiver).getDeclarationDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(callableDescriptor, "extension");
            varDescriptor = callableDescriptor.getExtensionReceiverParameter();
            boolean bl2 = bl = varDescriptor != null;
            if (_Assertions.ENABLED && !bl) {
                String string = "Extension should have receiverParameterDescriptor: " + extension;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            receiverExpression = expression2;
        } else {
            varDescriptor = null;
            receiverExpression = null;
        }
        if (CollectionsKt.contains((Iterable)this.inlinableParameters, varDescriptor)) {
            CallableDescriptor callableDescriptor = varDescriptor;
            if (callableDescriptor == null) {
                Intrinsics.throwNpe();
            }
            KtExpression ktExpression = receiverExpression;
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            this.checkLambdaInvokeOrExtensionCall(context, callableDescriptor, targetDescriptor, ktExpression);
        }
    }

    private final CallableDescriptor getCalleeDescriptor(CallCheckerContext context, KtExpression expression2, boolean unwrapVariableAsFunction) {
        if (!(expression2 instanceof KtSimpleNameExpression) && !(expression2 instanceof KtThisExpression)) {
            return null;
        }
        KtElement ktElement = expression2;
        BindingContext bindingContext = context.getTrace().getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> thisCall = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (unwrapVariableAsFunction && thisCall instanceof VariableAsFunctionResolvedCall) {
            return ((VariableAsFunctionResolvedCall)((Object)thisCall)).getVariableCall().getResultingDescriptor();
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = thisCall;
        return resolvedCall2 != null ? resolvedCall2.getResultingDescriptor() : null;
    }

    private final void checkLambdaInvokeOrExtensionCall(CallCheckerContext context, CallableDescriptor lambdaDescriptor, CallableDescriptor callDescriptor, KtExpression receiverExpression) {
        boolean inlinableCall = this.isInvokeOrInlineExtension(callDescriptor);
        if (!inlinableCall) {
            context.getTrace().report(Errors.USAGE_IS_NOT_INLINABLE.on((KtElement)((PsiElement)receiverExpression), receiverExpression, this.descriptor));
        } else {
            this.checkNonLocalReturn(context, lambdaDescriptor, receiverExpression);
        }
    }

    private final void checkRecursion(CallCheckerContext context, CallableDescriptor targetDescriptor, KtElement expression2) {
        if (targetDescriptor.getOriginal() == this.descriptor) {
            context.getTrace().report(Errors.RECURSION_IN_INLINE.on((KtElement)((PsiElement)expression2), expression2, this.descriptor));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInvokeOrInlineExtension(CallableDescriptor descriptor2) {
        if (!(descriptor2 instanceof SimpleFunctionDescriptor)) {
            return false;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (Intrinsics.areEqual(descriptor2.getName(), OperatorNameConventions.INVOKE) && containingDeclaration instanceof ClassDescriptor) {
            SimpleType simpleType2 = ((ClassDescriptor)containingDeclaration).getDefaultType();
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "containingDeclaration.defaultType");
            if (FunctionTypesKt.isFunctionType(simpleType2)) {
                return true;
            }
        }
        boolean bl = false;
        boolean isInvoke = bl;
        if (isInvoke) return true;
        if (!InlineUtil.isInline(descriptor2)) return false;
        return true;
    }

    private final void checkVisibilityAndAccess(CallableDescriptor calledDescriptor, KtElement expression2, CallCheckerContext context) {
        EffectiveVisibility effectiveVisibility;
        if (this.isDefinedInInlineFunction(calledDescriptor)) {
            effectiveVisibility = EffectiveVisibility.Public.INSTANCE;
        } else {
            DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = calledDescriptor;
            Visibility visibility = calledDescriptor.getVisibility();
            Intrinsics.checkExpressionValueIsNotNull(visibility, "calledDescriptor.visibility");
            effectiveVisibility = EffectiveVisibilityKt.effectiveVisibility(declarationDescriptorWithVisibility, visibility, true);
        }
        EffectiveVisibility calledFunEffectiveVisibility = effectiveVisibility;
        boolean isCalledFunPublicOrPublishedApi = calledFunEffectiveVisibility.getPublicApi();
        boolean isInlineFunPublicOrPublishedApi = this.inlineFunEffectiveVisibility.getPublicApi();
        if (isInlineFunPublicOrPublishedApi && !isCalledFunPublicOrPublishedApi && calledDescriptor.getVisibility() != Visibilities.LOCAL) {
            context.getTrace().report(Errors.NON_PUBLIC_CALL_FROM_PUBLIC_INLINE.on((KtElement)((PsiElement)expression2), calledDescriptor, this.descriptor));
        } else {
            this.checkPrivateClassMemberAccess(calledDescriptor, expression2, context);
        }
        if (!(calledDescriptor instanceof ConstructorDescriptor) && isInlineFunPublicOrPublishedApi && this.inlineFunEffectiveVisibility.toVisibility() != Visibilities.PROTECTED && calledFunEffectiveVisibility.toVisibility() == Visibilities.PROTECTED) {
            context.getTrace().report(Errors.PROTECTED_CALL_FROM_PUBLIC_INLINE.on(expression2, calledDescriptor));
        }
    }

    private final void checkPrivateClassMemberAccess(DeclarationDescriptor declarationDescriptor, KtElement expression2, CallCheckerContext context) {
        if (!this.isEffectivelyPrivateApiFunction && DescriptorUtilsKt.isInsidePrivateClass(declarationDescriptor)) {
            context.getTrace().report(Errors.PRIVATE_CLASS_MEMBER_FROM_INLINE.on((KtElement)((PsiElement)expression2), declarationDescriptor, this.descriptor));
        }
    }

    private final boolean isDefinedInInlineFunction(DeclarationDescriptorWithVisibility startDescriptor) {
        DeclarationDescriptorWithVisibility parent2 = startDescriptor;
        while (parent2 != null) {
            if (parent2.getContainingDeclaration() == this.descriptor) {
                return true;
            }
            parent2 = DescriptorUtils.getParentOfType(parent2, DeclarationDescriptorWithVisibility.class);
        }
        return false;
    }

    private final void checkNonLocalReturn(CallCheckerContext context, CallableDescriptor inlinableParameterDescriptor, KtExpression parameterUsage) {
        if (!InlineUtil.allowsNonLocalReturns(inlinableParameterDescriptor)) {
            return;
        }
        if (!InlineUtil.checkNonLocalReturnUsage(this.descriptor, parameterUsage, context.getResolutionContext())) {
            context.getTrace().report(Errors.NON_LOCAL_RETURN_NOT_ALLOWED.on((KtElement)((PsiElement)parameterUsage), parameterUsage));
        }
    }

    public InlineChecker(@NotNull FunctionDescriptor descriptor2) {
        List list2;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        this.descriptor = descriptor2;
        boolean bl = InlineUtil.isInline(this.descriptor);
        if (_Assertions.ENABLED && !bl) {
            String string = "This extension should be created only for inline functions: " + this.descriptor;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = this.descriptor;
        Visibility visibility = this.descriptor.getVisibility();
        Intrinsics.checkExpressionValueIsNotNull(visibility, "descriptor.visibility");
        this.inlineFunEffectiveVisibility = EffectiveVisibilityKt.effectiveVisibility(declarationDescriptorWithVisibility, visibility, true);
        this.isEffectivelyPrivateApiFunction = DescriptorUtilsKt.isEffectivelyPrivateApi(this.descriptor);
        List<ValueParameterDescriptor> list3 = this.descriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list3, "descriptor.valueParameters");
        Iterable iterable = list3;
        InlineChecker inlineChecker = this;
        void $i$a$1$assert = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            if (!InlineUtil.isInlineParameter(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        inlineChecker.inlinableParameters = list2 = (List)destination$iv$iv;
        $receiver$iv = this.inlinableParameters;
        inlineChecker = this;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
        Iterator iterator2 = $receiver$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            KtElement ktElement;
            ValueParameterDescriptor it;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            ValueParameterDescriptor valueParameterDescriptor = it = (ValueParameterDescriptor)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull(valueParameterDescriptor, "it");
            SourceElement sourceElement = valueParameterDescriptor.getSource();
            if (!(sourceElement instanceof KotlinSourceElement)) {
                sourceElement = null;
            }
            KotlinSourceElement kotlinSourceElement = (KotlinSourceElement)sourceElement;
            KtElement ktElement2 = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
            if (ktElement2 == null) continue;
            KtElement it$iv$iv = ktElement = ktElement2;
            destination$iv$iv.add(it$iv$iv);
        }
        inlineChecker.inlinableKtParameters = list2 = (List)destination$iv$iv;
        this.supportDefaultValueInline$delegate = Delegates.INSTANCE.notNull();
    }
}

