/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Processor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.utils.JsLibrary;
import org.jetbrains.kotlin.utils.LibraryUtils;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u000e\u001a\u00020\b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u000b\u001a\u00020\u00062\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J \u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0018\u001a\u00020\u0006H\u0002J$\u0010\u0019\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u001bH\u0002J$\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\n2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u001bH\u0002J$\u0010\u001d\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u001bH\u0002J*\u0010\u001e\u001a\u00020\b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u001bH\u0007J$\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\n2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u001bH\u0007J\u000e\u0010\"\u001a\u0004\u0018\u00010\u0006*\u00020\nH\u0002J\f\u0010#\u001a\u00020\n*\u00020\nH\u0002J(\u0010$\u001a\u00020\b*\u00020\n2\u0006\u0010%\u001a\u00020\u00062\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u001bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/utils/JsLibraryUtils;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "META_INF_RESOURCES", "", "copyJsFilesFromDirectory", "", "dir", "Ljava/io/File;", "outputLibraryJsPath", "copySourceMap", "", "copyJsFilesFromLibraries", "libraries", "", "copyJsFilesFromZip", "file", "copyLibrary", "outputPath", "library", "Lorg/jetbrains/kotlin/utils/JsLibrary;", "getSuggestedPath", "path", "processDirectory", "action", "Lkotlin/Function1;", "traverseArchive", "traverseDirectory", "traverseJsLibraries", "libs", "traverseJsLibrary", "lib", "contentIfExists", "correspondingSourceMapFile", "runIfFileExists", "relativePath", "util"})
public final class JsLibraryUtils {
    private static final Logger LOG;
    private static final String META_INF_RESOURCES = "META-INF/resources/";
    public static final JsLibraryUtils INSTANCE;

    @JvmStatic
    public static final void copyJsFilesFromLibraries(@NotNull List<String> libraries, @NotNull String outputLibraryJsPath, boolean copySourceMap) {
        Intrinsics.checkParameterIsNotNull(libraries, "libraries");
        Intrinsics.checkParameterIsNotNull(outputLibraryJsPath, "outputLibraryJsPath");
        for (String library : libraries) {
            File file2 = new File(library);
            boolean bl = file2.exists();
            if (_Assertions.ENABLED && !bl) {
                String string = "Library " + library + " not found";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (file2.isDirectory()) {
                INSTANCE.copyJsFilesFromDirectory(file2, outputLibraryJsPath, copySourceMap);
                continue;
            }
            INSTANCE.copyJsFilesFromZip(file2, outputLibraryJsPath, copySourceMap);
        }
    }

    @JvmStatic
    public static /* bridge */ /* synthetic */ void copyJsFilesFromLibraries$default(List list2, String string, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        JsLibraryUtils.copyJsFilesFromLibraries(list2, string, bl);
    }

    @JvmStatic
    public static final void traverseJsLibraries(@NotNull List<? extends File> libs, @NotNull Function1<? super JsLibrary, Unit> action) {
        Intrinsics.checkParameterIsNotNull(libs, "libs");
        Intrinsics.checkParameterIsNotNull(action, "action");
        Iterable $receiver$iv = libs;
        for (Object element$iv : $receiver$iv) {
            File it = (File)element$iv;
            JsLibraryUtils.traverseJsLibrary(it, action);
        }
    }

    @JvmStatic
    public static final void traverseJsLibrary(@NotNull File lib, @NotNull Function1<? super JsLibrary, Unit> action) {
        block2: {
            File jsFile;
            block3: {
                block1: {
                    Intrinsics.checkParameterIsNotNull(lib, "lib");
                    Intrinsics.checkParameterIsNotNull(action, "action");
                    if (!lib.isDirectory()) break block1;
                    INSTANCE.traverseDirectory(lib, action);
                    break block2;
                }
                if (!FileUtil.isJarOrZip(lib)) break block3;
                INSTANCE.traverseArchive(lib, action);
                break block2;
            }
            String string = lib.getName();
            Intrinsics.checkExpressionValueIsNotNull(string, "lib.name");
            if (!StringsKt.endsWith$default(string, ".js", false, 2, null)) break block2;
            String string2 = lib.getPath();
            Intrinsics.checkExpressionValueIsNotNull(string2, "lib.path");
            INSTANCE.runIfFileExists(lib, string2, action);
            File file2 = jsFile = FileUtilsKt.withReplacedExtensionOrNull(lib, ".meta.js", ".js");
            if (file2 != null) {
                String string3 = jsFile.getPath();
                Intrinsics.checkExpressionValueIsNotNull(string3, "jsFile.path");
                INSTANCE.runIfFileExists(file2, string3, action);
            }
        }
    }

    private final void runIfFileExists(@NotNull File $receiver, String relativePath, Function1<? super JsLibrary, Unit> action) {
        if ($receiver.isFile()) {
            action.invoke(new JsLibrary(FilesKt.readText$default($receiver, null, 1, null), relativePath, this.contentIfExists(this.correspondingSourceMapFile($receiver)), $receiver));
        }
    }

    private final void copyJsFilesFromDirectory(File dir, String outputLibraryJsPath, boolean copySourceMap) {
        this.traverseDirectory(dir, (Function1<? super JsLibrary, Unit>)new Function1<JsLibrary, Unit>(outputLibraryJsPath, copySourceMap){
            final /* synthetic */ String $outputLibraryJsPath;
            final /* synthetic */ boolean $copySourceMap;

            public final void invoke(@NotNull JsLibrary it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                JsLibraryUtils.access$copyLibrary(JsLibraryUtils.INSTANCE, this.$outputLibraryJsPath, it, this.$copySourceMap);
            }
            {
                this.$outputLibraryJsPath = string;
                this.$copySourceMap = bl;
                super(1);
            }
        });
    }

    private final String contentIfExists(@NotNull File $receiver) {
        return $receiver.exists() ? FilesKt.readText$default($receiver, null, 1, null) : null;
    }

    private final File correspondingSourceMapFile(@NotNull File $receiver) {
        return new File($receiver.getParentFile(), $receiver.getName() + ".map");
    }

    private final void processDirectory(File dir, Function1<? super JsLibrary, Unit> action) {
        FileUtil.processFilesRecursively(dir, new Processor<File>(dir, action){
            final /* synthetic */ File $dir;
            final /* synthetic */ Function1 $action;

            public final boolean process(File file2) {
                String relativePath;
                String string = FileUtil.getRelativePath(this.$dir, file2);
                if (string == null) {
                    throw (Throwable)new IllegalArgumentException("relativePath should not be null " + this.$dir + ' ' + file2);
                }
                String string2 = relativePath = string;
                Intrinsics.checkExpressionValueIsNotNull(string2, "relativePath");
                if (StringsKt.endsWith$default(string2, ".js", false, 2, null)) {
                    String string3 = JsLibraryUtils.access$getSuggestedPath(JsLibraryUtils.INSTANCE, relativePath);
                    if (string3 == null) {
                        return true;
                    }
                    String suggestedRelativePath = string3;
                    File file3 = file2;
                    Intrinsics.checkExpressionValueIsNotNull(file3, "file");
                    JsLibraryUtils.access$runIfFileExists(JsLibraryUtils.INSTANCE, file3, suggestedRelativePath, this.$action);
                }
                return true;
            }
            {
                this.$dir = file2;
                this.$action = function1;
            }
        });
    }

    private final void traverseDirectory(File dir, Function1<? super JsLibrary, Unit> action) {
        try {
            this.processDirectory(dir, action);
        }
        catch (IOException ex) {
            LOG.error("Could not read files from directory " + dir.getName() + ": " + ex.getMessage());
        }
    }

    private final void copyJsFilesFromZip(File file2, String outputLibraryJsPath, boolean copySourceMap) {
        this.traverseArchive(file2, (Function1<? super JsLibrary, Unit>)new Function1<JsLibrary, Unit>(outputLibraryJsPath, copySourceMap){
            final /* synthetic */ String $outputLibraryJsPath;
            final /* synthetic */ boolean $copySourceMap;

            public final void invoke(@NotNull JsLibrary it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                JsLibraryUtils.access$copyLibrary(JsLibraryUtils.INSTANCE, this.$outputLibraryJsPath, it, this.$copySourceMap);
            }
            {
                this.$outputLibraryJsPath = string;
                this.$copySourceMap = bl;
                super(1);
            }
        });
    }

    private final void copyLibrary(String outputPath, JsLibrary library, boolean copySourceMap) {
        block1: {
            File targetFile = new File(outputPath, library.getPath());
            targetFile.getParentFile().mkdirs();
            FilesKt.writeText$default(targetFile, library.getContent(), null, 2, null);
            if (!copySourceMap) break block1;
            String string = library.getSourceMapContent();
            if (string != null) {
                String string2;
                String it = string2 = string;
                FilesKt.writeText$default(new File(targetFile.getParent(), targetFile.getName() + ".map"), it, null, 2, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void traverseArchive(File file2, Function1<? super JsLibrary, Unit> action) {
        ZipFile zipFile2 = new ZipFile(file2.getPath());
        try {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Object object;
            String entryName;
            Object entry;
            Enumeration<? extends ZipEntry> zipEntries = zipFile2.entries();
            List librariesWithoutSourceMaps = new ArrayList();
            Map possibleMapFiles = new LinkedHashMap();
            while (zipEntries.hasMoreElements()) {
                Object content;
                Object stream2;
                Object object2 = entry = zipEntries.nextElement();
                Intrinsics.checkExpressionValueIsNotNull(object2, "entry");
                entryName = ((ZipEntry)object2).getName();
                if (((ZipEntry)entry).isDirectory()) continue;
                String string = entryName;
                Intrinsics.checkExpressionValueIsNotNull(string, "entryName");
                if (StringsKt.endsWith$default(string, ".js", false, 2, null)) {
                    String relativePath;
                    if (this.getSuggestedPath(entryName) == null) {
                        continue;
                    }
                    stream2 = zipFile2.getInputStream((ZipEntry)entry);
                    content = FileUtil.loadTextAndClose((InputStream)stream2);
                    object = librariesWithoutSourceMaps;
                    String string2 = content;
                    Intrinsics.checkExpressionValueIsNotNull(string2, "content");
                    JsLibrary jsLibrary = new JsLibrary(string2, relativePath, null, null);
                    object.add(jsLibrary);
                    continue;
                }
                if (!StringsKt.endsWith$default(entryName, ".js.map", false, 2, null)) continue;
                String correspondingJsPath = StringsKt.removeSuffix(entryName, (CharSequence)".js.map") + ".js";
                stream2 = possibleMapFiles;
                content = entry;
                stream2.put(correspondingJsPath, content);
            }
            entry = librariesWithoutSourceMaps;
            entryName = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                JsLibrary jsLibrary;
                void it;
                object = (JsLibrary)item$iv$iv;
                Collection collection = destination$iv$iv;
                ZipEntry zipEntry = (ZipEntry)possibleMapFiles.get(it.getPath());
                if (zipEntry != null) {
                    InputStream stream3 = zipFile2.getInputStream(zipEntry);
                    String content = FileUtil.loadTextAndClose(stream3);
                    jsLibrary = JsLibrary.copy$default((JsLibrary)it, null, null, content, null, 11, null);
                } else {
                    jsLibrary = it;
                }
                void var20_19 = jsLibrary;
                collection.add(var20_19);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                action.invoke((JsLibrary)element$iv);
            }
        }
        catch (IOException ex) {
            LOG.error("Could not extract files from archive " + file2.getName() + ": " + ex.getMessage());
        }
        finally {
            zipFile2.close();
        }
    }

    private final String getSuggestedPath(String path2) {
        String systemIndependentPath;
        String string = systemIndependentPath = FileUtil.toSystemIndependentName(path2);
        Intrinsics.checkExpressionValueIsNotNull(string, "systemIndependentPath");
        if (StringsKt.startsWith$default(string, LibraryUtils.INSTANCE.getMETA_INF(), false, 2, null)) {
            if (StringsKt.startsWith$default(systemIndependentPath, META_INF_RESOURCES, false, 2, null)) {
                String string2 = path2;
                int n = META_INF_RESOURCES.length();
                String string3 = string2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n);
                Intrinsics.checkExpressionValueIsNotNull(string4, "(this as java.lang.String).substring(startIndex)");
                return string4;
            }
            return null;
        }
        return path2;
    }

    private JsLibraryUtils() {
    }

    static {
        JsLibraryUtils jsLibraryUtils;
        INSTANCE = jsLibraryUtils = new JsLibraryUtils();
        LOG = Logger.getInstance(LibraryUtils.class);
        META_INF_RESOURCES = "" + LibraryUtils.INSTANCE.getMETA_INF() + "resources/";
    }

    public static final /* synthetic */ void access$copyLibrary(JsLibraryUtils $this, @NotNull String outputPath, @NotNull JsLibrary library, boolean copySourceMap) {
        $this.copyLibrary(outputPath, library, copySourceMap);
    }

    @Nullable
    public static final /* synthetic */ String access$getSuggestedPath(JsLibraryUtils $this, @NotNull String path2) {
        return $this.getSuggestedPath(path2);
    }

    public static final /* synthetic */ void access$runIfFileExists(JsLibraryUtils $this, @NotNull File $receiver, @NotNull String relativePath, @NotNull Function1 action) {
        $this.runIfFileExists($receiver, relativePath, action);
    }
}

