/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.io.IOException;
import java.io.PrintWriter;
import org.directwebremoting.dwrp.BaseScriptConduit;
import org.directwebremoting.extend.EnginePrivate;

public class HtmlScriptConduit
extends BaseScriptConduit {
    private final String batchId;
    private final String documentDomain;
    private boolean chunkOpen = false;

    public HtmlScriptConduit(PrintWriter out, String instanceId, String batchId, String documentDomain) {
        super(out, instanceId);
        this.batchId = batchId;
        this.documentDomain = documentDomain;
    }

    @Override
    public String getOutboundMimeType() {
        return "text/html";
    }

    @Override
    public void beginStreamAndChunk() {
        this.out.println("<html><body>");
        this.beginChunk(true);
        this.out.println(EnginePrivate.remoteBeginIFrameResponse(this.batchId, true));
    }

    @Override
    public void beginChunk() {
        this.beginChunk(false);
    }

    private void beginChunk(boolean setDocumentDomain) {
        if (!this.chunkOpen) {
            this.out.println("<script type=\"text/javascript\">");
            this.out.println(EnginePrivate.remoteBeginWrapper(this.instanceId, true, setDocumentDomain ? this.documentDomain : null));
            this.chunkOpen = true;
        }
    }

    @Override
    public void sendScript(String script) throws IOException {
        this.beginChunk(false);
        this.out.println(EnginePrivate.remoteExecute(script));
    }

    @Override
    public void endChunk() {
        if (this.chunkOpen) {
            this.out.println(EnginePrivate.remoteEndWrapper(this.instanceId, true));
            this.out.println("</script>");
            this.chunkOpen = false;
        }
    }

    @Override
    public void endStreamAndChunk() throws IOException {
        this.beginChunk();
        this.out.println(EnginePrivate.remoteEndIFrameResponse(this.batchId, true));
        this.endChunk();
        this.out.println("</body></html>");
    }
}

