/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model;

import com.google.common.collect.HashMultimap;
import java.util.ArrayList;
import java.util.List;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class ChangeListMinimizer {
    public List<OWLOntologyChange> getMinimisedChanges(List<? extends OWLOntologyChange> changes) {
        HashMultimap axiomsToAdd = HashMultimap.create();
        HashMultimap axiomsToRemove = HashMultimap.create();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (oWLOntologyChange.isAddAxiom()) {
                if (axiomsToRemove.get((Object)oWLOntologyChange.getOntology()).remove(oWLOntologyChange.getAxiom())) continue;
                axiomsToAdd.get((Object)oWLOntologyChange.getOntology()).add(oWLOntologyChange.getAxiom());
                continue;
            }
            if (!oWLOntologyChange.isRemoveAxiom() || axiomsToAdd.get((Object)oWLOntologyChange.getOntology()).remove(oWLOntologyChange.getAxiom())) continue;
            axiomsToRemove.get((Object)oWLOntologyChange.getOntology()).add(oWLOntologyChange.getAxiom());
        }
        ArrayList<OWLOntologyChange> minimisedChanges = new ArrayList<OWLOntologyChange>();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (oWLOntologyChange.isAddAxiom()) {
                if (!axiomsToAdd.get((Object)oWLOntologyChange.getOntology()).contains(oWLOntologyChange.getAxiom())) continue;
                minimisedChanges.add(oWLOntologyChange);
                axiomsToAdd.get((Object)oWLOntologyChange.getOntology()).remove(oWLOntologyChange.getAxiom());
                continue;
            }
            if (oWLOntologyChange.isRemoveAxiom()) {
                if (!axiomsToRemove.get((Object)oWLOntologyChange.getOntology()).contains(oWLOntologyChange.getAxiom())) continue;
                minimisedChanges.add(oWLOntologyChange);
                axiomsToRemove.get((Object)oWLOntologyChange.getOntology()).remove(oWLOntologyChange.getAxiom());
                continue;
            }
            minimisedChanges.add(oWLOntologyChange);
        }
        return minimisedChanges;
    }
}

