/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.trello;

import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.trello.TrelloIconBuilder;
import com.intellij.tasks.trello.model.TrelloCard;
import com.intellij.tasks.trello.model.TrelloCommentAction;
import java.util.Date;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrelloTask
extends Task {
    private static final TrelloIconBuilder ourIconBuilder = new TrelloIconBuilder(16);
    private TrelloCard myCard;
    private TaskRepository myRepository;

    public TrelloTask(TrelloCard card, TaskRepository repository) {
        this.myCard = card;
        this.myRepository = repository;
    }

    @NotNull
    public String getId() {
        String string = this.myCard.getId();
        if (string == null) {
            TrelloTask.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getSummary() {
        String string = this.myCard.getName();
        if (string == null) {
            TrelloTask.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getDescription() {
        return this.myCard.getDescription();
    }

    @NotNull
    public Comment[] getComments() {
        List<TrelloCommentAction> comments = this.myCard.getComments();
        Comment[] commentArray = comments.toArray(new Comment[comments.size()]);
        if (commentArray == null) {
            TrelloTask.$$$reportNull$$$0(2);
        }
        return commentArray;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = ourIconBuilder.buildIcon(this.myCard.getColors());
        if (icon == null) {
            TrelloTask.$$$reportNull$$$0(3);
        }
        return icon;
    }

    @NotNull
    public TaskType getType() {
        TaskType taskType = TaskType.OTHER;
        if (taskType == null) {
            TrelloTask.$$$reportNull$$$0(4);
        }
        return taskType;
    }

    @Nullable
    public Date getUpdated() {
        return this.myCard.getDateLastActivity();
    }

    @Nullable
    public Date getCreated() {
        return null;
    }

    public boolean isClosed() {
        return this.myCard.isClosed() || !this.myCard.isVisible();
    }

    public boolean isIssue() {
        return true;
    }

    @Nullable
    public String getIssueUrl() {
        return this.myCard.getUrl();
    }

    public String getPresentableName() {
        return this.myCard.getName();
    }

    @Nullable
    public TaskRepository getRepository() {
        return this.myRepository;
    }

    @NotNull
    public String getNumber() {
        String string = this.myCard.getIdShort();
        if (string == null) {
            TrelloTask.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/tasks/trello/TrelloTask";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummary";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComments";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumber";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

