/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.ipnb.editor.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.Project;
import java.awt.Toolkit;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.ipnb.configuration.IpnbConnectionManager;
import org.jetbrains.plugins.ipnb.editor.IpnbFileEditor;

public class IpnbInterruptKernelAction
extends AnAction {
    private final IpnbFileEditor myFileEditor;

    public IpnbInterruptKernelAction(IpnbFileEditor fileEditor) {
        super("Interrupt kernel", "Interrupt kernel", AllIcons.Actions.Suspend);
        this.myFileEditor = fileEditor;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(keyStroke), this.myFileEditor.getIpnbFilePanel());
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            IpnbInterruptKernelAction.$$$reportNull$$$0(0);
        }
        IpnbInterruptKernelAction.interruptKernel(this.myFileEditor);
    }

    private static void interruptKernel(@NotNull IpnbFileEditor editor) {
        if (editor == null) {
            IpnbInterruptKernelAction.$$$reportNull$$$0(1);
        }
        Project project = editor.getIpnbFilePanel().getProject();
        IpnbConnectionManager.getInstance(project).interruptKernel(editor.getVirtualFile().getPath());
    }

    public void update(AnActionEvent e) {
        Project project = this.myFileEditor.getIpnbFilePanel().getProject();
        boolean hasConnection = IpnbConnectionManager.getInstance(project).hasConnection(this.myFileEditor.getVirtualFile().getPath());
        e.getPresentation().setEnabled(hasConnection);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/ipnb/editor/actions/IpnbInterruptKernelAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "interruptKernel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

