/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.keywordSubstitution;

import com.intellij.cvsSupport2.config.CvsConfiguration;
import com.intellij.cvsSupport2.keywordSubstitution.KeywordSubstitutionWrapper;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ListWithSelection;

public class KeywordSubstitutionListWithSelection
extends ListWithSelection<KeywordSubstitutionWrapper> {
    public KeywordSubstitutionListWithSelection() {
        this.add(KeywordSubstitutionWrapper.KEYWORD_EXPANSION);
        this.add(KeywordSubstitutionWrapper.KEYWORD_EXPANSION_LOCKER);
        this.add(KeywordSubstitutionWrapper.KEYWORD_COMPRESSION);
        this.add(KeywordSubstitutionWrapper.NO_SUBSTITUTION);
        this.add(KeywordSubstitutionWrapper.BINARY);
        this.add(KeywordSubstitutionWrapper.KEYWORD_REPLACEMENT);
    }

    public static KeywordSubstitutionListWithSelection createOnFile(VirtualFile vFile, CvsConfiguration config) {
        KeywordSubstitutionListWithSelection result = new KeywordSubstitutionListWithSelection();
        if (vFile.getFileType().isBinary()) {
            result.select(KeywordSubstitutionWrapper.BINARY);
        } else {
            result.select(KeywordSubstitutionWrapper.getValue(config.DEFAULT_TEXT_FILE_SUBSTITUTION));
        }
        return result;
    }

    public static KeywordSubstitutionListWithSelection createOnExtension(String extension) {
        KeywordSubstitutionListWithSelection result = new KeywordSubstitutionListWithSelection();
        if (FileTypeManager.getInstance().getFileTypeByExtension(extension).isBinary()) {
            result.select(KeywordSubstitutionWrapper.BINARY);
        } else {
            result.select(KeywordSubstitutionWrapper.KEYWORD_EXPANSION);
        }
        return result;
    }
}

