/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.actions;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.PreferredProducerFind;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ConfigurationTypeUtil;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.junit.RuntimeConfigurationProducer;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.awt.Component;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationContext {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.actions.ConfigurationContext");
    private final Location<PsiElement> myLocation;
    private RunnerAndConfigurationSettings myConfiguration;
    private boolean myInitialized = false;
    private boolean myMultipleSelection = false;
    private Ref<RunnerAndConfigurationSettings> myExistingConfiguration;
    private final Module myModule;
    private final RunConfiguration myRuntimeConfiguration;
    private final Component myContextComponent;
    public static Key<ConfigurationContext> SHARED_CONTEXT = Key.create((String)"SHARED_CONTEXT");
    private List<RuntimeConfigurationProducer> myPreferredProducers;
    private List<ConfigurationFromContext> myConfigurationsFromContext;

    @NotNull
    public static ConfigurationContext getFromContext(DataContext dataContext) {
        ConfigurationContext context = new ConfigurationContext(dataContext);
        DataManager dataManager = DataManager.getInstance();
        ConfigurationContext sharedContext = dataManager.loadFromDataContext(dataContext, SHARED_CONTEXT);
        if (sharedContext == null || sharedContext.getLocation() == null || context.getLocation() == null || !Comparing.equal(sharedContext.getLocation().getPsiElement(), context.getLocation().getPsiElement())) {
            sharedContext = context;
            dataManager.saveInDataContext(dataContext, SHARED_CONTEXT, sharedContext);
        }
        ConfigurationContext configurationContext = sharedContext;
        if (configurationContext == null) {
            ConfigurationContext.$$$reportNull$$$0(0);
        }
        return configurationContext;
    }

    private ConfigurationContext(DataContext dataContext) {
        VirtualFile[] files;
        this.myRuntimeConfiguration = RunConfiguration.DATA_KEY.getData(dataContext);
        this.myContextComponent = PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        this.myModule = LangDataKeys.MODULE.getData(dataContext);
        Location<?> location = Location.DATA_KEY.getData(dataContext);
        if (location != null) {
            this.myLocation = location;
            Location<?>[] locations = Location.DATA_KEYS.getData(dataContext);
            this.myMultipleSelection = locations != null && locations.length > 1;
            return;
        }
        Project project = CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            this.myLocation = null;
            return;
        }
        PsiElement element = ConfigurationContext.getSelectedPsiElement(dataContext, project);
        if (element == null) {
            this.myLocation = null;
            return;
        }
        this.myLocation = new PsiLocation<PsiElement>(project, this.myModule, element);
        PsiElement[] elements = LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
        this.myMultipleSelection = elements != null ? elements.length > 1 : (files = CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext)) != null && files.length > 1;
    }

    public ConfigurationContext(PsiElement element) {
        this.myModule = ModuleUtilCore.findModuleForPsiElement(element);
        this.myLocation = new PsiLocation<PsiElement>(element.getProject(), this.myModule, element);
        this.myRuntimeConfiguration = null;
        this.myContextComponent = null;
    }

    public boolean containsMultipleSelection() {
        return this.myMultipleSelection;
    }

    @Nullable
    public synchronized RunnerAndConfigurationSettings getConfiguration() {
        if (this.myConfiguration == null && !this.myInitialized) {
            this.createConfiguration();
        }
        return this.myConfiguration;
    }

    private void createConfiguration() {
        LOG.assertTrue(this.myConfiguration == null);
        Location location = this.getLocation();
        this.myConfiguration = location != null && !DumbService.isDumb(location.getProject()) ? PreferredProducerFind.createConfiguration(location, this) : null;
        this.myInitialized = true;
    }

    public synchronized void setConfiguration(@NotNull RunnerAndConfigurationSettings configuration) {
        if (configuration == null) {
            ConfigurationContext.$$$reportNull$$$0(1);
        }
        this.myConfiguration = configuration;
        this.myInitialized = true;
    }

    @Deprecated
    @Nullable
    public RunnerAndConfigurationSettings updateConfiguration(RuntimeConfigurationProducer producer) {
        this.myConfiguration = producer.getConfiguration();
        return this.myConfiguration;
    }

    @Nullable
    public Location getLocation() {
        return this.myLocation;
    }

    @Nullable
    public PsiElement getPsiLocation() {
        return this.myLocation != null ? this.myLocation.getPsiElement() : null;
    }

    @Nullable
    public RunnerAndConfigurationSettings findExisting() {
        RunnerAndConfigurationSettings configuration;
        if (this.myExistingConfiguration != null) {
            return (RunnerAndConfigurationSettings)this.myExistingConfiguration.get();
        }
        this.myExistingConfiguration = new Ref();
        if (this.myLocation == null) {
            return null;
        }
        PsiElement psiElement = this.myLocation.getPsiElement();
        if (!psiElement.isValid()) {
            return null;
        }
        List<RuntimeConfigurationProducer> producers = this.findPreferredProducers();
        if (this.myRuntimeConfiguration != null) {
            if (producers != null) {
                for (RuntimeConfigurationProducer runtimeConfigurationProducer : producers) {
                    configuration = runtimeConfigurationProducer.findExistingConfiguration(this.myLocation, this);
                    if (configuration == null || configuration.getConfiguration() != this.myRuntimeConfiguration) continue;
                    this.myExistingConfiguration.set((Object)configuration);
                }
            }
            for (RunConfigurationProducer runConfigurationProducer : RunConfigurationProducer.getProducers(this.getProject())) {
                configuration = runConfigurationProducer.findExistingConfiguration(this);
                if (configuration == null || configuration.getConfiguration() != this.myRuntimeConfiguration) continue;
                this.myExistingConfiguration.set((Object)configuration);
            }
        }
        if (producers != null) {
            for (RuntimeConfigurationProducer runtimeConfigurationProducer : producers) {
                configuration = runtimeConfigurationProducer.findExistingConfiguration(this.myLocation, this);
                if (configuration == null) continue;
                this.myExistingConfiguration.set((Object)configuration);
            }
        }
        for (RunConfigurationProducer runConfigurationProducer : RunConfigurationProducer.getProducers(this.getProject())) {
            configuration = runConfigurationProducer.findExistingConfiguration(this);
            if (configuration == null) continue;
            this.myExistingConfiguration.set((Object)configuration);
        }
        return (RunnerAndConfigurationSettings)this.myExistingConfiguration.get();
    }

    @Nullable
    private static PsiElement getSelectedPsiElement(DataContext dataContext, Project project) {
        VirtualFile[] files;
        int offset;
        PsiFile psiFile;
        PsiElement element = null;
        Editor editor = CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null && (psiFile = PsiDocumentManager.getInstance(project).getPsiFile(editor.getDocument())) != null && (element = psiFile.findElementAt(offset = editor.getCaretModel().getOffset())) == null && offset > 0 && offset == psiFile.getTextLength()) {
            element = psiFile.findElementAt(offset - 1);
        }
        if (element == null) {
            PsiElement[] elements = LangDataKeys.PSI_ELEMENT_ARRAY.getData(dataContext);
            PsiElement psiElement = element = elements != null && elements.length > 0 ? elements[0] : null;
        }
        if (element == null && (files = CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext)) != null && files.length > 0) {
            element = PsiManager.getInstance(project).findFile(files[0]);
        }
        return element;
    }

    public RunManager getRunManager() {
        return RunManager.getInstance(this.getProject());
    }

    public Project getProject() {
        return this.myLocation.getProject();
    }

    public Module getModule() {
        return this.myModule;
    }

    public DataContext getDataContext() {
        return DataManager.getInstance().getDataContext(this.myContextComponent);
    }

    @Nullable
    public RunConfiguration getOriginalConfiguration(@Nullable ConfigurationType type) {
        if (type == null) {
            return this.myRuntimeConfiguration;
        }
        if (this.myRuntimeConfiguration != null && ConfigurationTypeUtil.equals(this.myRuntimeConfiguration.getType(), type)) {
            return this.myRuntimeConfiguration;
        }
        return null;
    }

    public boolean isCompatibleWithOriginalRunConfiguration(@NotNull ConfigurationType type) {
        if (type == null) {
            ConfigurationContext.$$$reportNull$$$0(2);
        }
        return this.myRuntimeConfiguration == null || ConfigurationTypeUtil.equals(this.myRuntimeConfiguration.getType(), type);
    }

    @Deprecated
    @Nullable
    public List<RuntimeConfigurationProducer> findPreferredProducers() {
        if (this.myPreferredProducers == null) {
            this.myPreferredProducers = PreferredProducerFind.findPreferredProducers(this.myLocation, this, true);
        }
        return this.myPreferredProducers;
    }

    @Nullable
    public List<ConfigurationFromContext> getConfigurationsFromContext() {
        if (this.myConfigurationsFromContext == null) {
            this.myConfigurationsFromContext = PreferredProducerFind.getConfigurationsFromContext(this.myLocation, this, true);
        }
        return this.myConfigurationsFromContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/actions/ConfigurationContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/actions/ConfigurationContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCompatibleWithOriginalRunConfiguration";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

