/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options;

import com.intellij.openapi.options.CompositeSettingsBuilder;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class GroupSettingsBuilder<T>
implements CompositeSettingsBuilder<T> {
    private final SettingsEditorGroup<T> myGroup;
    private JComponent myComponent;

    public GroupSettingsBuilder(SettingsEditorGroup<T> group) {
        this.myGroup = group;
    }

    @Override
    public Collection<SettingsEditor<T>> getEditors() {
        ArrayList<SettingsEditor<T>> result = new ArrayList<SettingsEditor<T>>();
        List<Pair<String, SettingsEditor<T>>> editors = this.myGroup.getEditors();
        for (int i = 0; i < editors.size(); ++i) {
            result.add((SettingsEditor<T>)editors.get(i).getSecond());
        }
        return result;
    }

    @Override
    public JComponent createCompoundEditor() {
        if (this.myComponent == null) {
            this.myComponent = this.doCreateComponent();
        }
        return this.myComponent;
    }

    private JComponent doCreateComponent() {
        List<Pair<String, SettingsEditor<T>>> editors = this.myGroup.getEditors();
        if (editors.size() == 0) {
            return new JPanel();
        }
        if (editors.size() == 1) {
            return ((SettingsEditor)editors.get(0).getSecond()).getComponent();
        }
        JBTabbedPane tabs = new JBTabbedPane();
        for (int i = 0; i < editors.size(); ++i) {
            Pair<String, SettingsEditor<T>> pair = editors.get(i);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)((SettingsEditor)pair.getSecond()).getComponent(), "Center");
            tabs.add((String)pair.getFirst(), panel);
        }
        return tabs;
    }

    public void selectEditor(String tabName) {
        List<Pair<String, SettingsEditor<T>>> editors = this.myGroup.getEditors();
        if (this.myComponent != null && editors.size() > 1) {
            for (int i = 0; i < editors.size(); ++i) {
                Pair<String, SettingsEditor<T>> pair = editors.get(i);
                if (!StringUtil.equals((CharSequence)tabName, (CharSequence)((CharSequence)pair.getFirst()))) continue;
                ((JTabbedPane)this.myComponent).setSelectedIndex(i);
                return;
            }
        }
    }
}

