/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.process;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.util.concurrency.Semaphore;
import java.io.IOException;
import java.util.concurrent.Future;

public class ProcessCloseUtil {
    private static final long ourSynchronousWaitTimeout = 1000L;
    private static final long ourAsynchronousWaitTimeout = 30000L;

    private ProcessCloseUtil() {
    }

    public static void close(Process process) {
        Semaphore outerSemaphore = new Semaphore();
        outerSemaphore.down();
        Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            try {
                Semaphore semaphore = new Semaphore();
                semaphore.down();
                Runnable closeRunnable = () -> {
                    try {
                        ProcessCloseUtil.closeProcessImpl(process);
                    }
                    finally {
                        semaphore.up();
                    }
                };
                Future<?> innerFuture = application.executeOnPooledThread(closeRunnable);
                semaphore.waitFor(30000L);
                if (!innerFuture.isDone() && !innerFuture.isCancelled()) {
                    innerFuture.cancel(true);
                }
            }
            finally {
                outerSemaphore.up();
            }
        });
        outerSemaphore.waitFor(1000L);
    }

    private static void closeProcessImpl(Process process) {
        try {
            process.getOutputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            process.getInputStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            process.getErrorStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        process.destroy();
    }
}

