/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.impl.VcsPathPresenter;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Change {
    private int myHash;
    private final ContentRevision myBeforeRevision;
    private final ContentRevision myAfterRevision;
    private final FileStatus myFileStatus;
    protected String myMoveRelativePath;
    protected boolean myRenamed;
    protected boolean myMoved;
    protected boolean myRenameOrMoveCached = false;
    private boolean myIsReplaced;
    private Type myType;
    private Map<String, Change> myOtherLayers;

    public Change(@Nullable ContentRevision beforeRevision, @Nullable ContentRevision afterRevision) {
        this(beforeRevision, afterRevision, Change.convertStatus(beforeRevision, afterRevision));
    }

    public Change(@Nullable ContentRevision beforeRevision, @Nullable ContentRevision afterRevision, @Nullable FileStatus fileStatus) {
        assert (beforeRevision != null || afterRevision != null);
        this.myBeforeRevision = beforeRevision;
        this.myAfterRevision = afterRevision;
        this.myFileStatus = fileStatus == null ? Change.convertStatus(beforeRevision, afterRevision) : fileStatus;
        this.myHash = -1;
        this.myOtherLayers = null;
    }

    private static FileStatus convertStatus(@Nullable ContentRevision beforeRevision, @Nullable ContentRevision afterRevision) {
        if (beforeRevision == null) {
            return FileStatus.ADDED;
        }
        if (afterRevision == null) {
            return FileStatus.DELETED;
        }
        return FileStatus.MODIFIED;
    }

    public void addAdditionalLayerElement(String name, Change change) {
        if (this.myOtherLayers == null) {
            this.myOtherLayers = new HashMap<String, Change>(1);
        }
        this.myOtherLayers.put(name, change);
    }

    @NotNull
    public Map<String, Change> getOtherLayers() {
        Map map = ContainerUtil.notNullize(this.myOtherLayers);
        if (map == null) {
            Change.$$$reportNull$$$0(0);
        }
        return map;
    }

    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            this.myType = type = this.calcType();
        }
        return type;
    }

    @NotNull
    private Type calcType() {
        String aPath;
        String bPath;
        FilePath aFile;
        if (this.myBeforeRevision == null) {
            Type type = Type.NEW;
            if (type == null) {
                Change.$$$reportNull$$$0(1);
            }
            return type;
        }
        if (this.myAfterRevision == null) {
            Type type = Type.DELETED;
            if (type == null) {
                Change.$$$reportNull$$$0(2);
            }
            return type;
        }
        FilePath bFile = this.myBeforeRevision.getFile();
        if (!Comparing.equal((Object)bFile, (Object)(aFile = this.myAfterRevision.getFile()))) {
            Type type = Type.MOVED;
            if (type == null) {
                Change.$$$reportNull$$$0(3);
            }
            return type;
        }
        if (!SystemInfo.isFileSystemCaseSensitive && !(bPath = bFile.getPath()).equals(aPath = aFile.getPath()) && bPath.equalsIgnoreCase(aPath)) {
            Type type = Type.MOVED;
            if (type == null) {
                Change.$$$reportNull$$$0(4);
            }
            return type;
        }
        Type type = Type.MODIFICATION;
        if (type == null) {
            Change.$$$reportNull$$$0(5);
        }
        return type;
    }

    @Nullable
    public ContentRevision getBeforeRevision() {
        return this.myBeforeRevision;
    }

    @Nullable
    public ContentRevision getAfterRevision() {
        return this.myAfterRevision;
    }

    @NotNull
    public FileStatus getFileStatus() {
        FileStatus fileStatus = this.myFileStatus;
        if (fileStatus == null) {
            Change.$$$reportNull$$$0(6);
        }
        return fileStatus;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myAfterRevision == null ? null : this.myAfterRevision.getFile().getVirtualFile();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof Change)) {
            return false;
        }
        Change otherChange = (Change)o;
        ContentRevision br1 = this.getBeforeRevision();
        ContentRevision br2 = otherChange.getBeforeRevision();
        ContentRevision ar1 = this.getAfterRevision();
        ContentRevision ar2 = otherChange.getAfterRevision();
        FilePath fbr1 = br1 != null ? br1.getFile() : null;
        FilePath fbr2 = br2 != null ? br2.getFile() : null;
        FilePath far1 = ar1 != null ? ar1.getFile() : null;
        FilePath far2 = ar2 != null ? ar2.getFile() : null;
        return Comparing.equal((Object)fbr1, (Object)fbr2) && Comparing.equal((Object)far1, (Object)far2);
    }

    public int hashCode() {
        if (this.myHash == -1) {
            this.myHash = this.calculateHash();
        }
        return this.myHash;
    }

    private int calculateHash() {
        return Change.revisionHashCode(this.getBeforeRevision()) * 27 + Change.revisionHashCode(this.getAfterRevision());
    }

    private static int revisionHashCode(@Nullable ContentRevision rev) {
        return rev != null ? rev.getFile().hashCode() : 0;
    }

    public boolean affectsFile(File ioFile) {
        if (this.myBeforeRevision != null && this.myBeforeRevision.getFile().getIOFile().equals(ioFile)) {
            return true;
        }
        return this.myAfterRevision != null && this.myAfterRevision.getFile().getIOFile().equals(ioFile);
    }

    public boolean isRenamed() {
        this.cacheRenameOrMove(null);
        return this.myRenamed;
    }

    public boolean isMoved() {
        this.cacheRenameOrMove(null);
        return this.myMoved;
    }

    public String getMoveRelativePath(Project project) {
        this.cacheRenameOrMove(project);
        return this.myMoveRelativePath;
    }

    private void cacheRenameOrMove(Project project) {
        if (this.myBeforeRevision != null && this.myAfterRevision != null && !this.revisionPathsSame()) {
            if (!this.myRenameOrMoveCached) {
                this.myRenameOrMoveCached = true;
                if (Comparing.equal((Object)this.myBeforeRevision.getFile().getParentPath(), (Object)this.myAfterRevision.getFile().getParentPath())) {
                    this.myRenamed = true;
                } else {
                    this.myMoved = true;
                }
            }
            if (this.myMoved && this.myMoveRelativePath == null && project != null) {
                this.myMoveRelativePath = VcsPathPresenter.getInstance(project).getPresentableRelativePath(this.myBeforeRevision, this.myAfterRevision);
            }
        }
    }

    private boolean revisionPathsSame() {
        String path1 = this.myBeforeRevision.getFile().getPath();
        String path2 = this.myAfterRevision.getFile().getPath();
        return path1.equals(path2);
    }

    @NonNls
    public String toString() {
        Type type = this.getType();
        switch (type) {
            case NEW: {
                return "A: " + this.myAfterRevision;
            }
            case DELETED: {
                return "D: " + this.myBeforeRevision;
            }
            case MOVED: {
                return "M: " + this.myBeforeRevision + " -> " + this.myAfterRevision;
            }
        }
        return "M: " + this.myAfterRevision;
    }

    @Nullable
    public String getOriginText(Project project) {
        this.cacheRenameOrMove(project);
        if (this.isMoved()) {
            return this.getMovedText(project);
        }
        if (this.isRenamed()) {
            return this.getRenamedText();
        }
        return this.myIsReplaced ? VcsBundle.message("change.file.replaced.text", new Object[0]) : null;
    }

    @Nullable
    protected String getRenamedText() {
        return VcsBundle.message("change.file.renamed.from.text", this.myBeforeRevision.getFile().getName());
    }

    @Nullable
    protected String getMovedText(Project project) {
        return VcsBundle.message("change.file.moved.from.text", this.getMoveRelativePath(project));
    }

    public boolean isIsReplaced() {
        return this.myIsReplaced;
    }

    public void setIsReplaced(boolean isReplaced) {
        this.myIsReplaced = isReplaced;
    }

    @Nullable
    public Icon getAdditionalIcon() {
        return null;
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/vcs/changes/Change";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOtherLayers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calcType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatus";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static enum Type {
        MODIFICATION,
        NEW,
        DELETED,
        MOVED;

    }
}

