/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.vcs.log.Hash;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcsMessages;
import org.zmlx.hg4idea.action.HgLogSingleCommitAction;
import org.zmlx.hg4idea.branch.HgBranchPopupActions;
import org.zmlx.hg4idea.command.HgUpdateCommand;
import org.zmlx.hg4idea.repo.HgRepository;
import org.zmlx.hg4idea.util.HgUtil;

public class HgCreateNewBranchFromLogAction
extends HgLogSingleCommitAction {
    protected void actionPerformed(final @NotNull HgRepository repository, final @NotNull Hash commit) {
        if (repository == null) {
            HgCreateNewBranchFromLogAction.$$$reportNull$$$0(0);
        }
        if (commit == null) {
            HgCreateNewBranchFromLogAction.$$$reportNull$$$0(1);
        }
        final Project project = repository.getProject();
        FileDocumentManager.getInstance().saveAllDocuments();
        String shortHash = commit.toShortString();
        final String name = HgUtil.getNewBranchNameFromUser(repository, "Create New Branch From " + shortHash);
        if (name != null) {
            new Task.Backgroundable(project, HgVcsMessages.message("hg4idea.progress.updatingTo", shortHash)){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (HgUpdateCommand.updateRepoToInCurrentThread(project, repository.getRoot(), commit.asString(), false)) {
                        new HgBranchPopupActions.HgNewBranchAction(project, Collections.singletonList(repository), repository).createNewBranchInCurrentThread(name);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/zmlx/hg4idea/action/HgCreateNewBranchFromLogAction$1", "run"));
                }
            }.queue();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "repository";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "commit";
                break;
            }
        }
        objectArray[1] = "org/zmlx/hg4idea/action/HgCreateNewBranchFromLogAction";
        objectArray[2] = "actionPerformed";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

