/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.match;

import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementEditorComponent;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchNodeComponentFactory;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRuleEditor;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesModel;
import com.intellij.application.options.codeStyle.arrangement.match.ArrangementMatchingRulesValidator;
import com.intellij.application.options.codeStyle.arrangement.match.EmptyArrangementRuleComponent;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementEditorAware;
import com.intellij.application.options.codeStyle.arrangement.ui.ArrangementRepresentationAware;
import com.intellij.application.options.codeStyle.arrangement.util.ArrangementListRowDecorator;
import com.intellij.application.options.codeStyle.arrangement.util.IntObjectMap;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.StdArrangementMatchRule;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementUiComponent;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.AbstractTableCellEditor;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class ArrangementMatchingRulesControl
extends JBTable {
    @NotNull
    private static final JLabel EMPTY_RENDERER = new JLabel(ApplicationBundle.message((String)"arrangement.text.empty.rule", (Object[])new Object[0]));
    @NotNull
    protected final IntObjectMap<ArrangementListRowDecorator> myComponents;
    @NotNull
    private final TIntArrayList mySelectedRows;
    @NotNull
    private final ArrangementMatchNodeComponentFactory myFactory;
    @NotNull
    protected ArrangementMatchingRuleEditor myEditor;
    @NotNull
    private final RepresentationCallback myRepresentationCallback;
    @NotNull
    private final MatchingRulesRendererBase myRenderer;
    private ArrangementMatchingRulesValidator myValidator;
    private final int myMinRowHeight;
    private int myRowUnderMouse;
    private int myEditorRow;
    private boolean mySkipSelectionChange;

    public ArrangementMatchingRulesControl(@NotNull ArrangementStandardSettingsManager settingsManager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull RepresentationCallback callback) {
        if (settingsManager == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(0);
        }
        if (colorsProvider == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(1);
        }
        if (callback == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(2);
        }
        super((TableModel)new ArrangementMatchingRulesModel());
        this.myComponents = new IntObjectMap();
        this.mySelectedRows = new TIntArrayList();
        this.myRowUnderMouse = -1;
        this.myEditorRow = -1;
        this.myRepresentationCallback = callback;
        this.myFactory = new ArrangementMatchNodeComponentFactory(settingsManager, colorsProvider, this);
        this.myRenderer = this.createRender();
        this.setDefaultRenderer(Object.class, this.myRenderer);
        this.getColumnModel().getColumn(0).setCellEditor((TableCellEditor)((Object)new MyEditor()));
        this.setSelectionMode(2);
        this.setShowColumns(false);
        this.setShowGrid(false);
        this.setSurrendersFocusOnKeystroke(true);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ArrangementAtomMatchCondition condition = new ArrangementAtomMatchCondition(StdArrangementTokens.EntryType.CLASS);
        StdArrangementMatchRule rule = new StdArrangementMatchRule(new StdArrangementEntryMatcher((ArrangementMatchCondition)condition));
        ArrangementUiComponent component = this.myFactory.getComponent((ArrangementMatchCondition)condition, rule, true);
        this.myMinRowHeight = new ArrangementListRowDecorator((ArrangementUiComponent)component, (ArrangementMatchingRulesControl)this).getPreferredSize().height;
        this.myEditor = new ArrangementMatchingRuleEditor(settingsManager, colorsProvider, this);
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ArrangementMatchingRulesControl.this.onMouseMoved(e);
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ArrangementMatchingRulesControl.this.onSelectionChange(e);
            }
        });
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ArrangementMatchingRulesControl.this.onTableChange(e);
            }
        });
    }

    protected MatchingRulesRendererBase createRender() {
        return new MatchingRulesRendererBase();
    }

    @NotNull
    protected ArrangementMatchingRulesValidator createValidator() {
        ArrangementMatchingRulesValidator arrangementMatchingRulesValidator = new ArrangementMatchingRulesValidator(this.getModel());
        if (arrangementMatchingRulesValidator == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(3);
        }
        return arrangementMatchingRulesValidator;
    }

    private ArrangementMatchingRulesValidator getValidator() {
        if (this.myValidator == null) {
            this.myValidator = this.createValidator();
        }
        return this.myValidator;
    }

    @NotNull
    public ArrangementMatchingRulesModel getModel() {
        ArrangementMatchingRulesModel arrangementMatchingRulesModel = (ArrangementMatchingRulesModel)super.getModel();
        if (arrangementMatchingRulesModel == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(4);
        }
        return arrangementMatchingRulesModel;
    }

    protected void processMouseEvent(MouseEvent e) {
        int id = e.getID();
        switch (id) {
            case 504: {
                this.onMouseEntered(e);
                break;
            }
            case 505: {
                this.onMouseExited();
                break;
            }
            case 502: {
                this.onMouseReleased(e);
                break;
            }
            case 500: {
                this.onMouseClicked(e);
            }
        }
        if (!e.isConsumed()) {
            super.processMouseEvent(e);
        }
    }

    private void onMouseClicked(@NotNull MouseEvent e) {
        int count;
        if (e == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(5);
        }
        if ((count = e.getClickCount()) != 2) {
            return;
        }
        TIntArrayList rows = this.getSelectedModelRows();
        if (rows.size() != 1) {
            return;
        }
        int row = rows.get(0);
        this.showEditor(row);
        this.scrollRowToVisible(row);
    }

    private void onMouseMoved(@NotNull MouseEvent e) {
        ArrangementListRowDecorator decorator;
        int i;
        if (e == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(6);
        }
        if ((i = this.rowAtPoint(e.getPoint())) != this.myRowUnderMouse) {
            this.onMouseExited();
        }
        if (i < 0) {
            return;
        }
        if (i != this.myRowUnderMouse) {
            this.onMouseEntered(e);
        }
        if ((decorator = this.myComponents.get(i)) == null) {
            return;
        }
        Rectangle rectangle = decorator.onMouseMove(e);
        if (rectangle != null) {
            this.repaintScreenBounds(rectangle);
        }
    }

    private void repaintScreenBounds(@NotNull Rectangle bounds) {
        if (bounds == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(7);
        }
        Point location = bounds.getLocation();
        SwingUtilities.convertPointFromScreen(location, (Component)((Object)this));
        int x = location.x;
        int width = bounds.width;
        this.repaint(x, location.y, width, bounds.height);
    }

    private void onMouseReleased(@NotNull MouseEvent e) {
        int i;
        if (e == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(8);
        }
        if ((i = this.rowAtPoint(e.getPoint())) < 0) {
            return;
        }
        ArrangementListRowDecorator decorator = this.myComponents.get(i);
        if (decorator != null) {
            decorator.onMouseRelease(e);
        }
        if (!e.isConsumed() && this.myEditorRow > 0 && this.myEditorRow == i + 1) {
            this.hideEditor();
        }
    }

    private void onMouseExited() {
        if (this.myRowUnderMouse < 0) {
            return;
        }
        ArrangementListRowDecorator decorator = this.myComponents.get(this.myRowUnderMouse);
        if (decorator != null) {
            decorator.onMouseExited();
            this.repaintRows(this.myRowUnderMouse, this.myRowUnderMouse, false);
        }
        this.myRowUnderMouse = -1;
    }

    private void onMouseEntered(@NotNull MouseEvent e) {
        if (e == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(9);
        }
        this.myRowUnderMouse = this.rowAtPoint(e.getPoint());
        ArrangementListRowDecorator decorator = this.myComponents.get(this.myRowUnderMouse);
        if (decorator != null) {
            decorator.onMouseEntered(e);
            this.repaintRows(this.myRowUnderMouse, this.myRowUnderMouse, false);
        }
    }

    public void runOperationIgnoreSelectionChange(@NotNull Runnable task2) {
        if (task2 == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(10);
        }
        this.mySkipSelectionChange = true;
        try {
            if (this.isEditing()) {
                this.getCellEditor().stopCellEditing();
            }
            task2.run();
        }
        finally {
            this.mySkipSelectionChange = false;
            this.refreshEditor();
        }
    }

    private void onSelectionChange(@NotNull ListSelectionEvent e) {
        if (e == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(11);
        }
        if (this.mySkipSelectionChange || e.getValueIsAdjusting()) {
            return;
        }
        this.refreshEditor();
    }

    public void removeRow(int rowIndex) {
        if (rowIndex < this.myEditorRow) {
            this.hideEditor();
        }
        this.getModel().removeRow(rowIndex);
    }

    public void refreshEditor() {
        ArrangementMatchingRulesModel model = this.getModel();
        if (this.myEditorRow >= model.getSize()) {
            this.myEditorRow = -1;
            int max = model.getSize();
            for (int i = 0; i < max; ++i) {
                if (!(model.getElementAt(i) instanceof ArrangementEditorComponent)) continue;
                this.myEditorRow = i;
                break;
            }
        }
        if (this.myEditorRow < 0) {
            return;
        }
        ListSelectionModel selectionModel = this.getSelectionModel();
        if (selectionModel.isSelectionEmpty()) {
            this.hideEditor();
            return;
        }
        int selectedRow = selectionModel.getMinSelectionIndex();
        if (selectedRow != selectionModel.getMaxSelectionIndex()) {
            this.hideEditor();
            return;
        }
        if (selectedRow != this.myEditorRow && selectedRow != this.myEditorRow - 1) {
            this.hideEditor();
        }
    }

    public void hideEditor() {
        TableCellEditor editor;
        if (this.myEditorRow < 0) {
            return;
        }
        if (this.isEditing() && (editor = this.getCellEditor()) != null) {
            editor.stopCellEditing();
        }
        this.mySkipSelectionChange = true;
        try {
            ArrangementMatchingRulesModel model = this.getModel();
            model.removeRow(this.myEditorRow);
            if (this.myEditorRow > 0 && model.getElementAt(this.myEditorRow - 1) instanceof EmptyArrangementRuleComponent) {
                model.removeRow(this.myEditorRow - 1);
            }
        }
        finally {
            this.mySkipSelectionChange = false;
        }
        this.myEditorRow = -1;
    }

    private void onTableChange(@NotNull TableModelEvent e) {
        int signum;
        if (e == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(12);
        }
        switch (e.getType()) {
            case 1: {
                signum = 1;
                break;
            }
            case -1: {
                signum = -1;
                for (int i = e.getLastRow(); i >= e.getFirstRow(); --i) {
                    this.myComponents.remove(i);
                }
                break;
            }
            default: {
                return;
            }
        }
        int shift = Math.abs(e.getFirstRow() - e.getLastRow() + 1) * signum;
        this.myComponents.shiftKeys(e.getFirstRow(), shift);
        if (this.myRowUnderMouse >= e.getFirstRow()) {
            this.myRowUnderMouse = -1;
        }
        if (this.getModel().getSize() > 0) {
            this.repaintRows(0, this.getModel().getSize() - 1, false);
        }
    }

    public void showEditor(int rowToEdit) {
        this.showEditor(this.myEditor, rowToEdit);
    }

    public void scrollRowToVisible(int row) {
        Rectangle rect = this.getCellRect(row, 0, false);
        if (row != this.getEditingRow() - 1) {
            this.scrollRectToVisible(rect);
        } else {
            Rectangle editorRect = this.getCellRect(row + 1, 0, false);
            if (!rect.isEmpty() && !editorRect.isEmpty()) {
                int height = (int)(rect.getHeight() + editorRect.getHeight());
                Rectangle visibleRect = new Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), height);
                this.scrollRectToVisible(visibleRect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showEditor(@NotNull ArrangementMatchingRuleEditor editor, int rowToEdit) {
        if (editor == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(13);
        }
        if (this.myEditorRow == rowToEdit + 1) {
            return;
        }
        if (this.myEditorRow >= 0) {
            if (this.myEditorRow < rowToEdit) {
                --rowToEdit;
            }
            this.hideEditor();
        }
        this.myEditorRow = rowToEdit + 1;
        ArrangementEditorComponent editorComponent = new ArrangementEditorComponent(this, this.myEditorRow, editor);
        editorComponent.applyAvailableWidth(this.getWidth());
        editor.reset(rowToEdit);
        this.mySkipSelectionChange = true;
        try {
            this.getModel().insertRow(this.myEditorRow, new Object[]{editorComponent});
        }
        finally {
            this.mySkipSelectionChange = false;
        }
        Rectangle bounds = this.getRowsBounds(rowToEdit, this.myEditorRow);
        if (bounds != null) {
            this.myRepresentationCallback.ensureVisible(bounds);
        }
        editorComponent.expand();
        this.repaintRows(rowToEdit, this.getModel().getRowCount() - 1, false);
        this.editCellAt(this.myEditorRow, 0);
    }

    public void repaintRows(int first, int last, boolean rowStructureChanged) {
        for (int i = first; i <= last; ++i) {
            if (rowStructureChanged) {
                this.myComponents.remove(i);
                continue;
            }
            this.setRowHeight(i, this.myRenderer.getRendererComponent((int)i).getPreferredSize().height);
        }
        this.getModel().fireTableRowsUpdated(first, last);
    }

    private Rectangle getRowsBounds(int first, int last) {
        Rectangle firstRect = this.getCellRect(first, 0, true);
        Rectangle lastRect = this.getCellRect(last, 0, true);
        return new Rectangle(firstRect.x, firstRect.y, lastRect.width, lastRect.y + lastRect.height - firstRect.y);
    }

    @NotNull
    public TIntArrayList getSelectedModelRows() {
        this.mySelectedRows.clear();
        int min = this.selectionModel.getMinSelectionIndex();
        if (min >= 0) {
            for (int i = this.selectionModel.getMaxSelectionIndex(); i >= min; --i) {
                if ((this.myEditorRow < 0 || i != this.myEditorRow - 1) && (i == this.myEditorRow || !this.selectionModel.isSelectedIndex(i))) continue;
                this.mySelectedRows.add(i);
            }
        } else if (this.myEditorRow > 0) {
            this.mySelectedRows.add(this.myEditorRow - 1);
        }
        TIntArrayList tIntArrayList = this.mySelectedRows;
        if (tIntArrayList == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(14);
        }
        return tIntArrayList;
    }

    public int getRowByRenderer(@NotNull ArrangementListRowDecorator renderer) {
        if (renderer == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(15);
        }
        int max = this.getModel().getSize();
        for (int i = 0; i < max; ++i) {
            if (this.myComponents.get(i) != renderer) continue;
            return i;
        }
        return -1;
    }

    public int getEmptyRowHeight() {
        return this.myMinRowHeight;
    }

    @NotNull
    private JComponent adjustHeight(@NotNull JComponent component, int row) {
        int height;
        if (component == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(16);
        }
        if ((height = component.getPreferredSize().height) < this.myMinRowHeight) {
            height = this.myMinRowHeight;
        }
        this.setRowHeight(row, height);
        JComponent jComponent = component;
        if (jComponent == null) {
            ArrangementMatchingRulesControl.$$$reportNull$$$0(17);
        }
        return jComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 14: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 14: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 3: 
            case 4: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/match/ArrangementMatchingRulesControl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createValidator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedModelRows";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustHeight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 14: 
            case 17: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onMouseClicked";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onMouseMoved";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "repaintScreenBounds";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onMouseReleased";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onMouseEntered";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runOperationIgnoreSelectionChange";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onSelectionChange";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "onTableChange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showEditor";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getRowByRenderer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "adjustHeight";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 14: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface RepresentationCallback {
        public void ensureVisible(@NotNull Rectangle var1);
    }

    private class MyEditor
    extends AbstractTableCellEditor {
        private int myRow;

        private MyEditor() {
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof ArrangementEditorAware) {
                this.myRow = row;
                return ((ArrangementEditorAware)value).getComponent();
            }
            return null;
        }

        public Object getCellEditorValue() {
            return this.myRow < ArrangementMatchingRulesControl.this.getModel().getSize() ? ArrangementMatchingRulesControl.this.getModel().getElementAt(this.myRow) : null;
        }
    }

    protected class MatchingRulesRendererBase
    implements TableCellRenderer {
        protected MatchingRulesRendererBase() {
        }

        public Component getRendererComponent(int row) {
            return this.getTableCellRendererComponent((JTable)((Object)ArrangementMatchingRulesControl.this), ArrangementMatchingRulesControl.this.getModel().getElementAt(row), false, false, row, 0);
        }

        public boolean allowModifications(StdArrangementMatchRule rule) {
            return true;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (ArrangementMatchingRulesControl.this.isEditing() && ArrangementMatchingRulesControl.this.getEditingRow() == row) {
                return EMPTY_RENDERER;
            }
            if (value instanceof ArrangementRepresentationAware) {
                return ArrangementMatchingRulesControl.this.adjustHeight(((ArrangementRepresentationAware)value).getComponent(), row);
            }
            ArrangementListRowDecorator component = ArrangementMatchingRulesControl.this.myComponents.get(row);
            if (component == null) {
                if (!(value instanceof StdArrangementMatchRule)) {
                    return EMPTY_RENDERER;
                }
                StdArrangementMatchRule rule = (StdArrangementMatchRule)value;
                boolean allowModifications = this.allowModifications(rule);
                ArrangementUiComponent ruleComponent = ArrangementMatchingRulesControl.this.myFactory.getComponent(rule.getMatcher().getCondition(), rule, allowModifications);
                component = new ArrangementListRowDecorator(ruleComponent, ArrangementMatchingRulesControl.this);
                component.setError(ArrangementMatchingRulesControl.this.getValidator().validate(row));
                ArrangementMatchingRulesControl.this.myComponents.set(row, component);
            }
            component.setUnderMouse(ArrangementMatchingRulesControl.this.myRowUnderMouse == row);
            component.setRowIndex(ArrangementMatchingRulesControl.this.myEditorRow >= 0 && row > ArrangementMatchingRulesControl.this.myEditorRow ? row : row + 1);
            component.setSelected(ArrangementMatchingRulesControl.this.getSelectionModel().isSelectedIndex(row) || ArrangementMatchingRulesControl.this.myEditorRow >= 0 && row == ArrangementMatchingRulesControl.this.myEditorRow - 1);
            component.setBeingEdited(ArrangementMatchingRulesControl.this.myEditorRow >= 0 && ArrangementMatchingRulesControl.this.myEditorRow == row + 1);
            boolean showSortIcon = value instanceof StdArrangementMatchRule && StdArrangementTokens.Order.BY_NAME.equals((Object)((StdArrangementMatchRule)value).getOrderType());
            component.setShowSortIcon(showSortIcon);
            return component.getUiComponent();
        }
    }
}

