/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.actions;

import com.intellij.codeInsight.actions.FormatChangedTextUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.Range;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.diff.FilesTooBigForDiffException;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class VcsAwareFormatChangedTextUtil
extends FormatChangedTextUtil {
    VcsAwareFormatChangedTextUtil() {
    }

    @Override
    @NotNull
    public List<TextRange> getChangedTextRanges(@NotNull Project project, @NotNull PsiFile file2) throws FilesTooBigForDiffException {
        ChangedRangesInfo helper;
        if (project == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(1);
        }
        List list2 = (helper = this.getChangedRangesInfo(file2)) != null ? helper.allChangedRanges : ContainerUtil.newArrayList();
        if (list2 == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    @Nullable
    public ChangedRangesInfo getChangedRangesInfo(@NotNull PsiFile file2) throws FilesTooBigForDiffException {
        CharSequence testContent;
        Project project;
        Document document;
        if (file2 == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(3);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = file2.getProject())).getDocument(file2)) == null) {
            return null;
        }
        ChangedRangesInfo cachedChangedTextHelper = VcsAwareFormatChangedTextUtil.getCachedChangedLines(project, document);
        if (cachedChangedTextHelper != null) {
            return cachedChangedTextHelper;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (testContent = (CharSequence)file2.getUserData(TEST_REVISION_CONTENT)) != null) {
            return VcsAwareFormatChangedTextUtil.calculateContextReformatHelper(document, testContent);
        }
        Change change = ChangeListManager.getInstance((Project)project).getChange(file2.getVirtualFile());
        if (change == null) {
            return null;
        }
        if (change.getType() == Change.Type.NEW) {
            TextRange fileRange = file2.getTextRange();
            return new ChangedRangesInfo((List)ContainerUtil.newArrayList((Object[])new TextRange[]{fileRange}), null);
        }
        String contentFromVcs = VcsAwareFormatChangedTextUtil.getRevisionedContentFrom(change);
        return contentFromVcs != null ? VcsAwareFormatChangedTextUtil.calculateContextReformatHelper(document, contentFromVcs) : null;
    }

    @Nullable
    private static String getRevisionedContentFrom(@NotNull Change change) {
        ContentRevision revision;
        if (change == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(4);
        }
        if ((revision = change.getBeforeRevision()) == null) {
            return null;
        }
        try {
            return revision.getContent();
        }
        catch (VcsException e) {
            LOG.error("Can't get content for: " + change.getVirtualFile(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static ChangedRangesInfo getCachedChangedLines(@NotNull Project project, @NotNull Document document) {
        List<Range> ranges;
        LineStatusTracker tracker;
        if (project == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(5);
        }
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(6);
        }
        if ((tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(document)) != null && (ranges = tracker.getRanges()) != null) {
            return VcsAwareFormatChangedTextUtil.getChangedTextRanges(document, ranges);
        }
        return null;
    }

    @NotNull
    protected static ChangedRangesInfo calculateContextReformatHelper(@NotNull Document document, @NotNull CharSequence contentFromVcs) throws FilesTooBigForDiffException {
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(7);
        }
        if (contentFromVcs == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(8);
        }
        ChangedRangesInfo changedRangesInfo = VcsAwareFormatChangedTextUtil.getChangedTextRanges(document, VcsAwareFormatChangedTextUtil.getRanges(document, contentFromVcs));
        if (changedRangesInfo == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(9);
        }
        return changedRangesInfo;
    }

    @NotNull
    private static List<Range> getRanges(@NotNull Document document, @NotNull CharSequence contentFromVcs) throws FilesTooBigForDiffException {
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(10);
        }
        if (contentFromVcs == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(11);
        }
        Document documentFromVcs = ((EditorFactoryImpl)EditorFactory.getInstance()).createDocument(contentFromVcs, true, false);
        List<Range> list2 = RangesBuilder.createRanges(document, documentFromVcs);
        if (list2 == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(12);
        }
        return list2;
    }

    @Override
    public int calculateChangedLinesNumber(@NotNull Document document, @NotNull CharSequence contentFromVcs) {
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(13);
        }
        if (contentFromVcs == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(14);
        }
        try {
            List<Range> changedRanges = VcsAwareFormatChangedTextUtil.getRanges(document, contentFromVcs);
            int linesChanges = 0;
            for (Range range : changedRanges) {
                linesChanges += VcsAwareFormatChangedTextUtil.countLines(range);
            }
            return linesChanges;
        }
        catch (FilesTooBigForDiffException e) {
            LOG.info("File too big, can not calculate changed lines number");
            return -1;
        }
    }

    private static int countLines(Range range) {
        byte rangeType = range.getType();
        if (rangeType == 1) {
            int currentChangedLines = range.getLine2() - range.getLine1();
            int revisionLinesChanged = range.getVcsLine2() - range.getVcsLine1();
            return Math.max(currentChangedLines, revisionLinesChanged);
        }
        if (rangeType == 3) {
            return range.getVcsLine2() - range.getVcsLine1();
        }
        if (rangeType == 2) {
            return range.getLine2() - range.getLine1();
        }
        return 0;
    }

    @NotNull
    private static ChangedRangesInfo getChangedTextRanges(@NotNull Document document, @NotNull List<Range> changedRanges) {
        if (document == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(15);
        }
        if (changedRanges == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(16);
        }
        ArrayList ranges = ContainerUtil.newArrayList();
        ArrayList insertedRanges = ContainerUtil.newArrayList();
        for (Range range : changedRanges) {
            if (range.getType() == 3) continue;
            int changeStartLine = range.getLine1();
            int changeEndLine = range.getLine2();
            int lineStartOffset = document.getLineStartOffset(changeStartLine);
            int lineEndOffset = document.getLineEndOffset(changeEndLine - 1);
            TextRange changedTextRange = new TextRange(lineStartOffset, lineEndOffset);
            ranges.add(changedTextRange);
            if (range.getType() != 2) continue;
            insertedRanges.add(changedTextRange);
        }
        ChangedRangesInfo changedRangesInfo = new ChangedRangesInfo((List)ranges, (List)insertedRanges);
        if (changedRangesInfo == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(17);
        }
        return changedRangesInfo;
    }

    @Override
    public boolean isChangeNotTrackedForFile(@NotNull Project project, @NotNull PsiFile file2) {
        boolean isUnderVcs;
        if (project == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            VcsAwareFormatChangedTextUtil.$$$reportNull$$$0(19);
        }
        if (!(isUnderVcs = VcsUtil.isFileUnderVcs((Project)project, (FilePath)VcsUtil.getFilePath((VirtualFile)file2.getVirtualFile())))) {
            return true;
        }
        ChangeListManagerImpl changeListManager = ChangeListManagerImpl.getInstanceImpl(project);
        List<VirtualFile> unversionedFiles = changeListManager.getUnversionedFiles();
        return unversionedFiles.contains(file2.getVirtualFile());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 12: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 12: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 9: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentFromVcs";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changedRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/actions/VcsAwareFormatChangedTextUtil";
                break;
            }
            case 2: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedTextRanges";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateContextReformatHelper";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getChangedTextRanges";
                break;
            }
            case 2: 
            case 9: 
            case 12: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChangedRangesInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRevisionedContentFrom";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCachedChangedLines";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "calculateContextReformatHelper";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getRanges";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calculateChangedLinesNumber";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isChangeNotTrackedForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 12: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

