/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.hint.TooltipGroup;
import com.intellij.openapi.editor.Editor;
import com.intellij.ui.HintHint;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class DaemonTooltipUtil {
    private static final TooltipGroup DAEMON_INFO_GROUP = new TooltipGroup("DAEMON_INFO_GROUP", 0);

    public static void showInfoTooltip(HighlightInfo info, Editor editor, int defaultOffset) {
        DaemonTooltipUtil.showInfoTooltip(info, editor, defaultOffset, -1);
    }

    public static void cancelTooltips() {
        TooltipController.getInstance().cancelTooltip(DAEMON_INFO_GROUP, null, true);
    }

    public static void showInfoTooltip(@NotNull HighlightInfo info, @NotNull Editor editor, int defaultOffset, int currentWidth) {
        if (info == null) {
            DaemonTooltipUtil.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            DaemonTooltipUtil.$$$reportNull$$$0(1);
        }
        DaemonTooltipUtil.showInfoTooltip(info, editor, defaultOffset, currentWidth, false);
    }

    public static void showInfoTooltip(@NotNull HighlightInfo info, @NotNull Editor editor, int defaultOffset, int currentWidth, boolean requestFocus) {
        if (info == null) {
            DaemonTooltipUtil.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            DaemonTooltipUtil.$$$reportNull$$$0(3);
        }
        if (info.getToolTip() == null) {
            return;
        }
        Rectangle visibleArea = editor.getScrollingModel().getVisibleArea();
        Point point = editor.logicalPositionToXY(editor.offsetToLogicalPosition(defaultOffset));
        Point highlightEndPoint = editor.logicalPositionToXY(editor.offsetToLogicalPosition(info.endOffset));
        if (highlightEndPoint.y > point.y) {
            if (highlightEndPoint.x > point.x) {
                point = new Point(point.x, highlightEndPoint.y);
            } else if (highlightEndPoint.y > point.y + editor.getLineHeight()) {
                point = new Point(point.x, highlightEndPoint.y - editor.getLineHeight());
            }
        }
        Point bestPoint = new Point(point);
        bestPoint.y += editor.getLineHeight() / 2;
        if (!visibleArea.contains(bestPoint)) {
            bestPoint = point;
        }
        Point p = SwingUtilities.convertPoint(editor.getContentComponent(), bestPoint, editor.getComponent().getRootPane().getLayeredPane());
        HintHint hintHint = new HintHint(editor, bestPoint).setAwtTooltip(true).setHighlighterType(true).setRequestFocus(requestFocus).setCalloutShift(editor.getLineHeight() / 2 - 1);
        TooltipController.getInstance().showTooltip(editor, p, info.getToolTip(), currentWidth, false, DAEMON_INFO_GROUP, hintHint);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "info";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/daemon/impl/DaemonTooltipUtil";
        objectArray[2] = "showInfoTooltip";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

