/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.SuppressableInspectionTreeNode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.Alarm;
import com.intellij.util.Processor;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class InspectionViewPsiTreeChangeAdapter
extends PsiTreeChangeAdapter {
    private static final int MAX_UPDATES_FOR_CANCELLABLE_ACTION = 100;
    private final InspectionResultsView myView;
    private final MergingUpdateQueue myUpdater;
    private final Alarm myAlarm;

    public InspectionViewPsiTreeChangeAdapter(final @NotNull InspectionResultsView view) {
        if (view == null) {
            InspectionViewPsiTreeChangeAdapter.$$$reportNull$$$0(0);
        }
        this.myView = view;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)view);
        this.myUpdater = new MergingUpdateQueue("inspection.view.psi.update.listener", 300, true, this.myView, this.myView, this.myView, Alarm.ThreadToUse.POOLED_THREAD){

            protected void execute(final @NotNull Update[] updates) {
                if (updates == null) {
                    1.$$$reportNull$$$0(0);
                }
                ReadTask task2 = new ReadTask(){

                    @Override
                    public void computeInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        indicator.setText("Updating inspection view tree...");
                        HashSet files = new HashSet();
                        for (Update update : updates) {
                            VirtualFile file2 = (VirtualFile)update.getEqualityObjects()[0];
                            VfsUtilCore.iterateChildrenRecursively((VirtualFile)file2, (VirtualFileFilter)VirtualFileFilter.ALL, ((Set)files)::add);
                        }
                        Project project = view.getProject();
                        Runnable runnable2 = () -> this.lambda$computeInReadAction$2(view, (Set)files, project);
                        if (updates.length > 100) {
                            ProgressManager.getInstance().executeNonCancelableSection(runnable2);
                        } else {
                            runnable2.run();
                        }
                    }

                    @Override
                    public void onCanceled(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (!InspectionViewPsiTreeChangeAdapter.this.myView.isDisposed()) {
                            for (Update update : updates) {
                                InspectionViewPsiTreeChangeAdapter.this.myUpdater.queue(update);
                            }
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    private /* synthetic */ void lambda$computeInReadAction$2(@NotNull InspectionResultsView view, Set files, Project project) {
                        if (view == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (view.isDisposed()) {
                            return;
                        }
                        Object object = InspectionViewPsiTreeChangeAdapter.this.myView.getTreeStructureUpdateLock();
                        synchronized (object) {
                            InspectionTreeNode root = InspectionViewPsiTreeChangeAdapter.this.myView.getTree().getRoot();
                            boolean[] needUpdateUI = new boolean[]{false};
                            InspectionViewPsiTreeChangeAdapter.processNodesIfNeed(root, (Processor<InspectionTreeNode>)node -> {
                                if (node instanceof SuppressableInspectionTreeNode) {
                                    RefEntity element = ((SuppressableInspectionTreeNode)node).getElement();
                                    if (element instanceof RefElement) {
                                        PsiFile file2;
                                        SmartPsiElementPointer pointer = ((RefElement)element).getPointer();
                                        VirtualFile strictVirtualFile = pointer.getVirtualFile();
                                        if ((strictVirtualFile == null || !strictVirtualFile.isValid()) && (file2 = pointer.getContainingFile()) != null && file2.isValid()) {
                                            strictVirtualFile = file2.getVirtualFile();
                                        }
                                        if (strictVirtualFile == null || files.contains(strictVirtualFile)) {
                                            ((SuppressableInspectionTreeNode)node).dropCache(project);
                                            if (!needUpdateUI[0]) {
                                                needUpdateUI[0] = true;
                                            }
                                        }
                                        return false;
                                    }
                                    ((SuppressableInspectionTreeNode)node).dropCache(project);
                                    if (!needUpdateUI[0]) {
                                        needUpdateUI[0] = true;
                                    }
                                    return false;
                                }
                                return true;
                            });
                            if (needUpdateUI[0] && !InspectionViewPsiTreeChangeAdapter.this.myAlarm.isDisposed()) {
                                InspectionViewPsiTreeChangeAdapter.this.myAlarm.cancelAllRequests();
                                InspectionViewPsiTreeChangeAdapter.this.myAlarm.addRequest(() -> InspectionViewPsiTreeChangeAdapter.this.myView.resetTree(), 100, ModalityState.NON_MODAL);
                            }
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "indicator";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "view";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/codeInspection/ui/InspectionViewPsiTreeChangeAdapter$1$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "computeInReadAction";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onCanceled";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray2;
                                objectArray2[2] = "lambda$computeInReadAction$2";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
                ProgressIndicatorUtils.scheduleWithWriteActionPriority(InspectionViewPsiTreeChangeAdapter.this.myView.getTreeUpdater(), task2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "updates", "com/intellij/codeInspection/ui/InspectionViewPsiTreeChangeAdapter$1", "execute"));
            }
        };
    }

    public void childAdded(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            InspectionViewPsiTreeChangeAdapter.$$$reportNull$$$0(1);
        }
        this.processEventFileOrDir(event, false);
    }

    public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            InspectionViewPsiTreeChangeAdapter.$$$reportNull$$$0(2);
        }
        this.processEventFileOrDir(event, true);
    }

    public void beforeChildReplacement(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            InspectionViewPsiTreeChangeAdapter.$$$reportNull$$$0(3);
        }
        this.processEventFileOrDir(event, true);
    }

    public void childMoved(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            InspectionViewPsiTreeChangeAdapter.$$$reportNull$$$0(4);
        }
        this.processEventFileOrDir(event, false);
    }

    public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            InspectionViewPsiTreeChangeAdapter.$$$reportNull$$$0(5);
        }
        this.processEventFileOrDir(event, false);
    }

    public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
        if (event == null) {
            InspectionViewPsiTreeChangeAdapter.$$$reportNull$$$0(6);
        }
        this.processEventFileOrDir(event, false);
    }

    private void processEventFileOrDir(@NotNull PsiTreeChangeEvent event, boolean eagerEvaluateFiles) {
        PsiFile file2;
        if (event == null) {
            InspectionViewPsiTreeChangeAdapter.$$$reportNull$$$0(7);
        }
        if ((file2 = event.getFile()) != null) {
            VirtualFile vFile = file2.getVirtualFile();
            if (vFile == null) {
                return;
            }
            this.invalidateFiles(vFile);
        } else {
            VirtualFile childFile;
            PsiElement child = event.getChild();
            if (child instanceof PsiFileSystemItem && (childFile = ((PsiFileSystemItem)child).getVirtualFile()) != null) {
                if (eagerEvaluateFiles) {
                    HashSet files = new HashSet();
                    VfsUtilCore.iterateChildrenRecursively((VirtualFile)childFile, (VirtualFileFilter)VirtualFileFilter.ALL, ((Set)files)::add);
                    this.invalidateFiles(files.toArray(new VirtualFile[files.size()]));
                } else {
                    this.invalidateFiles(childFile);
                }
            }
        }
    }

    private static void processNodesIfNeed(InspectionTreeNode node, Processor<InspectionTreeNode> processor2) {
        if (processor2.process((Object)node)) {
            int count = node.getChildCount();
            for (int i = 0; i < count; ++i) {
                InspectionViewPsiTreeChangeAdapter.processNodesIfNeed((InspectionTreeNode)node.getChildAt(i), processor2);
            }
        }
    }

    private void invalidateFiles(VirtualFile ... files) {
        for (VirtualFile file2 : files) {
            this.myUpdater.queue(new Update(file2){

                public void run() {
                }

                public boolean canEat(Update update) {
                    return false;
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInspection/ui/InspectionViewPsiTreeChangeAdapter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "childAdded";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeChildRemoval";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeChildReplacement";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "childMoved";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "childrenChanged";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "propertyChanged";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processEventFileOrDir";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

