/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.html.impl;

import com.intellij.html.index.Html5CustomAttributesIndex;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptorsProvider;
import com.intellij.xml.impl.schema.AnyXmlAttributeDescriptor;
import com.intellij.xml.util.HtmlUtil;
import java.util.ArrayList;
import java.util.Collection;

public class Html5CustomAttributeDescriptorsProvider
implements XmlAttributeDescriptorsProvider {
    @Override
    public XmlAttributeDescriptor[] getAttributeDescriptors(XmlTag tag) {
        if (tag == null || !HtmlUtil.isHtml5Context((XmlElement)tag)) {
            return XmlAttributeDescriptor.EMPTY;
        }
        ArrayList<String> currentAttrs = new ArrayList<String>();
        for (XmlAttribute attribute : tag.getAttributes()) {
            currentAttrs.add(attribute.getName());
        }
        Project project = tag.getProject();
        Collection keys = (Collection)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            Collection keys1 = FileBasedIndex.getInstance().getAllKeys(Html5CustomAttributesIndex.INDEX_ID, project);
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            return CachedValueProvider.Result.create((Object)ContainerUtil.filter((Collection)keys1, key -> !FileBasedIndex.getInstance().processValues(Html5CustomAttributesIndex.INDEX_ID, key, null, (file2, value) -> false, scope)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        if (keys.isEmpty()) {
            return XmlAttributeDescriptor.EMPTY;
        }
        ArrayList<AnyXmlAttributeDescriptor> result2 = new ArrayList<AnyXmlAttributeDescriptor>();
        for (String key : keys) {
            boolean add = true;
            for (String attr : currentAttrs) {
                if (!attr.startsWith(key)) continue;
                add = false;
            }
            if (!add) continue;
            result2.add(new AnyXmlAttributeDescriptor(key));
        }
        return result2.toArray(new XmlAttributeDescriptor[result2.size()]);
    }

    @Override
    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, XmlTag context) {
        if (context != null && HtmlUtil.isCustomHtml5Attribute(attributeName) && HtmlUtil.tagHasHtml5Schema(context)) {
            return new AnyXmlAttributeDescriptor(attributeName);
        }
        return null;
    }
}

